/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.helper.path;

import com.builtbroken.mc.lib.helper.path.IPathCallBack;
import com.builtbroken.mc.lib.helper.path.Pathfinder;
import com.builtbroken.mc.lib.transform.vector.Pos;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraftforge.common.util.ForgeDirection;

public class PathfinderAStar
extends Pathfinder {
    public Set<Pos> openSet;
    public HashMap<Pos, Pos> navigationMap;
    public HashMap<Pos, Double> gScore;
    public HashMap<Pos, Double> fScore;
    public Pos goal;

    public PathfinderAStar(IPathCallBack callBack, Pos goal) {
        super(callBack);
        this.goal = goal;
    }

    @Override
    public boolean findNodes(Pos start) {
        this.reset();
        this.openSet.add(start);
        this.gScore.put(start, 0.0);
        this.fScore.put(start, this.gScore.get(start) + this.getHeuristicEstimatedCost(start, this.goal));
        while (!this.openSet.isEmpty()) {
            Pos currentNode = null;
            double lowestFScore = 0.0;
            for (Pos node : this.openSet) {
                if (currentNode != null && !(this.fScore.get(node) < lowestFScore)) continue;
                currentNode = node;
                lowestFScore = this.fScore.get(node);
            }
            if (currentNode == null) break;
            if (this.callBackCheck.onSearch(this, start, currentNode)) {
                return false;
            }
            if (currentNode.equals(this.goal)) {
                this.results = this.reconstructPath(this.navigationMap, this.goal);
                return true;
            }
            this.openSet.remove(currentNode);
            this.closedSet.add(currentNode);
            for (Pos neighbor : this.getNeighborNodes(currentNode)) {
                double tentativeGScore = this.gScore.get(currentNode) + currentNode.distance(neighbor);
                if (this.closedSet.contains(neighbor) && tentativeGScore >= this.gScore.get(neighbor) || this.openSet.contains(neighbor) && !(tentativeGScore < this.gScore.get(neighbor))) continue;
                this.navigationMap.put(neighbor, currentNode);
                this.gScore.put(neighbor, tentativeGScore);
                this.fScore.put(neighbor, this.gScore.get(neighbor) + this.getHeuristicEstimatedCost(neighbor, this.goal));
                this.openSet.add(neighbor);
            }
        }
        return false;
    }

    @Override
    public Pathfinder reset() {
        this.openSet = new HashSet<Pos>();
        this.navigationMap = new HashMap();
        this.gScore = new HashMap();
        this.fScore = new HashMap();
        return super.reset();
    }

    public List<Pos> reconstructPath(HashMap<Pos, Pos> nagivationMap, Pos current_node) {
        LinkedList<Pos> path = new LinkedList<Pos>();
        path.add(current_node);
        if (nagivationMap.containsKey(current_node)) {
            path.addAll(this.reconstructPath(nagivationMap, nagivationMap.get(current_node)));
            return path;
        }
        return path;
    }

    public double getHeuristicEstimatedCost(Pos start, Pos goal) {
        return start.distance(goal);
    }

    public Set<Pos> getNeighborNodes(Pos vector) {
        if (this.callBackCheck != null) {
            return this.callBackCheck.getConnectedNodes(this, vector);
        }
        HashSet<Pos> neighbors = new HashSet<Pos>();
        for (int i = 0; i < 6; ++i) {
            neighbors.add(vector.clone().add(ForgeDirection.getOrientation((int)i)));
        }
        return neighbors;
    }
}

