/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.mod.compat.energy;

import com.builtbroken.mc.lib.mod.compat.energy.EnergySystem;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyHandler {
    public static final double redstoneFluxRatio = 1.0;
    public static final Set<EnergySystem> loadedModules = new LinkedHashSet<EnergySystem>();
    public static final HashMap<Class, EnergySystem> energyHandlerCache = new HashMap();
    public static final HashMap<Class, EnergySystem> energyStorageCache = new HashMap();

    public static void register(EnergySystem module) {
        loadedModules.add(module);
    }

    public static EnergySystem getHandler(Object handler, ForgeDirection dir) {
        if (EnergyHandler.isHandler(handler, dir)) {
            return energyHandlerCache.get(handler.getClass());
        }
        return null;
    }

    public static boolean isHandler(Object handler, ForgeDirection dir) {
        if (handler != null) {
            Class<?> clazz;
            Class<?> clazz2 = clazz = handler instanceof ItemStack ? ((ItemStack)handler).func_77973_b().getClass() : handler.getClass();
            if (energyHandlerCache.containsKey(clazz)) {
                return true;
            }
            for (EnergySystem module : loadedModules) {
                if (!module.doIsHandler(handler, dir)) continue;
                energyHandlerCache.put(clazz, module);
                return true;
            }
        }
        return false;
    }

    public static EnergySystem getContainer(Object handler) {
        if (EnergyHandler.isEnergyContainer(handler)) {
            return energyStorageCache.get(handler.getClass());
        }
        return null;
    }

    public static boolean isEnergyContainer(Object handler) {
        if (handler != null) {
            Class<?> clazz = handler.getClass();
            if (energyStorageCache.containsKey(clazz)) {
                return true;
            }
            for (EnergySystem module : loadedModules) {
                if (!module.doIsEnergyContainer(handler)) continue;
                energyStorageCache.put(clazz, module);
                return true;
            }
        }
        return false;
    }

    public static boolean canConnect(Object obj, ForgeDirection direction, Object source) {
        EnergySystem module = EnergyHandler.getHandler(obj, direction);
        return module != null && module.canConnect(obj, direction, source);
    }

    public static double fill(Object handler, ForgeDirection direction, double energy, boolean doReceive) {
        return EnergyHandler.receiveEnergy(handler, direction, energy, doReceive);
    }

    public static double receiveEnergy(Object handler, ForgeDirection direction, double energy, boolean doReceive) {
        EnergySystem module = EnergyHandler.getHandler(handler, direction);
        if (module != null) {
            return module.receiveEnergy(handler, direction, energy, doReceive);
        }
        return 0.0;
    }

    public static double drain(Object handler, ForgeDirection direction, double energy, boolean doExtract) {
        return EnergyHandler.extractEnergy(handler, direction, energy, doExtract);
    }

    public static double extractEnergy(Object handler, ForgeDirection direction, double energy, boolean doExtract) {
        EnergySystem module = EnergyHandler.getHandler(handler, direction);
        if (module != null) {
            return module.extractEnergy(handler, direction, energy, doExtract);
        }
        return 0.0;
    }

    public static double fill(ItemStack itemStack, double joules, boolean doCharge) {
        return EnergyHandler.chargeItem(itemStack, joules, doCharge);
    }

    public static double chargeItem(ItemStack itemStack, double joules, boolean doCharge) {
        EnergySystem module = EnergyHandler.getHandler(itemStack, null);
        if (module != null) {
            return module.chargeItem(itemStack, joules, doCharge);
        }
        return 0.0;
    }

    public static double drain(ItemStack itemStack, double joules, boolean doDischarge) {
        return EnergyHandler.dischargeItem(itemStack, joules, doDischarge);
    }

    public static double dischargeItem(ItemStack itemStack, double joules, boolean doDischarge) {
        EnergySystem module = EnergyHandler.getHandler(itemStack, null);
        if (module != null) {
            return module.dischargeItem(itemStack, joules, doDischarge);
        }
        return 0.0;
    }

    public static ItemStack getItemWithCharge(ItemStack itemStack, double energy) {
        EnergySystem module = EnergyHandler.getHandler(itemStack, null);
        if (module != null) {
            return module.getItemWithCharge(itemStack, energy);
        }
        return itemStack;
    }

    public static double getEnergy(Object obj, ForgeDirection direction) {
        EnergySystem module = EnergyHandler.getHandler(obj, direction);
        if (module != null) {
            return module.getEnergy(obj, direction);
        }
        return 0.0;
    }

    public static double getMaxEnergy(Object handler, ForgeDirection direction) {
        EnergySystem module = EnergyHandler.getHandler(handler, direction);
        if (module != null) {
            return module.getMaxEnergy(handler, direction);
        }
        return 0.0;
    }

    public static double getEnergyItem(ItemStack is) {
        EnergySystem module = EnergyHandler.getHandler(is, null);
        if (module != null) {
            return module.getEnergyItem(is);
        }
        return 0.0;
    }

    public static double getMaxEnergyItem(ItemStack is) {
        EnergySystem module = EnergyHandler.getHandler(is, null);
        if (module != null) {
            return module.getMaxEnergyItem(is);
        }
        return 0.0;
    }
}

