/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.mod.loadable;

import com.builtbroken.mc.lib.mod.loadable.ILoadable;
import com.builtbroken.mc.lib.mod.loadable.ILoadableProxy;
import com.builtbroken.mc.lib.mod.loadable.LoadWithMod;
import cpw.mods.fml.common.Loader;
import java.util.HashSet;
import java.util.Set;

public class LoadableHandler {
    private Set<ILoadable> loadables = new HashSet<ILoadable>();
    private LoadPhase phase = LoadPhase.PRELAUNCH;

    public void applyModule(Class<?> clazz) {
        this.applyModule(clazz, true);
    }

    public void applyModule(Class<?> clazz, boolean load) {
        if (load) {
            String id;
            if (clazz.getAnnotation(LoadWithMod.class) != null && !Loader.isModLoaded((String)(id = clazz.getAnnotation(LoadWithMod.class).mod_id()))) {
                return;
            }
            try {
                Object module = clazz.newInstance();
                if (module instanceof ILoadableProxy) {
                    ILoadableProxy subProxy = (ILoadableProxy)module;
                    if (subProxy.shouldLoad()) {
                        this.loadables.add(subProxy);
                    }
                } else if (module instanceof ILoadable) {
                    this.loadables.add((ILoadable)module);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void applyModule(ILoadable module) {
        this.loadables.add(module);
        switch (this.phase) {
            case DONE: {
                break;
            }
            case POSTINIT: {
                module.preInit();
                module.init();
                module.postInit();
                break;
            }
            case INIT: {
                module.preInit();
                module.init();
                break;
            }
        }
    }

    public void preInit() {
        this.phase = LoadPhase.PREINIT;
        for (ILoadable proxy : this.loadables) {
            proxy.preInit();
        }
    }

    public void init() {
        this.phase = LoadPhase.INIT;
        for (ILoadable proxy : this.loadables) {
            proxy.init();
        }
    }

    public void postInit() {
        this.phase = LoadPhase.POSTINIT;
        for (ILoadable proxy : this.loadables) {
            proxy.postInit();
        }
        this.phase = LoadPhase.DONE;
    }

    public static enum LoadPhase {
        PRELAUNCH,
        PREINIT,
        INIT,
        POSTINIT,
        DONE;

    }
}

