/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.transform.rotation;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.lib.transform.ITransform;
import com.builtbroken.mc.lib.transform.matrix.Matrix;
import com.builtbroken.mc.lib.transform.rotation.AngleAxis$;
import com.builtbroken.mc.lib.transform.rotation.EulerAngle;
import com.builtbroken.mc.lib.transform.vector.Pos;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import scala.Cloneable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u0001=\u0011\u0011\"\u00118hY\u0016\f\u00050[:\u000b\u0005\r!\u0011\u0001\u0003:pi\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!\u0003;sC:\u001chm\u001c:n\u0015\t9\u0001\"A\u0002mS\nT!!\u0003\u0006\u0002\u00055\u001c'BA\u0006\r\u0003-\u0011W/\u001b7uEJ|7.\u001a8\u000b\u00035\t1aY8n\u0007\u0001\u0019B\u0001\u0001\t\u0019=A\u0011\u0011CF\u0007\u0002%)\u00111\u0003F\u0001\u0005Y\u0006twMC\u0001\u0016\u0003\u0011Q\u0017M^1\n\u0005]\u0011\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"DA\u0005DY>tW-\u00192mKB\u0011q\u0004I\u0007\u0002\t%\u0011\u0011\u0005\u0002\u0002\u000b\u0013R\u0013\u0018M\\:g_Jl\u0007\u0002C\u0012\u0001\u0005\u0003\u0007I\u0011\u0001\u0013\u0002\u000b\u0005tw\r\\3\u0016\u0003\u0015\u0002\"!\u0007\u0014\n\u0005\u001dR\"A\u0002#pk\ndW\r\u0003\u0005*\u0001\t\u0005\r\u0011\"\u0001+\u0003%\tgn\u001a7f?\u0012*\u0017\u000f\u0006\u0002,]A\u0011\u0011\u0004L\u0005\u0003[i\u0011A!\u00168ji\"9q\u0006KA\u0001\u0002\u0004)\u0013a\u0001=%c!A\u0011\u0007\u0001B\u0001B\u0003&Q%\u0001\u0004b]\u001edW\r\t\u0005\tg\u0001\u0011\t\u0019!C\u0001i\u0005!\u0011\r_5t+\u0005)\u0004C\u0001\u001c:\u001b\u00059$B\u0001\u001d\u0005\u0003\u00191Xm\u0019;pe&\u0011!h\u000e\u0002\u0004!>\u001c\b\u0002\u0003\u001f\u0001\u0005\u0003\u0007I\u0011A\u001f\u0002\u0011\u0005D\u0018n]0%KF$\"a\u000b \t\u000f=Z\u0014\u0011!a\u0001k!A\u0001\t\u0001B\u0001B\u0003&Q'A\u0003bq&\u001c\b\u0005C\u0003C\u0001\u0011\u00051)\u0001\u0004=S:LGO\u0010\u000b\u0004\t\u001a;\u0005CA#\u0001\u001b\u0005\u0011\u0001bB\u0012B!\u0003\u0005\r!\n\u0005\bg\u0005\u0003\n\u00111\u00016\u0011\u0015\u0011\u0005\u0001\"\u0001J)\t!%\nC\u0003L\u0011\u0002\u0007A*A\u0002oER\u0004\"!T*\u000e\u00039S!aS(\u000b\u0005A\u000b\u0016!C7j]\u0016\u001c'/\u00194u\u0015\u0005\u0011\u0016a\u00018fi&\u0011AK\u0014\u0002\u000f\u001d\n#F+Y4D_6\u0004x.\u001e8e\u0011\u00151\u0006\u0001\"\u0001X\u0003\u0011\u0019W-\u001b7\u0016\u0003\u0011CQ!\u0017\u0001\u0005\u0002]\u000bQA\u001a7p_JDQa\u0017\u0001\u0005\u0002]\u000bQA]8v]\u0012DQ!\u0002\u0001\u0005Bu#\"!\u000e0\t\u000bab\u0006\u0019A0\u0011\u0005\u00014W\"A1\u000b\u0005a\u0012'BA2e\u0003\u0011!\u0017\r^1\u000b\u0005\u0015T\u0011\u0001\u00026mS\nL!aZ1\u0003\r%\u0003vn]\u001aE\u0011\u0015I\u0007\u0001\"\u0001k\u0003A!xNU8uCRLwN\\'biJL\u00070F\u0001l!\taw.D\u0001n\u0015\tqG!\u0001\u0004nCR\u0014\u0018\u000e_\u0005\u0003a6\u0014a!T1ue&D\b\"\u0002:\u0001\t\u0003\u0019\u0018\u0001\u0004;p\u000bVdWM]!oO2,W#\u0001;\u0011\u0005\u0015+\u0018B\u0001<\u0003\u0005))U\u000f\\3s\u0003:<G.\u001a\u0005\u0006q\u0002!\t!_\u0001\toJLG/\u001a(C)R\u0011AJ\u001f\u0005\u0006\u0017^\u0004\r\u0001\u0014\u0005\u0006y\u0002!\t!`\u0001\roJLG/\u001a\"zi\u0016\u0014UO\u001a\u000b\u0004}\u0006E\u0001cA@\u0002\u000e5\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!\u0001\u0004ck\u001a4WM\u001d\u0006\u0005\u0003\u000f\tI!A\u0003oKR$\u0018P\u0003\u0002\u0002\f\u0005\u0011\u0011n\\\u0005\u0005\u0003\u001f\t\tAA\u0004CsR,')\u001e4\t\u000b\r\\\b\u0019\u0001@\t\u000f\u0005U\u0001\u0001\"\u0011\u0002\u0018\u0005)1\r\\8oKR\tA\tC\u0004\u0002\u001c\u0001!\t%!\b\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\b\u0011\u0007e\t\t#C\u0002\u0002$i\u00111!\u00138u\u0011\u001d\t9\u0003\u0001C!\u0003S\ta!Z9vC2\u001cH\u0003BA\u0016\u0003c\u00012!GA\u0017\u0013\r\tyC\u0007\u0002\b\u0005>|G.Z1o\u0011!\t\u0019$!\nA\u0002\u0005U\u0012!A8\u0011\u0007e\t9$C\u0002\u0002:i\u00111!\u00118z\u000f%\tiDAA\u0001\u0012\u0003\ty$A\u0005B]\u001edW-\u0011=jgB\u0019Q)!\u0011\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003\u0007\u001aB!!\u0011\u0002FA\u0019\u0011$a\u0012\n\u0007\u0005%#D\u0001\u0004B]f\u0014VM\u001a\u0005\b\u0005\u0006\u0005C\u0011AA')\t\ty\u0004\u0003\u0006\u0002R\u0005\u0005\u0013\u0013!C\u0001\u0003'\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nTCAA+U\r)\u0013qK\u0016\u0003\u00033\u0002B!a\u0017\u0002f5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'A\u0005v]\u000eDWmY6fI*\u0019\u00111\r\u000e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002h\u0005u#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q\u00111NA!#\u0003%\t!!\u001c\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tyGK\u00026\u0003/\u0002")
public class AngleAxis
implements Cloneable,
ITransform {
    private double angle;
    private Pos axis;

    public static Pos $lessinit$greater$default$2() {
        return AngleAxis$.MODULE$.$lessinit$greater$default$2();
    }

    public static double $lessinit$greater$default$1() {
        return AngleAxis$.MODULE$.$lessinit$greater$default$1();
    }

    public double angle() {
        return this.angle;
    }

    public void angle_$eq(double x$1) {
        this.angle = x$1;
    }

    public Pos axis() {
        return this.axis;
    }

    public void axis_$eq(Pos x$1) {
        this.axis = x$1;
    }

    public AngleAxis ceil() {
        return new AngleAxis(Math.ceil(this.angle()), this.axis().ceil());
    }

    public AngleAxis floor() {
        return new AngleAxis(Math.floor(this.angle()), this.axis().floor());
    }

    public AngleAxis round() {
        return new AngleAxis(Math.round(this.angle()), this.axis().round());
    }

    @Override
    public Pos transform(IPos3D vector) {
        return this.toRotationMatrix().$times(vector);
    }

    public Matrix toRotationMatrix() {
        double x = this.axis().x();
        double y = this.axis().y();
        double z = this.axis().z();
        double cos = Math.cos(this.angle());
        double oneMinusCos = 1.0 - cos;
        double sin = Math.sin(this.angle());
        Matrix matrix = new Matrix(3, 3);
        matrix.apply(0).update(0, x * x * oneMinusCos + cos);
        matrix.apply(0).update(1, y * x * oneMinusCos + z * sin);
        matrix.apply(0).update(2, x * z * oneMinusCos - y * sin);
        matrix.apply(1).update(0, x * y * oneMinusCos - z * sin);
        matrix.apply(1).update(1, y * y * oneMinusCos + cos);
        matrix.apply(1).update(2, y * z * oneMinusCos + x * sin);
        matrix.apply(2).update(0, x * z * oneMinusCos + y * sin);
        matrix.apply(2).update(1, y * z * oneMinusCos - x * sin);
        matrix.apply(2).update(2, z * z * oneMinusCos + cos);
        return matrix;
    }

    public EulerAngle toEulerAngle() {
        double x = this.axis().x();
        double y = this.axis().y();
        double z = this.axis().z();
        double s = Math.sin(this.angle());
        double c = Math.cos(this.angle());
        double t = 1.0 - c;
        double yaw = 0.0;
        double pitch = 0.0;
        double roll = 0.0;
        if (x * y * t + z * s > 0.998) {
            yaw = (double)2 * Math.atan2(x * Math.sin(this.angle() / (double)2), Math.cos(this.angle() / (double)2));
            pitch = 1.5707963267948966;
            roll = 0.0;
            return new EulerAngle(yaw, pitch, roll);
        }
        if (x * y * t + z * s < -0.998) {
            yaw = (double)-2 * Math.atan2(x * Math.sin(this.angle() / (double)2), Math.cos(this.angle() / (double)2));
            pitch = -Math.PI / (double)2;
            roll = 0.0;
            return new EulerAngle(yaw, pitch, roll);
        }
        yaw = Math.atan2(y * s - x * z * t, 1.0 - (y * y + z * z) * t);
        pitch = Math.asin(x * y * t + z * s);
        roll = Math.atan2(x * s - y * z * t, 1.0 - (x * x + z * z) * t);
        return new EulerAngle(yaw, pitch, roll);
    }

    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        this.axis().writeNBT(nbt);
        nbt.func_74780_a("angle", this.angle());
        return nbt;
    }

    public ByteBuf writeByteBuf(ByteBuf data) {
        this.axis().writeByteBuf(data);
        data.writeDouble(this.angle());
        return data;
    }

    public AngleAxis clone() {
        return new AngleAxis(this.angle(), this.axis());
    }

    public int hashCode() {
        long angle = Double.doubleToLongBits(this.angle());
        int hash = this.axis().hashCode();
        hash = 31 * hash + (int)(angle ^ angle >>> 32);
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof AngleAxis) {
            AngleAxis other = (AngleAxis)o;
            return this.axis().equals(other.axis()) && this.angle() == other.angle();
        }
        return false;
    }

    public AngleAxis(double angle, Pos axis) {
        this.angle = angle;
        this.axis = axis;
    }

    public AngleAxis(NBTTagCompound nbt) {
        this(nbt.func_74769_h("angle"), new Pos(nbt));
    }
}

