/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.transform.rotation;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.lib.transform.AbstractOperation;
import com.builtbroken.mc.lib.transform.ITransform;
import com.builtbroken.mc.lib.transform.rotation.AngleAxis;
import com.builtbroken.mc.lib.transform.rotation.EulerAngle$;
import com.builtbroken.mc.lib.transform.rotation.Quaternion;
import com.builtbroken.mc.lib.transform.vector.Pos;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import scala.Cloneable;
import scala.Function1;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t]q!B\u0001\u0003\u0011\u0003y\u0011AC#vY\u0016\u0014\u0018I\\4mK*\u00111\u0001B\u0001\te>$\u0018\r^5p]*\u0011QAB\u0001\niJ\fgn\u001d4pe6T!a\u0002\u0005\u0002\u00071L'M\u0003\u0002\n\u0015\u0005\u0011Qn\u0019\u0006\u0003\u00171\t1BY;jYR\u0014'o\\6f]*\tQ\"A\u0002d_6\u001c\u0001\u0001\u0005\u0002\u0011#5\t!AB\u0003\u0013\u0005!\u00051C\u0001\u0006Fk2,'/\u00118hY\u0016\u001c\"!\u0005\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\r\u0005s\u0017PU3g\u0011\u0015Y\u0012\u0003\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tq\u0002C\u0003\u001f#\u0011\u0005q$A\bb]\u001edW\rR5gM\u0016\u0014XM\\2f)\r\u00013%\n\t\u0003+\u0005J!A\t\f\u0003\r\u0011{WO\u00197f\u0011\u0015!S\u00041\u0001!\u0003\u0019\tgn\u001a7f\u0003\")a%\ba\u0001A\u00051\u0011M\\4mK\nCQ\u0001K\t\u0005\u0002%\nqb\u00197b[B\fen\u001a7f)>\u001cd\u0007\r\u000b\u0003A)BQaK\u0014A\u0002\u0001\nQA^1mk\u0016DQ!L\t\u0005\u00029\nqb\u00197b[B\fen\u001a7f)>\f\u0004\b\r\u000b\u0003A=BQa\u000b\u0017A\u0002\u0001BQ!M\t\u0005\u0002I\n!b\u00197b[B\fen\u001a7f)\u0011\u00013\u0007\u000e\u001c\t\u000b-\u0002\u0004\u0019\u0001\u0011\t\u000bU\u0002\u0004\u0019\u0001\u0011\u0002\u00075Lg\u000eC\u00038a\u0001\u0007\u0001%A\u0002nCb4AA\u0005\u0002\u0001sM!\u0001HO C!\rYDHP\u0007\u0002\t%\u0011Q\b\u0002\u0002\u0012\u0003\n\u001cHO]1di>\u0003XM]1uS>t\u0007C\u0001\t9!\t)\u0002)\u0003\u0002B-\tI1\t\\8oK\u0006\u0014G.\u001a\t\u0003w\rK!\u0001\u0012\u0003\u0003\u0015%#&/\u00198tM>\u0014X\u000e\u0003\u0005Gq\t\u0005\r\u0011\"\u0001H\u0003\rI\u0018m^\u000b\u0002A!A\u0011\n\u000fBA\u0002\u0013\u0005!*A\u0004zC^|F%Z9\u0015\u0005-s\u0005CA\u000bM\u0013\tieC\u0001\u0003V]&$\bbB(I\u0003\u0003\u0005\r\u0001I\u0001\u0004q\u0012\n\u0004\u0002C)9\u0005\u0003\u0005\u000b\u0015\u0002\u0011\u0002\te\fw\u000f\t\u0005\t'b\u0012\t\u0019!C\u0001\u000f\u0006)\u0001/\u001b;dQ\"AQ\u000b\u000fBA\u0002\u0013\u0005a+A\u0005qSR\u001c\u0007n\u0018\u0013fcR\u00111j\u0016\u0005\b\u001fR\u000b\t\u00111\u0001!\u0011!I\u0006H!A!B\u0013\u0001\u0013A\u00029ji\u000eD\u0007\u0005\u0003\u0005\\q\t\u0005\r\u0011\"\u0001H\u0003\u0011\u0011x\u000e\u001c7\t\u0011uC$\u00111A\u0005\u0002y\u000b\u0001B]8mY~#S-\u001d\u000b\u0003\u0017~Cqa\u0014/\u0002\u0002\u0003\u0007\u0001\u0005\u0003\u0005bq\t\u0005\t\u0015)\u0003!\u0003\u0015\u0011x\u000e\u001c7!\u0011\u0015Y\u0002\b\"\u0001d)\u0011qD-\u001a4\t\u000b\u0019\u0013\u0007\u0019\u0001\u0011\t\u000bM\u0013\u0007\u0019\u0001\u0011\t\u000bm\u0013\u0007\u0019\u0001\u0011\t\u000bmAD\u0011\u00015\u0015\u0007yJ'\u000eC\u0003GO\u0002\u0007\u0001\u0005C\u0003TO\u0002\u0007\u0001\u0005C\u0003\u001cq\u0011\u0005A\u000e\u0006\u0002?[\")an\u001ba\u0001_\u0006\u0019A-\u001b:\u0011\u0005ALX\"A9\u000b\u0005I\u001c\u0018\u0001B;uS2T!\u0001^;\u0002\r\r|W.\\8o\u0015\t1x/\u0001\bnS:,7M]1gi\u001a|'oZ3\u000b\u0003a\f1A\\3u\u0013\tQ\u0018O\u0001\bG_J<W\rR5sK\u000e$\u0018n\u001c8\t\u000bqDD\u0011A?\u0002\u0007M,G\u000fF\u0003L}~\f\t\u0001C\u0003Gw\u0002\u0007\u0001\u0005C\u0003Tw\u0002\u0007\u0001\u0005C\u0003\\w\u0002\u0007\u0001\u0005\u0003\u0004}q\u0011\u0005\u0011Q\u0001\u000b\u0006\u0017\u0006\u001d\u0011\u0011\u0003\u0005\t\u0003\u0013\t\u0019\u00011\u0001\u0002\f\u0005)\u0011N\u001c3fqB\u0019Q#!\u0004\n\u0007\u0005=aCA\u0002J]RDaaKA\u0002\u0001\u0004\u0001\u0003B\u0002?9\t\u0003\n)\u0002F\u0002?\u0003/Aq!!\u0007\u0002\u0014\u0001\u0007a(A\u0003pi\",'\u000fC\u0004\u0002\u001ea\"\t%a\b\u0002\u000b\u0011\u0002H.^:\u0015\u0007y\n\t\u0003C\u0004\u0002\u001a\u0005m\u0001\u0019\u0001\u0011\t\u000f\u0005u\u0001\b\"\u0011\u0002&Q\u0019a(a\n\t\u000f\u0005e\u00111\u0005a\u0001}!9\u00111\u0006\u001d\u0005B\u00055\u0012A\u0002\u0013uS6,7\u000fF\u0002?\u0003_Aq!!\u0007\u0002*\u0001\u0007\u0001\u0005C\u0004\u0002,a\"\t%a\r\u0015\u0007y\n)\u0004C\u0004\u0002\u001a\u0005E\u0002\u0019\u0001 \t\u000f\u0005e\u0002\b\"\u0011\u0002<\u0005Q!/Z2jaJ|7-\u00197\u0015\u0003yBq!a\u00109\t\u0003\t\t%\u0001\u0003dK&dW#\u0001 \t\u000f\u0005\u0015\u0003\b\"\u0001\u0002B\u0005)a\r\\8pe\"9\u0011\u0011\n\u001d\u0005\u0002\u0005\u0005\u0013!\u0002:pk:$\u0007BB\u001c9\t\u0003\ti\u0005F\u0002?\u0003\u001fBq!!\u0007\u0002L\u0001\u0007a\b\u0003\u00046q\u0011\u0005\u00111\u000b\u000b\u0004}\u0005U\u0003bBA\r\u0003#\u0002\rA\u0010\u0005\b\u00033BD\u0011AA.\u0003I\t'm]8mkR,G)\u001b4gKJ,gnY3\u0015\u0007y\ni\u0006C\u0004\u0002\u001a\u0005]\u0003\u0019\u0001 \t\u000f\u0005\u0005\u0004\b\"\u0001\u0002d\u0005A\u0011n],ji\"Lg\u000e\u0006\u0004\u0002f\u0005-\u0014Q\u000e\t\u0004+\u0005\u001d\u0014bAA5-\t9!i\\8mK\u0006t\u0007bBA\r\u0003?\u0002\rA\u0010\u0005\b\u0003_\ny\u00061\u0001!\u0003\u0019i\u0017M]4j]\"1Q\u0001\u000fC!\u0003g\"B!!\u001e\u0002\u0002B!\u0011qOA?\u001b\t\tIHC\u0002\u0002|\u0011\taA^3di>\u0014\u0018\u0002BA@\u0003s\u00121\u0001U8t\u0011!\tY(!\u001dA\u0002\u0005\r\u0005\u0003BAC\u0003#k!!a\"\u000b\t\u0005m\u0014\u0011\u0012\u0006\u0005\u0003\u0017\u000bi)\u0001\u0003eCR\f'bAAH\u0015\u0005!!\u000e\\5c\u0013\u0011\t\u0019*a\"\u0003\r%\u0003vn]\u001aE\u0011\u001d\t9\n\u000fC\u0001\u00033\u000b\u0001\u0002^8WK\u000e$xN]\u000b\u0003\u0003kBq!!(9\t\u0003\ty*A\u0006u_\u0006sw\r\\3Bq&\u001cXCAAQ!\r\u0001\u00121U\u0005\u0004\u0003K\u0013!!C!oO2,\u0017\t_5t\u0011\u001d\tI\u000b\u000fC\u0001\u0003W\u000bA\u0002^8Rk\u0006$XM\u001d8j_:,\"!!,\u0011\u0007A\ty+C\u0002\u00022\n\u0011!\"U;bi\u0016\u0014h.[8o\u0011\u001d\t)\f\u000fC\u0001\u0003o\u000bq\u0001^8UkBdW-\u0006\u0002\u0002:B1Q#a/!A\u0001J1!!0\u0017\u0005\u0019!V\u000f\u001d7fg!9\u0011\u0011\u0019\u001d\u0005\u0002\u0005\r\u0017a\u0002;p\u0003J\u0014\u0018-_\u000b\u0003\u0003\u000b\u0004B!FAdA%\u0019\u0011\u0011\u001a\f\u0003\u000b\u0005\u0013(/Y=\t\u000f\u00055\u0007\b\"\u0011\u0002<\u0005)1\r\\8oK\"9\u0011\u0011\u001b\u001d\u0005B\u0005M\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005U\u0007\u0003BAl\u0003;t1!FAm\u0013\r\tYNF\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0017\u0011\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005mg\u0003C\u0004\u0002fb\"\t%a:\u0002\u0019]\u0014\u0018\u000e^3CsR,')\u001e4\u0015\t\u0005%\u0018Q \t\u0005\u0003W\fI0\u0004\u0002\u0002n*!\u0011q^Ay\u0003\u0019\u0011WO\u001a4fe*!\u00111_A{\u0003\u0015qW\r\u001e;z\u0015\t\t90\u0001\u0002j_&!\u00111`Aw\u0005\u001d\u0011\u0015\u0010^3Ck\u001aD\u0001\"a#\u0002d\u0002\u0007\u0011\u0011\u001e\u0005\b\u0005\u0003AD\u0011\tB\u0002\u0003!9(/\u001b;f\u001d\n#F\u0003\u0002B\u0003\u0005+\u0001BAa\u0002\u0003\u00125\u0011!\u0011\u0002\u0006\u0005\u0005\u0017\u0011i!A\u0002oERT1Aa\u0004x\u0003%i\u0017N\\3de\u00064G/\u0003\u0003\u0003\u0014\t%!A\u0004(C)R\u000bwmQ8na>,h\u000e\u001a\u0005\t\u0005\u0017\ty\u00101\u0001\u0003\u0006\u0001")
public class EulerAngle
extends AbstractOperation<EulerAngle>
implements Cloneable,
ITransform {
    private double yaw;
    private double pitch;
    private double roll;

    public static double clampAngle(double d, double d2, double d3) {
        return EulerAngle$.MODULE$.clampAngle(d, d2, d3);
    }

    public static double clampAngleTo180(double d) {
        return EulerAngle$.MODULE$.clampAngleTo180(d);
    }

    public static double clampAngleTo360(double d) {
        return EulerAngle$.MODULE$.clampAngleTo360(d);
    }

    public static double angleDifference(double d, double d2) {
        return EulerAngle$.MODULE$.angleDifference(d, d2);
    }

    public double yaw() {
        return this.yaw;
    }

    public void yaw_$eq(double x$1) {
        this.yaw = x$1;
    }

    public double pitch() {
        return this.pitch;
    }

    public void pitch_$eq(double x$1) {
        this.pitch = x$1;
    }

    public double roll() {
        return this.roll;
    }

    public void roll_$eq(double x$1) {
        this.roll = x$1;
    }

    public void set(double yaw, double pitch, double roll) {
        this.yaw_$eq(yaw);
        this.pitch_$eq(pitch);
        this.roll_$eq(roll);
    }

    public void set(int index, double value) {
        if (index == 0) {
            this.yaw_$eq(value);
        }
        if (index == 1) {
            this.pitch_$eq(value);
        }
        if (index == 2) {
            this.roll_$eq(value);
        }
    }

    @Override
    public EulerAngle set(EulerAngle other) {
        this.yaw_$eq(other.yaw());
        this.pitch_$eq(other.pitch());
        this.roll_$eq(other.roll());
        return this;
    }

    @Override
    public EulerAngle $plus(double other) {
        return new EulerAngle(this.yaw() + other, this.pitch() + other, this.roll() + other);
    }

    @Override
    public EulerAngle $plus(EulerAngle other) {
        return new EulerAngle(this.yaw() + other.yaw(), this.pitch() + other.pitch(), this.roll() + other.roll());
    }

    @Override
    public EulerAngle $times(double other) {
        return new EulerAngle(this.yaw() * other, this.pitch() * other, this.roll() * other);
    }

    @Override
    public EulerAngle $times(EulerAngle other) {
        return new EulerAngle(this.yaw() * other.yaw(), this.pitch() * other.pitch(), this.roll() * other.roll());
    }

    @Override
    public EulerAngle reciprocal() {
        return new EulerAngle(1.0 / this.yaw(), 1.0 / this.pitch(), 1.0 / this.roll());
    }

    @Override
    public EulerAngle ceil() {
        return new EulerAngle(Math.ceil(this.yaw()), Math.ceil(this.pitch()), Math.ceil(this.roll()));
    }

    @Override
    public EulerAngle floor() {
        return new EulerAngle(Math.floor(this.yaw()), Math.floor(this.pitch()), Math.floor(this.roll()));
    }

    @Override
    public EulerAngle round() {
        return new EulerAngle(Math.round(this.yaw()), Math.round(this.pitch()), Math.round(this.roll()));
    }

    @Override
    public EulerAngle max(EulerAngle other) {
        return new EulerAngle(Math.max(this.yaw(), other.yaw()), Math.max(this.pitch(), other.pitch()), Math.max(this.roll(), other.roll()));
    }

    @Override
    public EulerAngle min(EulerAngle other) {
        return new EulerAngle(Math.min(this.yaw(), other.yaw()), Math.min(this.pitch(), other.pitch()), Math.min(this.roll(), other.roll()));
    }

    public EulerAngle absoluteDifference(EulerAngle other) {
        return new EulerAngle(EulerAngle$.MODULE$.angleDifference(this.yaw(), other.yaw()), EulerAngle$.MODULE$.angleDifference(this.pitch(), other.pitch()), EulerAngle$.MODULE$.angleDifference(this.roll(), other.roll()));
    }

    public boolean isWithin(EulerAngle other, double margin) {
        return this.absoluteDifference(other).toTuple().productIterator().exists((Function1)new Serializable(this, margin){
            private final double margin$1;

            public final boolean apply(Object i) {
                return BoxesRunTime.unboxToDouble((Object)i) > this.margin$1;
            }
            {
                this.margin$1 = margin$1;
            }
        });
    }

    @Override
    public Pos transform(IPos3D vector) {
        return new Pos(vector).transform(this.toQuaternion());
    }

    public Pos toVector() {
        return new Pos(-Math.sin(this.yaw()) * Math.cos(this.pitch()), Math.sin(this.pitch()), -Math.cos(this.yaw()) * Math.cos(this.pitch()));
    }

    public AngleAxis toAngleAxis() {
        double c1 = Math.cos(this.yaw() / (double)2);
        double s1 = Math.sin(this.yaw() / (double)2);
        double c2 = Math.cos(this.pitch() / (double)2);
        double s2 = Math.sin(this.pitch() / (double)2);
        double c3 = Math.cos(this.roll() / (double)2);
        double s3 = Math.sin(this.roll() / (double)2);
        double c1c2 = c1 * c2;
        double s1s2 = s1 * s2;
        double w = c1c2 * c3 - s1s2 * s3;
        double x = c1c2 * s3 + s1s2 * c3;
        double y = s1 * c2 * c3 + c1 * s2 * s3;
        double z = c1 * s2 * c3 - s1 * c2 * s3;
        double angle = (double)2 * Math.acos(w);
        Pos axis = new Pos(x, y, z);
        axis = axis.magnitudeSquared() < 0.001 ? new Pos(0.0, 0.0, -1.0) : axis.normalize();
        return new AngleAxis(angle, axis);
    }

    public Quaternion toQuaternion() {
        double c1 = Math.cos(Math.toRadians(this.yaw()) / (double)2);
        double s1 = Math.sin(Math.toRadians(this.yaw()) / (double)2);
        double c2 = Math.cos(Math.toRadians(this.pitch()) / (double)2);
        double s2 = Math.sin(Math.toRadians(this.pitch()) / (double)2);
        double c3 = Math.cos(Math.toRadians(this.roll()) / (double)2);
        double s3 = Math.sin(Math.toRadians(this.roll()) / (double)2);
        double c1c2 = c1 * c2;
        double s1s2 = s1 * s2;
        double w = c1c2 * c3 - s1s2 * s3;
        double x = c1c2 * s3 + s1s2 * c3;
        double y = s1 * c2 * c3 + c1 * s2 * s3;
        double z = c1 * s2 * c3 - s1 * c2 * s3;
        return new Quaternion(w, x, y, z);
    }

    public Tuple3<Object, Object, Object> toTuple() {
        return new Tuple3((Object)BoxesRunTime.boxToDouble((double)this.yaw()), (Object)BoxesRunTime.boxToDouble((double)this.pitch()), (Object)BoxesRunTime.boxToDouble((double)this.roll()));
    }

    public double[] toArray() {
        return new double[]{this.yaw(), this.pitch(), this.roll()};
    }

    public EulerAngle clone() {
        return new EulerAngle(this.yaw(), this.pitch(), this.roll());
    }

    public String toString() {
        return new StringBuilder().append((Object)"EulerAngle[").append((Object)BoxesRunTime.boxToDouble((double)this.yaw())).append((Object)",").append((Object)BoxesRunTime.boxToDouble((double)this.pitch())).append((Object)",").append((Object)BoxesRunTime.boxToDouble((double)this.roll())).append((Object)"]").toString();
    }

    @Override
    public ByteBuf writeByteBuf(ByteBuf data) {
        data.writeDouble(this.yaw());
        data.writeDouble(this.pitch());
        return data.writeDouble(this.roll());
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74780_a("yaw", this.yaw());
        nbt.func_74780_a("pitch", this.pitch());
        nbt.func_74780_a("roll", this.roll());
        return nbt;
    }

    public EulerAngle(double yaw, double pitch, double roll) {
        this.yaw = yaw;
        this.pitch = pitch;
        this.roll = roll;
    }

    public EulerAngle(double yaw, double pitch) {
        this(yaw, pitch, 0.0);
    }

    public EulerAngle(ForgeDirection dir) {
        this(0.0, 0.0, 0.0);
        ForgeDirection forgeDirection = dir;
        if (ForgeDirection.DOWN.equals(forgeDirection)) {
            this.set(0.0, -90.0, 0.0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ForgeDirection.UP.equals(forgeDirection)) {
            this.set(0.0, 90.0, 0.0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ForgeDirection.NORTH.equals(forgeDirection)) {
            this.set(0.0, 0.0, 0.0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ForgeDirection.SOUTH.equals(forgeDirection)) {
            this.set(180.0, 0.0, 0.0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ForgeDirection.WEST.equals(forgeDirection)) {
            this.set(90.0, 0.0, 0.0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ForgeDirection.EAST.equals(forgeDirection)) {
            this.set(-90.0, 0.0, 0.0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }
}

