/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.transform.rotation;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.lib.transform.ITransform;
import com.builtbroken.mc.lib.transform.vector.Pos;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import scala.Cloneable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\u0001\u0003\u0001=\u0011!\"U;bi\u0016\u0014h.[8o\u0015\t\u0019A!\u0001\u0005s_R\fG/[8o\u0015\t)a!A\u0005ue\u0006t7OZ8s[*\u0011q\u0001C\u0001\u0004Y&\u0014'BA\u0005\u000b\u0003\ti7M\u0003\u0002\f\u0019\u0005Y!-^5mi\n\u0014xn[3o\u0015\u0005i\u0011aA2p[\u000e\u00011\u0003\u0002\u0001\u00111y\u0001\"!\u0005\f\u000e\u0003IQ!a\u0005\u000b\u0002\t1\fgn\u001a\u0006\u0002+\u0005!!.\u0019<b\u0013\t9\"C\u0001\u0004PE*,7\r\u001e\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\n\u00072|g.Z1cY\u0016\u0004\"a\b\u0011\u000e\u0003\u0011I!!\t\u0003\u0003\u0015%#&/\u00198tM>\u0014X\u000eC\u0003$\u0001\u0011\u0005A%\u0001\u0004=S:LGO\u0010\u000b\u0002KA\u0011a\u0005A\u0007\u0002\u0005!9\u0001\u0006\u0001a\u0001\n\u0003I\u0013!\u0001=\u0016\u0003)\u0002\"!G\u0016\n\u00051R\"A\u0002#pk\ndW\rC\u0004/\u0001\u0001\u0007I\u0011A\u0018\u0002\u000ba|F%Z9\u0015\u0005A\u001a\u0004CA\r2\u0013\t\u0011$D\u0001\u0003V]&$\bb\u0002\u001b.\u0003\u0003\u0005\rAK\u0001\u0004q\u0012\n\u0004B\u0002\u001c\u0001A\u0003&!&\u0001\u0002yA!9\u0001\b\u0001a\u0001\n\u0003I\u0013!A=\t\u000fi\u0002\u0001\u0019!C\u0001w\u0005)\u0011p\u0018\u0013fcR\u0011\u0001\u0007\u0010\u0005\bie\n\t\u00111\u0001+\u0011\u0019q\u0004\u0001)Q\u0005U\u0005\u0011\u0011\u0010\t\u0005\b\u0001\u0002\u0001\r\u0011\"\u0001*\u0003\u0005Q\bb\u0002\"\u0001\u0001\u0004%\taQ\u0001\u0006u~#S-\u001d\u000b\u0003a\u0011Cq\u0001N!\u0002\u0002\u0003\u0007!\u0006\u0003\u0004G\u0001\u0001\u0006KAK\u0001\u0003u\u0002Bq\u0001\u0013\u0001A\u0002\u0013\u0005\u0011&A\u0001x\u0011\u001dQ\u0005\u00011A\u0005\u0002-\u000bQa^0%KF$\"\u0001\r'\t\u000fQJ\u0015\u0011!a\u0001U!1a\n\u0001Q!\n)\n!a\u001e\u0011\t\u000b\r\u0002A\u0011\u0001)\u0015\u0005\u0015\n\u0006\"\u0002*P\u0001\u0004)\u0013AC)vCR,'O\\5p]\")1\u0005\u0001C\u0001)R\u0019Q%V,\t\u000bY\u001b\u0006\u0019\u0001\u0016\u0002\u000b\u0005tw\r\\3\t\u000ba\u001b\u0006\u0019A-\u0002\t\u0005D\u0018n\u001d\t\u00035vk\u0011a\u0017\u0006\u00039\u0012\taA^3di>\u0014\u0018B\u00010\\\u0005\r\u0001vn\u001d\u0005\u0006G\u0001!\t\u0001\u0019\u000b\u0006K\u0005\u001cWm\u001a\u0005\u0006E~\u0003\rAK\u0001\u0002I\")Am\u0018a\u0001U\u0005\u0011A-\r\u0005\u0006M~\u0003\rAK\u0001\u0003IJBQ\u0001[0A\u0002)\n!\u0001Z\u001a\t\u000b)\u0004A\u0011A6\u0002\u0007M,G\u000f\u0006\u0002&Y\")Q.\u001ba\u0001K\u0005\t\u0011\u000fC\u0003k\u0001\u0011\u0005q\u000eF\u0003&aF\u00148\u000fC\u0003c]\u0002\u0007!\u0006C\u0003e]\u0002\u0007!\u0006C\u0003g]\u0002\u0007!\u0006C\u0003i]\u0002\u0007!\u0006C\u0003v\u0001\u0011\u0005a/A\u0007tKR\f%o\\;oI\u0006C\u0018n\u001d\u000b\u0006K]L80 \u0005\u0006qR\u0004\rAK\u0001\u0003CbDQA\u001f;A\u0002)\n!!Y=\t\u000bq$\b\u0019\u0001\u0016\u0002\u0005\u0005T\b\"\u0002@u\u0001\u0004Q\u0013!D8sS\u001eLg.\u00197B]\u001edW\r\u0003\u0004v\u0001\u0011\u0005\u0011\u0011\u0001\u000b\u0006K\u0005\r\u0011Q\u0001\u0005\u00061~\u0004\r!\u0017\u0005\u0006-~\u0004\rA\u000b\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0003!iW\u000f\u001c;ja2LHcA\u0013\u0002\u000e!1!+a\u0002A\u0002\u0015Bq!!\u0005\u0001\t\u0003\t\u0019\"A\u0007sS\u001eDG/T;mi&\u0004H.\u001f\u000b\u0004K\u0005U\u0001B\u0002*\u0002\u0010\u0001\u0007Q\u0005\u0003\u0004\u0002\u001a\u0001!\t!K\u0001\n[\u0006<g.\u001b;vI\u0016Dq!!\b\u0001\t\u0003\ty\"A\u0005o_Jl\u0017\r\\5{KV\tQ\u0005\u0003\u0004\u0002$\u0001!\t\u0005J\u0001\u0006G2|g.\u001a\u0005\u0007\u000b\u0001!\t%a\n\u0015\u0007e\u000bI\u0003C\u0004]\u0003K\u0001\r!a\u000b\u0011\t\u00055\u0012\u0011H\u0007\u0003\u0003_Q1\u0001XA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\t\u0011\fG/\u0019\u0006\u0004\u0003oQ\u0011\u0001\u00026mS\nLA!a\u000f\u00020\t1\u0011\nU8tg\u0011Cq!a\u0010\u0001\t\u0003\n\t%\u0001\u0005u_N#(/\u001b8h)\t\t\u0019\u0005\u0005\u0003\u0002F\u0005-cbA\r\u0002H%\u0019\u0011\u0011\n\u000e\u0002\rA\u0013X\rZ3g\u0013\u0011\ti%a\u0014\u0003\rM#(/\u001b8h\u0015\r\tIE\u0007")
public class Quaternion
implements Cloneable,
ITransform {
    private double x = 1.0;
    private double y = 0.0;
    private double z = 0.0;
    private double w = 0.0;

    public double x() {
        return this.x;
    }

    public void x_$eq(double x$1) {
        this.x = x$1;
    }

    public double y() {
        return this.y;
    }

    public void y_$eq(double x$1) {
        this.y = x$1;
    }

    public double z() {
        return this.z;
    }

    public void z_$eq(double x$1) {
        this.z = x$1;
    }

    public double w() {
        return this.w;
    }

    public void w_$eq(double x$1) {
        this.w = x$1;
    }

    public Quaternion set(Quaternion q) {
        this.x_$eq(q.x());
        this.y_$eq(q.y());
        this.z_$eq(q.z());
        this.w_$eq(q.w());
        return this;
    }

    public Quaternion set(double d, double d1, double d2, double d3) {
        this.x_$eq(d1);
        this.y_$eq(d2);
        this.z_$eq(d3);
        this.w_$eq(d);
        return this;
    }

    public Quaternion setAroundAxis(double ax, double ay, double az, double originalAngle) {
        double angle = originalAngle;
        double d4 = Math.sin(angle *= 0.5);
        return this.set(Math.cos(angle), ax * d4, ay * d4, az * d4);
    }

    public Quaternion setAroundAxis(Pos axis, double angle) {
        return this.setAroundAxis(axis.x(), axis.y(), axis.z(), angle);
    }

    public Quaternion multiply(Quaternion Quaternion2) {
        double d = this.w() * Quaternion2.w() - this.x() * Quaternion2.x() - this.y() * Quaternion2.y() - this.z() * Quaternion2.z();
        double d1 = this.w() * Quaternion2.x() + this.x() * Quaternion2.w() - this.y() * Quaternion2.z() + this.z() * Quaternion2.y();
        double d2 = this.w() * Quaternion2.y() + this.x() * Quaternion2.z() + this.y() * Quaternion2.w() - this.z() * Quaternion2.x();
        double d3 = this.w() * Quaternion2.z() - this.x() * Quaternion2.y() + this.y() * Quaternion2.x() + this.z() * Quaternion2.w();
        this.w_$eq(d);
        this.x_$eq(d1);
        this.y_$eq(d2);
        this.z_$eq(d3);
        return this;
    }

    public Quaternion rightMultiply(Quaternion Quaternion2) {
        double d = this.w() * Quaternion2.w() - this.x() * Quaternion2.x() - this.y() * Quaternion2.y() - this.z() * Quaternion2.z();
        double d1 = this.w() * Quaternion2.x() + this.x() * Quaternion2.w() + this.y() * Quaternion2.z() - this.z() * Quaternion2.y();
        double d2 = this.w() * Quaternion2.y() - this.x() * Quaternion2.z() + this.y() * Quaternion2.w() + this.z() * Quaternion2.x();
        double d3 = this.w() * Quaternion2.z() + this.x() * Quaternion2.y() - this.y() * Quaternion2.x() + this.z() * Quaternion2.w();
        this.w_$eq(d);
        this.x_$eq(d1);
        this.y_$eq(d2);
        this.z_$eq(d3);
        return this;
    }

    public double magnitude() {
        return Math.sqrt(this.x() * this.x() + this.y() * this.y() + this.z() * this.z() + this.w() * this.w());
    }

    public Quaternion normalize() {
        double d = this.magnitude();
        if (d != 0.0) {
            d = 1.0 / d;
            this.x_$eq(this.x() * d);
            this.y_$eq(this.y() * d);
            this.z_$eq(this.z() * d);
            this.w_$eq(this.w() * d);
        }
        return this;
    }

    public Quaternion clone() {
        return new Quaternion(this);
    }

    @Override
    public Pos transform(IPos3D vector) {
        double d = -this.x() * vector.x() - this.y() * vector.y() - this.z() * vector.z();
        double d1 = this.w() * vector.x() + this.y() * vector.z() - this.z() * vector.y();
        double d2 = this.w() * vector.y() - this.x() * vector.z() + this.z() * vector.x();
        double d3 = this.w() * vector.z() + this.x() * vector.y() - this.y() * vector.x();
        return new Pos(d1 * this.w() - d * this.x() - d2 * this.z() + d3 * this.y(), d2 * this.w() - d * this.y() + d1 * this.z() - d3 * this.x(), d3 * this.w() - d * this.z() - d1 * this.y() + d2 * this.x());
    }

    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        return new StringBuilder().append((Object)"Quaternion[").append((Object)new BigDecimal(this.w(), cont)).append((Object)", ").append((Object)new BigDecimal(this.x(), cont)).append((Object)", ").append((Object)new BigDecimal(this.y(), cont)).append((Object)", ").append((Object)new BigDecimal(this.z(), cont)).append((Object)"]").toString();
    }

    public Quaternion() {
    }

    public Quaternion(Quaternion Quaternion2) {
        this();
        this.x_$eq(Quaternion2.x());
        this.y_$eq(Quaternion2.y());
        this.z_$eq(Quaternion2.z());
        this.w_$eq(Quaternion2.w());
    }

    public Quaternion(double angle, Pos axis) {
        this();
        this.setAroundAxis(axis.x(), axis.y(), axis.z(), angle);
    }

    public Quaternion(double d, double d1, double d2, double d3) {
        this();
        this.x_$eq(d1);
        this.y_$eq(d2);
        this.z_$eq(d3);
        this.w_$eq(d);
    }
}

