/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.edit;

import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.api.event.WorldChangeActionEvent;
import com.builtbroken.mc.lib.transform.vector.Location;
import com.builtbroken.mc.lib.world.edit.BlockEdit;
import com.builtbroken.mc.lib.world.edit.IWorldChangeAction;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.Collection;
import java.util.Iterator;
import net.minecraftforge.common.MinecraftForge;

public class ThreadWorldChangeAction
extends Thread {
    public final Location position;
    public final IWorldChangeAction blast;
    public final TriggerCause triggerCause;
    public int blocksPerTick = 20;
    private Collection<BlockEdit> effectedBlocks;

    public ThreadWorldChangeAction(Location vec, IWorldChangeAction blast, TriggerCause triggerCause) {
        this.position = vec;
        this.blast = blast;
        this.triggerCause = triggerCause;
        this.setPriority(5);
    }

    @Override
    public void run() {
        this.effectedBlocks = this.blast.getEffectedBlocks();
        MinecraftForge.EVENT_BUS.post((Event)new WorldChangeActionEvent.FinishedCalculatingEffectEvent(this.position, this.effectedBlocks, this.blast, this.triggerCause));
        if (this.effectedBlocks != null && !this.effectedBlocks.isEmpty()) {
            FMLCommonHandler.instance().bus().register((Object)this);
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END) {
            Iterator<BlockEdit> it = this.effectedBlocks.iterator();
            int c = 0;
            while (it.hasNext() && c++ <= this.blocksPerTick) {
                this.blast.handleBlockPlacement(it.next());
                it.remove();
            }
        }
        if (this.effectedBlocks.isEmpty()) {
            FMLCommonHandler.instance().bus().unregister((Object)this);
        }
    }
}

