/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.edit;

import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.api.event.WorldChangeActionEvent;
import com.builtbroken.mc.lib.transform.vector.Location;
import com.builtbroken.mc.lib.world.edit.BlockEdit;
import com.builtbroken.mc.lib.world.edit.IWorldChangeAction;
import com.builtbroken.mc.lib.world.edit.ThreadWorldChangeAction;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class WorldChangeHelper {
    public static ChangeResult doAction(World world, double x, double y, double z, IWorldChangeAction action, TriggerCause triggerCause) {
        return WorldChangeHelper.doAction(new Location(world, x, y, z), action, triggerCause);
    }

    public static ChangeResult doAction(Location loc, IWorldChangeAction action, TriggerCause triggerCause) {
        if (action != null) {
            WorldChangeActionEvent.ActionCreated event = new WorldChangeActionEvent.ActionCreated(loc, action, triggerCause);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                action.doEffectOther(true);
                if (action.shouldThreadAction() > 0) {
                    ThreadWorldChangeAction thread = new ThreadWorldChangeAction(loc, action, triggerCause);
                    thread.start();
                } else {
                    Collection<BlockEdit> effectedBlocks = WorldChangeHelper.getEffectedBlocks(loc, triggerCause, action);
                    if (effectedBlocks == null || !effectedBlocks.isEmpty()) {
                        // empty if block
                    }
                    for (BlockEdit v : effectedBlocks) {
                        action.handleBlockPlacement(v);
                    }
                }
                action.doEffectOther(false);
                return ChangeResult.COMPLETED;
            }
            return ChangeResult.BLOCKED;
        }
        return ChangeResult.FAILED;
    }

    public static Collection<BlockEdit> getEffectedBlocks(Location vec, TriggerCause triggerCause, IWorldChangeAction blast) {
        Collection<BlockEdit> effectedBlocks = blast.getEffectedBlocks();
        MinecraftForge.EVENT_BUS.post((Event)new WorldChangeActionEvent.FinishedCalculatingEffectEvent(vec, effectedBlocks, blast, triggerCause));
        if (effectedBlocks == null) {
            return new ArrayList<BlockEdit>();
        }
        return effectedBlocks;
    }

    public static enum ChangeResult {
        COMPLETED,
        FAILED,
        BLOCKED;

    }
}

