/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.explosive;

import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.lib.world.edit.BlockEdit;
import com.builtbroken.mc.lib.world.edit.IWorldChangeAction;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class Blast
implements IWorldChangeAction,
IWorldPosition {
    public World world;
    public int x;
    public int y;
    public int z;
    public int size = 1;
    public float eUnitPerBlock = 5.0f;
    public TriggerCause cause = new TriggerCause.TriggerCauseRedstone(ForgeDirection.UNKNOWN, 15);

    public Blast() {
    }

    public Blast(World world, int x, int y, int z, int size) {
        this.setLocation(world, x, y, z);
        this.setYield(size);
    }

    public Blast setLocation(World world, int x, int y, int z) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Blast setYield(int size) {
        this.size = size;
        return this;
    }

    public Blast setEnergyPerBlock(float f) {
        this.eUnitPerBlock = f;
        return this;
    }

    public Blast setCause(TriggerCause cause) {
        this.cause = cause;
        return this;
    }

    @Override
    public int shouldThreadAction() {
        return this.size > 4 ? 20 : -1;
    }

    @Override
    public final Collection<BlockEdit> getEffectedBlocks() {
        LinkedList<BlockEdit> list = new LinkedList<BlockEdit>();
        this.getEffectedBlocks(list);
        return list;
    }

    public void getEffectedBlocks(List<BlockEdit> list) {
    }

    @Override
    public void handleBlockPlacement(BlockEdit vec) {
        vec.place();
    }

    @Override
    public void doEffectOther(boolean beforeBlocksPlaced) {
    }

    @Override
    public World world() {
        return this.world;
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public double z() {
        return this.z;
    }
}

