/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.explosive;

import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.api.explosive.IExplosive;
import com.builtbroken.mc.core.References;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.lib.world.edit.IWorldChangeAction;
import com.builtbroken.mc.lib.world.explosive.Blast;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class Explosive
implements IExplosive {
    protected String translationKey;
    protected String id;
    protected String modID;
    protected Class<? extends Blast> blastClass;
    int multiplier = 1;

    public Explosive(Class<? extends Blast> blastClass) {
        this(blastClass.getSimpleName(), blastClass, 1);
    }

    public Explosive(String name, Class<? extends Blast> blastClass) {
        this(name, blastClass, 1);
    }

    public Explosive(String name, Class<? extends Blast> blastClass, int multiplier) {
        this.translationKey = name;
        this.blastClass = blastClass;
        this.multiplier = multiplier;
    }

    @Override
    public IWorldChangeAction createBlastForTrigger(World world, double x, double y, double z, TriggerCause triggerCause, int yieldMultiplier, NBTTagCompound tag) {
        try {
            return this.blastClass.newInstance().setLocation(world, (int)x, (int)y, (int)z).setYield(yieldMultiplier * this.multiplier).setCause(triggerCause);
        }
        catch (InstantiationException e) {
            References.LOGGER.log(Level.ERROR, "Failed to create blast object");
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            References.LOGGER.log(Level.ERROR, "Failed to create blast object");
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void addInfoToItem(ItemStack stack, List<String> lines) {
        lines.add(LanguageUtility.getLocal("info.voltzengine:explosive.size.name") + ": " + this.multiplier);
    }

    @Override
    public void onRegistered(String id, String modID) {
        this.id = id;
        this.modID = modID;
    }

    @Override
    public String getTranslationKey() {
        return "explosive." + this.modID + ":" + this.translationKey;
    }

    @Override
    public String getID() {
        return this.id;
    }
}

