/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.explosive;

import com.builtbroken.mc.api.explosive.IExplosive;
import com.builtbroken.mc.api.items.IExplosiveItem;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.lib.world.explosive.ExplosiveRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ExplosiveItemUtility {
    public static final String EXPLOSIVE_SAVE = "explosiveString";
    public static final String SIZE_SAVE = "exSize";

    public static void addInformation(ItemStack stack, EntityPlayer player, List lines, boolean b) {
        IExplosive ex;
        if (stack != null && stack.func_77973_b() instanceof IExplosiveItem && (ex = ((IExplosiveItem)stack.func_77973_b()).getExplosive(stack)) != null) {
            lines.add(LanguageUtility.getLocal("info.voltzengine:explosive.name") + ": " + LanguageUtility.getLocal(ExplosiveItemUtility.getExplosive(stack).getTranslationKey() + ".name"));
            ArrayList<String> l = new ArrayList<String>();
            ex.addInfoToItem(stack, l);
            for (String s : l) {
                lines.add(s);
            }
        }
    }

    public static void getSubItems(Item item, List list) {
        for (IExplosive ex : ExplosiveRegistry.getExplosives()) {
            ItemStack stack = new ItemStack(item);
            ExplosiveItemUtility.setExplosive(stack, ex);
            ExplosiveItemUtility.setSize(stack, 1);
            list.add(stack);
        }
    }

    public static IExplosive getExplosive(ItemStack itemStack) {
        return ExplosiveItemUtility.getExplosive(itemStack.func_77978_p());
    }

    public static IExplosive getExplosive(NBTTagCompound tag) {
        if (tag != null) {
            return ExplosiveRegistry.get(tag.func_74779_i(EXPLOSIVE_SAVE));
        }
        return null;
    }

    public static void setExplosive(ItemStack itemStack, String ex) {
        ExplosiveItemUtility.setExplosive(itemStack, ExplosiveRegistry.get(ex));
    }

    public static void setExplosive(ItemStack itemStack, IExplosive ex) {
        if (ex != null) {
            if (itemStack.func_77978_p() == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            ExplosiveItemUtility.setExplosive(itemStack.func_77978_p(), ex);
        }
    }

    public static void setExplosive(NBTTagCompound tag, IExplosive ex) {
        if (ex != null) {
            tag.func_74778_a(EXPLOSIVE_SAVE, ex.getID());
        }
    }

    public static int getSize(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return ExplosiveItemUtility.getSize(itemStack.func_77978_p());
    }

    public static int getSize(NBTTagCompound tag) {
        return tag.func_74762_e(SIZE_SAVE);
    }

    public static NBTTagCompound setSize(ItemStack itemStack, int size) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return ExplosiveItemUtility.setSize(itemStack.func_77978_p(), size);
    }

    public static NBTTagCompound setSize(NBTTagCompound tag, int size) {
        tag.func_74768_a(SIZE_SAVE, size);
        return tag;
    }
}

