/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.explosive;

import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.api.explosive.IExplosive;
import com.builtbroken.mc.core.References;
import com.builtbroken.mc.lib.mod.config.Config;
import com.builtbroken.mc.lib.transform.vector.Location;
import com.builtbroken.mc.lib.world.edit.IWorldChangeAction;
import com.builtbroken.mc.lib.world.edit.WorldChangeHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public final class ExplosiveRegistry {
    private static final HashMap<String, IExplosive> idToExplosiveMap = new HashMap();
    private static final HashMap<String, List<IExplosive>> modToExplosiveMap = new HashMap();
    @Config
    public static boolean LOG_REGISTERING_EXPLOSIVES = true;

    public static IExplosive registerOrGetExplosive(String modID, String id, IExplosive ex) {
        if (ExplosiveRegistry.registerExplosive(modID, id, ex)) {
            return ex;
        }
        return ExplosiveRegistry.get(id);
    }

    public static boolean registerExplosive(String modID, String id, IExplosive ex) {
        if (!ExplosiveRegistry.isRegistered(ex) && !idToExplosiveMap.containsKey(id)) {
            idToExplosiveMap.put(id, ex);
            ex.onRegistered(id, modID);
            List<Object> list = modToExplosiveMap.containsKey(modID) ? modToExplosiveMap.get(modID) : new ArrayList();
            list.add(ex);
            modToExplosiveMap.put(modID, list);
            if (LOG_REGISTERING_EXPLOSIVES) {
                References.LOGGER.info("ExplosiveRegistry> Mod: " + modID + "  Registered explosive instance " + ex);
            }
            return true;
        }
        return false;
    }

    public static WorldChangeHelper.ChangeResult triggerExplosive(World world, double x, double y, double z, IExplosive ex, TriggerCause triggerCause, int multi, NBTTagCompound tag) {
        return ExplosiveRegistry.triggerExplosive(new Location(world, x, y, z), ex, triggerCause, multi, tag);
    }

    public static WorldChangeHelper.ChangeResult triggerExplosive(Location loc, IExplosive ex, TriggerCause triggerCause, int multi, NBTTagCompound tag) {
        if (ExplosiveRegistry.isRegistered(ex)) {
            IWorldChangeAction blast = ex.createBlastForTrigger(loc.world(), loc.x(), loc.y(), loc.z(), triggerCause, multi, tag);
            return WorldChangeHelper.doAction(loc, blast, triggerCause);
        }
        return WorldChangeHelper.ChangeResult.FAILED;
    }

    public static boolean isRegistered(IExplosive explosive) {
        return explosive.getID() != null && !explosive.getID().isEmpty() && idToExplosiveMap.containsKey(explosive.getID());
    }

    public static IExplosive get(String name) {
        return idToExplosiveMap.get(name);
    }

    public static Collection<IExplosive> getExplosives() {
        return idToExplosiveMap.values();
    }

    public static Set<String> getMods() {
        return modToExplosiveMap.keySet();
    }

    public static List<IExplosive> getExplosives(String modID) {
        if (modToExplosiveMap.containsKey(modID)) {
            return modToExplosiveMap.get(modID);
        }
        return new ArrayList<IExplosive>();
    }

    public static HashMap<String, IExplosive> getExplosiveMap() {
        return idToExplosiveMap;
    }
}

