/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.schematic;

import com.builtbroken.jlib.type.Pair;
import com.builtbroken.mc.lib.transform.vector.Pos;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class Schematic {
    private String schematicName;

    public Schematic() {
    }

    public Schematic(String name) {
        this.schematicName = name;
    }

    public String getName() {
        return this.schematicName;
    }

    public abstract HashMap<Pos, Pair<Block, Integer>> getStructure(ForgeDirection var1, int var2);

    public HashMap<Pos, Pair<Block, Integer>> getLine(Pos start, ForgeDirection dir, Block block, int meta, int length) {
        HashMap<Pos, Pair<Block, Integer>> returnMap = new HashMap<Pos, Pair<Block, Integer>>();
        for (int i = 0; i < length; ++i) {
            returnMap.put(new Pos(dir).multiply(i).add(start), new Pair<Block, Integer>(block, meta));
        }
        return returnMap;
    }

    public HashMap<Pos, Pair<Block, Integer>> getBox(Pos center, Block block, int meta, int size) {
        return this.getBox(center, block, meta, size, size);
    }

    public HashMap<Pos, Pair<Block, Integer>> getBox(Pos center, Block block, int meta, int sizeX, int sizeZ) {
        HashMap<Pos, Pair<Block, Integer>> returnMap = new HashMap<Pos, Pair<Block, Integer>>();
        Pos start = new Pos(-sizeX, 0.0, -sizeZ).add(center);
        if (sizeX != sizeZ) {
            for (int x = 0; x <= sizeX * 2; ++x) {
                returnMap.put(new Pos(x, 0.0, 0.0).add(start), new Pair<Block, Integer>(block, meta));
                returnMap.put(new Pos(x, 0.0, sizeZ * 2).add(start), new Pair<Block, Integer>(block, meta));
            }
            for (int z = 0; z <= sizeZ * 2; ++z) {
                returnMap.put(new Pos(0.0, 0.0, z).add(start), new Pair<Block, Integer>(block, meta));
                returnMap.put(new Pos(sizeX * 2, 0.0, z).add(start), new Pair<Block, Integer>(block, meta));
            }
        } else {
            for (int s = 0; s <= sizeX * 2; ++s) {
                returnMap.put(new Pos(s, 0.0, 0.0).add(start), new Pair<Block, Integer>(block, meta));
                returnMap.put(new Pos(s, 0.0, sizeZ * 2).add(start), new Pair<Block, Integer>(block, meta));
                returnMap.put(new Pos(0.0, 0.0, s).add(start), new Pair<Block, Integer>(block, meta));
                returnMap.put(new Pos(sizeZ * 2, 0.0, s).add(start), new Pair<Block, Integer>(block, meta));
            }
        }
        return returnMap;
    }
}

