/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.entity;

import com.builtbroken.mc.lib.helper.DamageUtility;
import com.builtbroken.mc.lib.transform.vector.Pos;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;

public abstract class EntityProjectile
extends Entity
implements IProjectile {
    public Pos sourceOfProjectile = null;
    public Entity firedByEntity = null;
    protected boolean canDamage = false;
    private int _ticksInAir = -1;
    private int _ticksInGround = -1;
    private float _health = -1.0f;

    public EntityProjectile(World w) {
        super(w);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70155_l = 3.0;
        this.field_70178_ae = true;
        this.field_70158_ak = true;
    }

    public static Pos getEntityAim(EntityLivingBase entity) {
        float f1 = MathHelper.func_76134_b((float)(-entity.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = MathHelper.func_76126_a((float)(-entity.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = -MathHelper.func_76134_b((float)(-entity.field_70125_A * ((float)Math.PI / 180)));
        float f4 = MathHelper.func_76126_a((float)(-entity.field_70125_A * ((float)Math.PI / 180)));
        return new Pos(f2 * f3, f4, f1 * f3);
    }

    public EntityProjectile(EntityLivingBase entity) {
        this(entity.field_70170_p);
        Pos launcher = new Pos((Entity)entity).add(new Pos(0.0, 1.0, 0.0));
        Pos playerAim = EntityProjectile.getEntityAim(entity);
        Pos start = launcher.add(playerAim.multiply(2.0));
        this.firedByEntity = entity;
        this.sourceOfProjectile = start;
        this.func_70107_b(start.x(), start.y(), start.z());
        this.field_70177_z = entity.field_70177_z;
        this.field_70125_A = entity.field_70125_A;
    }

    public EntityProjectile(World w, Pos startAndSource) {
        this(w);
        this.sourceOfProjectile = startAndSource;
        this.func_70107_b(startAndSource.x(), startAndSource.y(), startAndSource.z());
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(6, (Object)Float.valueOf(this._health));
        this.field_70180_af.func_75682_a(17, (Object)this._ticksInAir);
        this.field_70180_af.func_75682_a(16, (Object)this._ticksInGround);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.setTicksInAir(this.getTicksInAir() + 1);
        if (!this.field_70170_p.field_72995_K && this.getTicksInAir() >= 0) {
            if (this.field_70122_E) {
                this.setTicksInGround(this.getTicksInGround() + 1);
            } else {
                this.setTicksInGround(0);
            }
            if (this.field_70159_w <= 0.001 && this.field_70181_x <= 0.001 && this.field_70179_y <= 0.001) {
                this.onStoppedMoving();
            }
            if (!this.checkForAndTriggerCollision()) {
                this.updateMotion();
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
        }
    }

    public void func_70030_z() {
        this.field_70170_p.field_72984_F.func_76320_a("entityBaseTick");
        if (this.field_70154_o != null && this.field_70154_o.field_70128_L) {
            this.field_70154_o = null;
        }
        this.field_70141_P = this.field_70140_Q;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        if (this.field_70163_u < -640.0) {
            this.func_70076_C();
        }
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    protected boolean checkForAndTriggerCollision() {
        boolean stopped = false;
        Block block = this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
        if (!(block == null || block.isAir((IBlockAccess)this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) || block instanceof IFluidBlock || block instanceof BlockLiquid)) {
            stopped = this.onCollideWithBlock(block, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
        }
        if (this.field_70132_H) {
            stopped = true;
            this.onStoppedMoving();
        }
        return stopped;
    }

    protected void updateMotion() {
        this.field_70125_A = (float)(Math.atan(this.field_70181_x / Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 180.0 / Math.PI);
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        if (this.field_70132_H) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
    }

    protected boolean onCollideWithBlock(Block block, int x, int y, int z) {
        this.onStoppedMoving();
        this.onImpact();
        return true;
    }

    protected void onStoppedMoving() {
    }

    protected void onImpact() {
        this.func_70106_y();
    }

    public Pos getPredictedPosition(int t) {
        Pos newPos = new Pos(this);
        for (int i = 0; i < t; ++i) {
            newPos.add(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        return newPos;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        if (this.ignoreCollisionForEntity(entity)) {
            return null;
        }
        return super.func_70114_g(entity);
    }

    protected boolean ignoreCollisionForEntity(Entity entity) {
        return entity == this.firedByEntity && this.getTicksInAir() <= 50;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b("startPos")) {
            this.sourceOfProjectile = new Pos(nbt.func_74775_l("startPos"));
        }
        this._ticksInAir = nbt.func_74762_e("ticksInAir");
        this._ticksInGround = nbt.func_74762_e("ticksInGround");
        this._health = nbt.func_74760_g("health");
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        if (this.sourceOfProjectile != null) {
            nbt.func_74782_a("startPos", (NBTBase)this.sourceOfProjectile.writeNBT(new NBTTagCompound()));
        }
        nbt.func_74768_a("ticksInAir", this.getTicksInAir());
        nbt.func_74768_a("ticksInGround", this.getTicksInGround());
        nbt.func_74776_a("health", this.getHealth());
    }

    public void func_70186_c(double motionX, double motionY, double motionZ, float power, float spread) {
        float square = MathHelper.func_76133_a((double)(motionX * motionX + motionY * motionY + motionZ * motionZ));
        motionX /= (double)square;
        motionY /= (double)square;
        motionZ /= (double)square;
        motionX += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)spread;
        motionY += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)spread;
        motionZ += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)spread;
        this.field_70159_w = motionX *= (double)power;
        this.field_70181_x = motionY *= (double)power;
        this.field_70179_y = motionZ *= (double)power;
        float f3 = MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(motionX, motionZ) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(motionY, f3) * 180.0 / Math.PI);
        this.setTicksInAir(0);
    }

    public void setMotion(int power) {
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70159_w *= (double)power;
        this.field_70181_x *= (double)power;
        this.field_70179_y *= (double)power;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.canDamage && DamageUtility.canHarm(this, source, damage)) {
            this.setHealth(Math.max(this.getHealth() - damage, 0.0f));
            if (this.getHealth() <= 0.0f) {
                this.onDestroyedBy(source, damage);
            }
            return true;
        }
        return false;
    }

    protected void onDestroyedBy(DamageSource source, float damage) {
        this.func_70106_y();
    }

    public boolean func_70067_L() {
        return true;
    }

    public int getTicksInGround() {
        if (this.field_70170_p == null || !this.field_70170_p.field_72995_K) {
            return this._ticksInGround;
        }
        return this.field_70180_af.func_75679_c(16);
    }

    public void setTicksInGround(int ticks) {
        if (!this.field_70170_p.field_72995_K) {
            this._ticksInGround = ticks;
            this.field_70180_af.func_75692_b(16, (Object)ticks);
        }
    }

    public int getTicksInAir() {
        if (this.field_70170_p == null || !this.field_70170_p.field_72995_K) {
            return this._ticksInAir;
        }
        return this.field_70180_af.func_75679_c(17);
    }

    public void setTicksInAir(int ticks) {
        if (!this.field_70170_p.field_72995_K) {
            this._ticksInAir = ticks;
            this.field_70180_af.func_75692_b(17, (Object)ticks);
        }
    }

    public final float getHealth() {
        if (this.field_70170_p == null || !this.field_70170_p.field_72995_K) {
            return this._health;
        }
        return this.field_70180_af.func_111145_d(6);
    }

    public void setHealth(float p_70606_1_) {
        this._health = p_70606_1_;
        this.field_70180_af.func_75692_b(6, (Object)Float.valueOf(MathHelper.func_76131_a((float)p_70606_1_, (float)0.0f, (float)this.getMaxHealth())));
    }

    public float getMaxHealth() {
        return 5.0f;
    }
}

