/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.recipe;

import com.builtbroken.mc.api.recipe.IMachineRecipe;
import com.builtbroken.mc.api.recipe.IMachineRecipeHandler;
import com.builtbroken.mc.api.recipe.MachineRecipeType;
import com.builtbroken.mc.api.recipe.RecipeRegisterResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class MRHandler<O, K>
implements IMachineRecipeHandler {
    public MachineRecipeType type;
    public Map<K, List<IMachineRecipe>> recipes = new HashMap<K, List<IMachineRecipe>>();

    public MRHandler(MachineRecipeType type) {
        this.type = type;
    }

    @Override
    public final RecipeRegisterResult registerRecipe(IMachineRecipe recipe) {
        if (recipe != null) {
            if (recipe.getType() != this.type) {
                return RecipeRegisterResult.INVALID_TYPE;
            }
            if (recipe.getValidInputs() != null && recipe.getOutput() != null) {
                if (!this.isValidOutput(recipe.getOutput())) {
                    return RecipeRegisterResult.INVALID_OUTPUT;
                }
                for (Object object : recipe.getValidInputs()) {
                    if (this.isValidInput(object)) continue;
                    return RecipeRegisterResult.INVALID_INPUT;
                }
                RecipeRegisterResult result = this.isValidRecipe(recipe);
                if (result == RecipeRegisterResult.REGISTERED) {
                    for (Object o : recipe.getValidInputs()) {
                        K key = this.getKeyFor(o);
                        List<IMachineRecipe> list = null;
                        if (this.recipes.containsKey(key)) {
                            list = this.recipes.get(key);
                        }
                        if (list == null) {
                            list = new ArrayList<IMachineRecipe>();
                        }
                        list.add(recipe);
                        this.recipes.put(key, list);
                    }
                }
                return result;
            }
            return RecipeRegisterResult.INCOMPLETE;
        }
        return RecipeRegisterResult.FAILED;
    }

    public abstract K getKeyFor(Object var1);

    protected abstract boolean isValidInput(Object var1);

    protected abstract boolean isValidOutput(Object var1);

    protected RecipeRegisterResult isValidRecipe(IMachineRecipe recipe) {
        return RecipeRegisterResult.REGISTERED;
    }

    protected abstract O toOutputType(Object var1);

    @Override
    public O getRecipe(Object[] items, float extraChance, float failureChance) {
        if (items != null) {
            for (IMachineRecipe handler : this.getRecipes(items)) {
                Object result;
                if (!handler.shouldHandleRecipe(items) || (result = handler.handleRecipe(items, extraChance, failureChance)) == null) continue;
                return this.toOutputType(result);
            }
        }
        return null;
    }

    @Override
    public final Collection<IMachineRecipe> getRecipes(Object[] items) {
        return this.getRecipes(this.getKeyFor(items));
    }

    public List<IMachineRecipe> getRecipes(K key) {
        List<IMachineRecipe> handlers;
        if (key != null && this.recipes.containsKey(key) && (handlers = this.recipes.get(key)) != null) {
            return handlers;
        }
        return new ArrayList<IMachineRecipe>();
    }

    public List<IMachineRecipe> getRecipes() {
        ArrayList<IMachineRecipe> list = new ArrayList<IMachineRecipe>();
        for (List<IMachineRecipe> l : this.recipes.values()) {
            list.addAll(l);
        }
        return list;
    }
}

