/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.recipe;

import com.builtbroken.mc.api.recipe.IMachineRecipe;
import com.builtbroken.mc.api.recipe.MachineRecipeType;
import java.util.ArrayList;
import java.util.List;

public abstract class MachineRecipe<O, I>
implements IMachineRecipe<O, I> {
    protected final MachineRecipeType type;
    protected List<I> inputs = new ArrayList<I>();

    public MachineRecipe(MachineRecipeType type) {
        this.type = type;
    }

    @Override
    public MachineRecipeType getType() {
        return this.type;
    }

    public MachineRecipe addInputOption(I input) {
        if (!this.inputs.contains(input)) {
            this.inputs.add(input);
        }
        return this;
    }

    @Override
    public List<I> getValidInputs() {
        return this.inputs;
    }

    public String toString() {
        String clazzName = this.getClass().getSimpleName();
        clazzName = clazzName.replaceFirst("MR", "MachineRecipe");
        return clazzName + "[" + this.getOutput() + "]";
    }

    public boolean equals(Object object) {
        IMachineRecipe other;
        if (object instanceof IMachineRecipe && (other = (IMachineRecipe)object).getType() == this.getType() && this.isOutputEqual(other.getOutput())) {
            return other.getValidInputs().equals(this.getValidInputs());
        }
        return false;
    }

    public boolean isOutputEqual(Object out) {
        return out == this.getOutput();
    }
}

