/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.tile;

import com.builtbroken.mc.lib.render.block.BlockRenderHandler;
import com.builtbroken.mc.lib.transform.region.Cuboid;
import com.builtbroken.mc.lib.transform.vector.Point;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import com.builtbroken.mc.prefab.tile.Tile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTile
extends Block
implements ITileEntityProvider {
    public Tile staticTile = null;
    private boolean hasTile = false;

    public BlockTile(Tile tile, String prefix, CreativeTabs tab) {
        super(tile.material);
        this.staticTile = tile;
        this.staticTile.setBlock(this);
        this.field_149787_q = this.func_149662_c();
        this.func_149676_a(this.staticTile.bounds.min().xf(), this.staticTile.bounds.min().yf(), this.staticTile.bounds.min().zf(), this.staticTile.bounds.max().xf(), this.staticTile.bounds.max().yf(), this.staticTile.bounds.max().zf());
        this.func_149663_c(prefix + this.staticTile.name);
        this.func_149658_d(prefix + this.staticTile.textureName);
        this.func_149647_a(this.staticTile.creativeTab == null ? tab : this.staticTile.creativeTab);
        this.func_149713_g(this.func_149662_c() ? 255 : 0);
        this.func_149711_c(this.staticTile.hardness);
        this.func_149752_b(this.staticTile.resistance);
        this.func_149672_a(this.staticTile.stepSound);
    }

    public TileEntity createTileEntity(World world, int meta) {
        return this.staticTile.newTile(world, meta);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return this.staticTile.newTile(world, meta);
    }

    public void func_149639_l(World world, int x, int y, int z) {
        this.inject((IBlockAccess)world, x, y, z);
        this.getTile((IBlockAccess)world, x, y, z).onFillRain();
        this.eject();
    }

    public float func_149638_a(Entity entity) {
        return this.staticTile.getExplosionResistance(entity);
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        this.inject((IBlockAccess)world, x, y, z);
        float resistance = this.getTile((IBlockAccess)world, x, y, z).getExplosionResistance(entity, new Pos(explosionX, explosionY, explosionZ));
        this.eject();
        return resistance;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        this.inject((IBlockAccess)world, x, y, z);
        this.getTile((IBlockAccess)world, x, y, z).onPlayerLeftClick(player);
        this.eject();
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.inject((IBlockAccess)world, x, y, z);
        this.getTile((IBlockAccess)world, x, y, z).onAdded();
        this.eject();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        this.inject((IBlockAccess)world, x, y, z);
        this.getTile((IBlockAccess)world, x, y, z).onPlaced(entityLiving, itemStack);
        this.eject();
    }

    public void func_149714_e(World world, int x, int y, int z, int metadata) {
        this.inject((IBlockAccess)world, x, y, z);
        this.getTile((IBlockAccess)world, x, y, z).onPostPlaced(metadata);
        this.eject();
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion ex) {
        this.inject((IBlockAccess)world, x, y, z);
        this.getTile((IBlockAccess)world, x, y, z).onDestroyedByExplosion(ex);
        this.eject();
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int par6) {
        this.inject((IBlockAccess)world, x, y, z);
        this.getTile((IBlockAccess)world, x, y, z).onRemove(block, par6);
        this.eject();
        super.func_149749_a(world, x, y, z, block, par6);
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return this.staticTile.quantityDropped(meta, fortune);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.inject((IBlockAccess)world, x, y, z);
        this.getTile((IBlockAccess)world, x, y, z).onNeighborChanged(block);
        this.eject();
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        this.inject(world, x, y, z);
        this.getTile(world, x, y, z).onNeighborChanged(new Pos(tileX, tileY, tileZ));
        this.eject();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        this.inject((IBlockAccess)world, x, y, z);
        boolean value = this.getTile((IBlockAccess)world, x, y, z).onPlayerActivated(player, side, new Pos(hitX, hitY, hitZ));
        this.eject();
        return value;
    }

    public void func_149674_a(World world, int x, int y, int z, Random par5Random) {
        this.inject((IBlockAccess)world, x, y, z);
        this.getTile((IBlockAccess)world, x, y, z).blockUpdate();
        this.eject();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random par5Random) {
        this.inject((IBlockAccess)world, x, y, z);
        this.getTile((IBlockAccess)world, x, y, z).randomDisplayTick();
        this.eject();
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        this.inject((IBlockAccess)world, x, y, z);
        this.getTile((IBlockAccess)world, x, y, z).onCollide(entity);
        this.eject();
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        this.inject((IBlockAccess)world, x, y, z);
        Cuboid cube = new Cuboid(aabb).subtract(new Pos(x, y, z));
        Iterable<Cuboid> bounds = this.getTile((IBlockAccess)world, x, y, z).getCollisionBoxes(cube, entity);
        if (bounds != null) {
            for (Cuboid cuboid : bounds) {
                if (!cuboid.isInsideBounds(cube)) continue;
                list.add(cuboid.add(new Pos(x, y, z)).toAABB());
            }
        }
        this.eject();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.inject((IBlockAccess)world, x, y, z);
        Tile tile = this.getTile((IBlockAccess)world, x, y, z);
        AxisAlignedBB value = tile.getSelectBounds().clone().add(tile.x(), tile.y(), tile.z()).toAABB();
        this.eject();
        return value;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.inject((IBlockAccess)world, x, y, z);
        Tile tile = this.getTile((IBlockAccess)world, x, y, z);
        AxisAlignedBB value = tile.getCollisionBounds().clone().add(tile.x(), tile.y(), tile.z()).toAABB();
        this.eject();
        return value;
    }

    public boolean func_149646_a(IBlockAccess access, int x, int y, int z, int side) {
        this.inject(access, x, y, z);
        boolean value = this.staticTile.shouldSideBeRendered(side);
        this.eject();
        return value;
    }

    public boolean func_149747_d(IBlockAccess access, int x, int y, int z, int side) {
        this.inject(access, x, y, z);
        boolean value = this.getTile(access, x, y, z).isSolid(side);
        this.eject();
        return value;
    }

    public int getLightValue(IBlockAccess access, int x, int y, int z) {
        int value = 0;
        if (access != null) {
            this.inject(access, x, y, z);
            value = this.getTile(access, x, y, z).getLightValue();
            this.eject();
        }
        return value;
    }

    public boolean func_149740_M() {
        return false;
    }

    public boolean func_149662_c() {
        return this.staticTile == null || this.staticTile.isOpaque;
    }

    public boolean func_149686_d() {
        return this.staticTile.renderNormalBlock;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return this.staticTile.renderNormalBlock ? 0 : BlockRenderHandler.ID();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess access, int x, int y, int z, int side) {
        this.inject(access, x, y, z);
        IIcon value = this.getTile(access, x, y, z).getIcon(side);
        this.eject();
        return value;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.staticTile.getIcon(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.staticTile.registerIcons(iconRegister);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess access, int x, int y, int z) {
        this.inject(access, x, y, z);
        int value = this.getTile(access, x, y, z).getColorMultiplier();
        this.eject();
        return value;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        this.inject((IBlockAccess)world, x, y, z);
        ItemStack value = this.getTile((IBlockAccess)world, x, y, z).getPickBlock(target);
        this.eject();
        return value;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        this.inject((IBlockAccess)world, x, y, z);
        ArrayList value = this.getTile((IBlockAccess)world, x, y, z).getDrops(metadata, fortune);
        this.eject();
        return value != null ? value : new ArrayList();
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        this.staticTile.getSubBlocks(item, creativeTabs, list);
    }

    public boolean func_149744_f() {
        return this.staticTile.canEmmitRedstone;
    }

    public int func_149709_b(IBlockAccess access, int x, int y, int z, int side) {
        this.inject(access, x, y, z);
        int value = this.getTile(access, x, y, z).getWeakRedstonePower(side);
        this.eject();
        return value;
    }

    public int func_149748_c(IBlockAccess access, int x, int y, int z, int side) {
        this.inject(access, x, y, z);
        int value = this.getTile(access, x, y, z).getStrongRedstonePower(side);
        this.eject();
        return value;
    }

    public void func_149719_a(IBlockAccess access, int x, int y, int z) {
        this.inject(access, x, y, z);
        this.getTile(access, x, y, z).setBlockBoundsBasedOnState();
        this.eject();
    }

    protected void func_149642_a(World world, int x, int y, int z, ItemStack itemStack) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            InventoryUtility.dropItemStack(world, new Pos(x, y, z), itemStack);
        }
    }

    public int func_149701_w() {
        return this.staticTile.getRenderBlockPass();
    }

    public int func_149738_a(World world) {
        this.inject((IBlockAccess)world, 0, 0, 0);
        int t = this.staticTile.tickRate();
        this.eject();
        return t;
    }

    public static Point getClickedFace(Byte hitSide, float hitX, float hitY, float hitZ) {
        switch (hitSide) {
            case 0: {
                return new Point(1.0f - hitX, hitZ);
            }
            case 1: {
                return new Point(hitX, hitZ);
            }
            case 2: {
                return new Point(1.0f - hitX, 1.0f - hitY);
            }
            case 3: {
                return new Point(hitX, 1.0f - hitY);
            }
            case 4: {
                return new Point(hitZ, 1.0f - hitY);
            }
            case 5: {
                return new Point(1.0f - hitZ, 1.0f - hitY);
            }
        }
        return new Point(0.5, 0.5);
    }

    public void inject(IBlockAccess access, int x, int y, int z) {
        if (access instanceof World) {
            this.staticTile.func_145834_a((World)access);
        }
        this.staticTile.setAccess(access);
        this.staticTile.field_145851_c = x;
        this.staticTile.field_145848_d = y;
        this.staticTile.field_145849_e = z;
        TileEntity tile = access.func_147438_o(x, y, z);
        if (tile instanceof Tile) {
            ((Tile)tile).setBlock(this);
        }
    }

    public void eject() {
        this.staticTile.func_145834_a(null);
        this.staticTile.field_145851_c = 0;
        this.staticTile.field_145848_d = 0;
        this.staticTile.field_145849_e = 0;
    }

    public Tile getTile(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof Tile) {
            return (Tile)tile;
        }
        return this.staticTile;
    }
}

