/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.tile;

import com.builtbroken.mc.api.ISave;
import com.builtbroken.mc.api.IUpdate;
import com.builtbroken.mc.api.tile.IInventoryProvider;
import com.builtbroken.mc.api.tile.ISided;
import com.builtbroken.mc.api.tile.ITileModuleProvider;
import com.builtbroken.mc.api.tile.node.ITileModule;
import com.builtbroken.mc.prefab.tile.TileMachine;
import com.builtbroken.mc.prefab.tile.module.TileModuleInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileModuleMachine
extends TileMachine
implements ITileModuleProvider,
IInventoryProvider,
ISidedInventory {
    protected List<ITileModule> modules = new ArrayList<ITileModule>();
    protected TileModuleInventory inventory_module = null;

    public TileModuleMachine(String name, Material material) {
        super(name, material);
    }

    @Override
    public void onNeighborChanged(Block block) {
        super.onNeighborChanged(block);
        for (ITileModule node : this.getNodes()) {
            if (node == null) continue;
            node.onParentChange();
        }
    }

    @Override
    public void onWorldJoin() {
        super.onWorldJoin();
        for (ITileModule node : this.getNodes()) {
            if (node == null) continue;
            node.onJoinWorld();
        }
    }

    @Override
    public void update() {
        super.update();
        for (ITileModule node : this.getNodes()) {
            if (!(node instanceof IUpdate)) continue;
            ((IUpdate)((Object)node)).update();
        }
    }

    public void func_145843_s() {
        for (ITileModule node : this.getNodes()) {
            if (node == null) continue;
            node.onLeaveWorld();
        }
        super.func_145843_s();
    }

    protected final List<ITileModule> getNodes() {
        return this.modules;
    }

    @Override
    public <N extends ITileModule> N getModule(Class<? extends N> nodeType, ForgeDirection from) {
        for (ITileModule module : this.getNodes()) {
            if (module instanceof ISided && !((ISided)((Object)module)).isValidForSide(from) || !nodeType.isAssignableFrom(module.getClass())) continue;
            return (N)module;
        }
        return null;
    }

    public boolean addInventoryModule(int size) {
        if (this.inventory_module != null) {
            this.inventory_module = new TileModuleInventory(this, size);
            this.modules.add(this.inventory_module);
            return true;
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (ITileModule node : this.getNodes()) {
            if (!(node instanceof ISave)) continue;
            ((ISave)((Object)node)).load(nbt);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        for (ITileModule node : this.getNodes()) {
            if (!(node instanceof ISave)) continue;
            ((ISave)((Object)node)).save(nbt);
        }
    }

    @Override
    public TileModuleInventory getInventory() {
        return this.inventory_module;
    }

    @Override
    public boolean canStore(ItemStack stack, int slot, ForgeDirection side) {
        return false;
    }

    @Override
    public boolean canRemove(ItemStack stack, int slot, ForgeDirection side) {
        return false;
    }

    public int[] func_94128_d(int side) {
        if (this.getInventory() != null) {
            return this.getInventory().func_94128_d(side);
        }
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack itemStack, int side) {
        if (this.getInventory() != null) {
            return this.getInventory().func_102007_a(side, itemStack, side);
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        if (this.getInventory() != null) {
            return this.getInventory().func_102008_b(side, itemStack, side);
        }
        return false;
    }

    public int func_70302_i_() {
        if (this.getInventory() != null) {
            return this.getInventory().func_70302_i_();
        }
        return 0;
    }

    public ItemStack func_70301_a(int slot) {
        if (this.getInventory() != null) {
            return this.getInventory().func_70301_a(slot);
        }
        return null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.getInventory() != null) {
            return this.getInventory().func_70298_a(slot, amount);
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.getInventory() != null) {
            return this.getInventory().func_70304_b(slot);
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (this.getInventory() != null) {
            this.getInventory().func_70299_a(slot, stack);
        }
    }

    public String func_145825_b() {
        if (this.getInventory() != null) {
            return this.getInventory().func_145825_b();
        }
        return "";
    }

    public boolean func_145818_k_() {
        if (this.getInventory() != null) {
            return this.getInventory().func_145818_k_();
        }
        return false;
    }

    public int func_70297_j_() {
        if (this.getInventory() != null) {
            return this.getInventory().func_70297_j_();
        }
        return 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.getInventory() != null) {
            return this.getInventory().func_70300_a(player);
        }
        return false;
    }

    public void func_70295_k_() {
        if (this.getInventory() != null) {
            this.getInventory().func_70295_k_();
        }
    }

    public void func_70305_f() {
        if (this.getInventory() != null) {
            this.getInventory().func_70305_f();
        }
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (this.getInventory() != null) {
            return this.getInventory().func_94041_b(slot, stack);
        }
        return false;
    }
}

