/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.testing.junit;

import com.builtbroken.mc.lib.helper.ReflectionUtility;
import com.builtbroken.mc.testing.junit.AbstractTest;
import com.google.common.io.Files;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;

public class VoltzTestRunner
extends Runner {
    protected Class<? extends AbstractTest> clazz;
    protected LaunchClassLoader loader;
    protected Object test;
    protected Class<?> test_class;
    protected HashMap<Method, Description> testMethods = new HashMap();
    protected Method setUpClass;
    protected Method setUp;
    protected Method tearDownClass;
    protected Method tearDown;

    public VoltzTestRunner(Class<? extends AbstractTest> clazz) throws InitializationError, ClassNotFoundException {
        this.clazz = clazz;
        this.init();
    }

    public void init() {
        try {
            Object[] data = new Object[]{"", "", "", "", "1.7.10", "", Files.createTempDir(), Collections.EMPTY_LIST};
            URL[] urLs = ((URLClassLoader)Launch.class.getClassLoader()).getURLs();
            this.loader = new LaunchClassLoader(urLs);
            Class itemz = this.loader.loadClass("cpw.mods.fml.relauncher.FMLRelaunchLog");
            Field mz = itemz.getDeclaredField("side");
            mz.setAccessible(true);
            mz.set(itemz, Enum.valueOf(mz.getType(), "CLIENT"));
            Class item1 = this.loader.loadClass("cpw.mods.fml.common.Loader");
            Method m1 = item1.getMethod("injectData", Object[].class);
            m1.invoke(null, new Object[]{data});
            this.test_class = this.loader.loadClass(this.clazz.getName());
            this.test = this.test_class.newInstance();
            this.setUpClass = ReflectionUtility.getMethod(this.test_class, "setUpForEntireClass", new Class[0]);
            this.setUp = ReflectionUtility.getMethod(this.test_class, "setUpForTest", String.class);
            this.tearDownClass = ReflectionUtility.getMethod(this.test_class, "tearDownForEntireClass", new Class[0]);
            this.tearDown = ReflectionUtility.getMethod(this.test_class, "tearDownForTest", String.class);
            for (Method method : this.test_class.getMethods()) {
                String name = method.getName();
                Test an = method.getAnnotation(Test.class);
                if (an == null && !name.startsWith("test")) continue;
                this.testMethods.put(method, Description.createTestDescription(this.test_class, (String)method.getName()));
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public Description getDescription() {
        Description description = Description.createSuiteDescription((String)(this.clazz + "-Suit"), (Annotation[])new Annotation[0]);
        for (Map.Entry<Method, Description> entry : this.testMethods.entrySet()) {
            description.addChild(entry.getValue());
        }
        return description;
    }

    public void run(RunNotifier notifier) {
        try {
            this.setUpClass.invoke(this.test, new Object[0]);
            for (Map.Entry<Method, Description> entry : this.testMethods.entrySet()) {
                Method method = entry.getKey();
                String name = entry.getKey().getName();
                notifier.fireTestStarted(entry.getValue());
                try {
                    this.setUp.invoke(this.test, name);
                    method.invoke(this.test, new Object[0]);
                    this.tearDown.invoke(this.test, name);
                }
                catch (Exception e) {
                    Throwable cause = e;
                    if (e instanceof InvocationTargetException) {
                        cause = e.getCause();
                    }
                    cause = new RuntimeException("Test " + name + " has failed", cause);
                    Failure failure = new Failure(entry.getValue(), cause);
                    notifier.fireTestFailure(failure);
                }
                notifier.fireTestFinished(entry.getValue());
            }
            this.tearDownClass.invoke(this.test, new Object[0]);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        notifier.fireTestRunFinished(new Result());
    }
}

