/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.testing.junit.world;

import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.testing.junit.ModRegistry;
import com.builtbroken.mc.testing.junit.world.FakeWorldProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.storage.WorldInfo;

public class FakeWorld
extends World {
    public static boolean blocksInit = false;
    public List<TileEntity> tiles = new ArrayList<TileEntity>();
    Data[][][] mapData;
    int size;

    public FakeWorld() {
        this(50);
    }

    public FakeWorld(int size) {
        super(null, "FakeWorld", (WorldProvider)new FakeWorldProvider(), new WorldSettings(new WorldInfo(new NBTTagCompound())), new Profiler());
        this.size = size;
        this.mapData = new Data[size + size + 1][256][size + size + 1];
        ModRegistry.init();
    }

    public void func_72939_s() {
        Iterator<TileEntity> tile_iterator = this.tiles.iterator();
        while (tile_iterator.hasNext()) {
            TileEntity tile = tile_iterator.next();
            if (tile.func_145837_r()) {
                tile_iterator.remove();
                continue;
            }
            tile.func_145845_h();
        }
    }

    public Block func_147439_a(int x, int y, int z) {
        if (this.inMap(x, y, z)) {
            return this.get((int)x, (int)y, (int)z).block;
        }
        return null;
    }

    public boolean func_147465_d(int x, int y, int z, Block block, int meta, int notify) {
        boolean added_flag = false;
        boolean change_flag = false;
        if (block == null) {
            throw new NullPointerException("World.setBlock() can not set a location to null, use Blocks.Air in value of null");
        }
        if (this.inMap(x, y, z)) {
            Block pre_block = this.func_147439_a(x, y, z);
            if (block != pre_block || this.func_72805_g(x, y, z) != meta) {
                TileEntity newTile;
                this.get((int)x, (int)y, (int)z).block = block;
                this.get((int)x, (int)y, (int)z).meta = meta;
                change_flag = true;
                if (block != pre_block) {
                    added_flag = true;
                }
                TileEntity tileEntity = newTile = block != null ? block.createTileEntity((World)this, meta) : null;
                if (newTile != this.get((int)x, (int)y, (int)z).tile) {
                    if (this.get((int)x, (int)y, (int)z).tile != null) {
                        this.get((int)x, (int)y, (int)z).tile.func_145843_s();
                    }
                    this.get((int)x, (int)y, (int)z).tile = newTile;
                    if (newTile != null) {
                        newTile.func_145834_a((World)this);
                        newTile.field_145851_c = x;
                        newTile.field_145848_d = y;
                        newTile.field_145849_e = z;
                        newTile.func_145829_t();
                        if (newTile.canUpdate()) {
                            this.tiles.add(newTile);
                        }
                    }
                }
                if (added_flag) {
                    block.func_149726_b((World)this, x, y, z);
                }
                if (change_flag && notify != 0) {
                    this.func_147444_c(x, y, z, block);
                }
            }
            return true;
        }
        throw new RuntimeException("Something Attempted to place a block out side of the test area " + new Pos(x, y, z));
    }

    public int func_72805_g(int x, int y, int z) {
        if (this.inMap(x, y, z)) {
            return this.get((int)x, (int)y, (int)z).meta;
        }
        return 0;
    }

    public boolean func_72921_c(int x, int y, int z, int meta, int n) {
        if (this.inMap(x, y, z)) {
            this.get((int)x, (int)y, (int)z).meta = meta;
            this.func_147444_c(x, y, z, this.get((int)x, (int)y, (int)z).block);
            return true;
        }
        return false;
    }

    public TileEntity func_147438_o(int x, int y, int z) {
        if (this.inMap(x, y, z)) {
            return this.get((int)x, (int)y, (int)z).tile;
        }
        return null;
    }

    public void func_147460_e(int x, int y, int z, Block block) {
        Block b = this.func_147439_a(x, y, z);
        if (b != null) {
            b.func_149695_a((World)this, x, y, z, block);
        }
    }

    private boolean inMap(int x, int y, int z) {
        return x >= -this.size && x < this.mapData.length - this.size && y >= -this.size && y < this.mapData[0].length - this.size && z >= -this.size && z < this.mapData[0][0].length - this.size;
    }

    public Data get(int x, int y, int z) {
        if (this.mapData[x + this.size][y + this.size][z + this.size] == null) {
            this.mapData[x + this.size][y + this.size][z + this.size] = new Data();
            this.mapData[x + this.size][y + this.size][z + this.size].block = Blocks.field_150350_a;
        }
        return this.mapData[x + this.size][y + this.size][z + this.size];
    }

    public void genFlatData() {
        for (int x = -this.size; x < this.mapData.length - this.size; ++x) {
            int y = -this.size;
            while (x < this.mapData[0].length - this.size) {
                int z = -this.size;
                while (x < this.mapData[0][0].length - this.size) {
                    if (y == 0) {
                        this.func_147449_b(x, y, z, Blocks.field_150357_h);
                    } else if (y < 5) {
                        this.func_147449_b(x, y, z, Blocks.field_150348_b);
                    } else if (y < 10) {
                        this.func_147449_b(x, y, z, Blocks.field_150346_d);
                    } else {
                        if (y >= 11) break;
                        this.func_147449_b(x, y, z, (Block)Blocks.field_150349_c);
                    }
                    ++x;
                }
                ++x;
            }
        }
    }

    public void clear() {
        for (int x = 0; x < this.mapData.length; ++x) {
            int y = 0;
            while (x < this.mapData[0].length) {
                boolean z = false;
                while (x < this.mapData[0][0].length) {
                    Data data = this.mapData[x][y][x];
                    if (data != null) {
                        if (data.tile != null) {
                            data.tile.func_145843_s();
                            data.tile.func_145834_a(null);
                            data.tile = null;
                        }
                        data.block = null;
                    }
                    ++x;
                }
                ++x;
            }
        }
    }

    public void printLevel(int y) {
        for (int x = 0; x < this.mapData.length; ++x) {
            boolean z = false;
            while (x < this.mapData[0][0].length) {
                Data data = this.mapData[x][y][x];
                if (data != null) {
                    System.out.println("Data[" + data.block + ", " + data.meta + "]");
                }
                ++x;
            }
        }
    }

    protected IChunkProvider func_72970_h() {
        return null;
    }

    protected int func_152379_p() {
        return 0;
    }

    public Entity func_73045_a(int p_73045_1_) {
        return null;
    }

    public static class Data {
        public Block block = null;
        public TileEntity tile = null;
        public int meta = 0;
    }
}

