/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core;

import com.builtbroken.jlib.lang.StringHelpers;
import com.builtbroken.mc.api.VoltzEngineAPI;
import com.builtbroken.mc.api.process.IWorkerThread;
import com.builtbroken.mc.api.recipe.MachineRecipeType;
import com.builtbroken.mc.core.CommonProxy;
import com.builtbroken.mc.core.References;
import com.builtbroken.mc.core.asm.ProxyASMTest;
import com.builtbroken.mc.core.commands.CommandVE;
import com.builtbroken.mc.core.commands.permissions.GroupProfileHandler;
import com.builtbroken.mc.core.content.blocks.BlockHeatedStone;
import com.builtbroken.mc.core.content.debug.ItemDevData;
import com.builtbroken.mc.core.content.debug.ItemInstaHole;
import com.builtbroken.mc.core.content.debug.TileInfInv;
import com.builtbroken.mc.core.content.parts.ItemCircuits;
import com.builtbroken.mc.core.content.parts.ItemCraftingParts;
import com.builtbroken.mc.core.content.resources.BlockOre;
import com.builtbroken.mc.core.content.resources.DefinedGenItems;
import com.builtbroken.mc.core.content.resources.GenMaterial;
import com.builtbroken.mc.core.content.resources.ItemBlockGemOre;
import com.builtbroken.mc.core.content.resources.ItemBlockOre;
import com.builtbroken.mc.core.content.resources.MetallicOres;
import com.builtbroken.mc.core.content.resources.gems.BlockGemOre;
import com.builtbroken.mc.core.content.resources.gems.GemOres;
import com.builtbroken.mc.core.content.resources.gems.GemTypes;
import com.builtbroken.mc.core.content.resources.gems.Gems;
import com.builtbroken.mc.core.content.resources.gems.ItemGem;
import com.builtbroken.mc.core.content.resources.items.ItemGenMaterial;
import com.builtbroken.mc.core.content.resources.items.ItemSheetMetal;
import com.builtbroken.mc.core.content.resources.load.CastRecipeLoader;
import com.builtbroken.mc.core.content.resources.load.CrusherRecipeLoad;
import com.builtbroken.mc.core.content.resources.load.FluidSmelterRecipeLoad;
import com.builtbroken.mc.core.content.resources.load.GearRecipeLoader;
import com.builtbroken.mc.core.content.resources.load.GrinderRecipeLoad;
import com.builtbroken.mc.core.content.resources.load.NuggetRecipeLoader;
import com.builtbroken.mc.core.content.resources.load.PlateRecipeLoader;
import com.builtbroken.mc.core.content.resources.load.RodRecipeLoader;
import com.builtbroken.mc.core.content.resources.load.ScrewRecipeLoader;
import com.builtbroken.mc.core.content.resources.load.SmeltingRecipeLoad;
import com.builtbroken.mc.core.content.resources.load.WireRecipeLoader;
import com.builtbroken.mc.core.content.tool.ItemScrewdriver;
import com.builtbroken.mc.core.content.tool.ItemSelectionWand;
import com.builtbroken.mc.core.content.tool.ItemSheetMetalTools;
import com.builtbroken.mc.core.content.tool.ItemSimpleCraftingTool;
import com.builtbroken.mc.core.content.tool.screwdriver.ToolMode;
import com.builtbroken.mc.core.content.tool.screwdriver.ToolModeGeneral;
import com.builtbroken.mc.core.content.tool.screwdriver.ToolModeRotation;
import com.builtbroken.mc.core.content.world.DevWorldLoader;
import com.builtbroken.mc.core.handler.InteractionHandler;
import com.builtbroken.mc.core.handler.SaveManager;
import com.builtbroken.mc.core.handler.SelectionHandler;
import com.builtbroken.mc.core.handler.TileTaskTickHandler;
import com.builtbroken.mc.core.network.netty.PacketManager;
import com.builtbroken.mc.core.registry.MassRegistry;
import com.builtbroken.mc.core.registry.ModManager;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.lib.helper.PotionUtility;
import com.builtbroken.mc.lib.json.JsonContentLoader;
import com.builtbroken.mc.lib.mod.AbstractProxy;
import com.builtbroken.mc.lib.mod.compat.Mods;
import com.builtbroken.mc.lib.mod.compat.ae.AEProxy;
import com.builtbroken.mc.lib.mod.compat.bc.BCProxy;
import com.builtbroken.mc.lib.mod.compat.ic.ICProxy;
import com.builtbroken.mc.lib.mod.compat.mek.MekProxy;
import com.builtbroken.mc.lib.mod.compat.nei.NEIProxy;
import com.builtbroken.mc.lib.mod.compat.oc.OCProxy;
import com.builtbroken.mc.lib.mod.compat.pe.ProjectEProxy;
import com.builtbroken.mc.lib.mod.compat.rf.RFLoader;
import com.builtbroken.mc.lib.mod.compat.te.TEProxy;
import com.builtbroken.mc.lib.mod.compat.tinkers.TinkerProxy;
import com.builtbroken.mc.lib.mod.compat.ue.TileUniversalBattery;
import com.builtbroken.mc.lib.mod.config.ConfigHandler;
import com.builtbroken.mc.lib.mod.config.ConfigScanner;
import com.builtbroken.mc.lib.mod.loadable.LoadableHandler;
import com.builtbroken.mc.lib.world.edit.PlacementData;
import com.builtbroken.mc.lib.world.edit.thread.WorkerThread;
import com.builtbroken.mc.lib.world.edit.thread.WorldActionQue;
import com.builtbroken.mc.lib.world.explosive.ExplosiveRegistry;
import com.builtbroken.mc.lib.world.heat.HeatedBlockRegistry;
import com.builtbroken.mc.lib.world.radar.RadarRegistry;
import com.builtbroken.mc.lib.world.radio.RadioRegistry;
import com.builtbroken.mc.prefab.explosive.handler.ExplosiveHandlerTNT;
import com.builtbroken.mc.prefab.recipe.cast.MRHandlerCast;
import com.builtbroken.mc.prefab.recipe.fluid.MRHandlerFluidStack;
import com.builtbroken.mc.prefab.recipe.item.MRHandlerItemStack;
import com.builtbroken.mc.prefab.recipe.item.MRSmelterHandler;
import com.builtbroken.mc.prefab.recipe.item.RecipeTool;
import com.builtbroken.mc.prefab.recipe.item.sheetmetal.RecipeSheetMetal;
import com.builtbroken.mc.prefab.tile.item.ItemBlockMetadata;
import com.builtbroken.mc.prefab.tile.multiblock.BlockMultiblock;
import com.builtbroken.mc.prefab.tile.multiblock.EnumMultiblock;
import com.builtbroken.mc.prefab.tile.multiblock.ItemBlockMulti;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="VoltzEngine", name="Voltz Engine", version="0.23.1.11", acceptableRemoteVersions="*", dependencies="required-after:Forge;after:TConstruct")
public class Engine {
    public static final ModManager contentRegistry = new ModManager().setPrefix("voltzengine:").setTab(CreativeTabs.field_78040_i);
    public static final boolean runningAsDev = System.getProperty("development") != null && System.getProperty("development").equalsIgnoreCase("true");
    @SidedProxy(clientSide="com.builtbroken.mc.client.ClientProxy", serverSide="com.builtbroken.mc.core.ServerProxy")
    public static CommonProxy proxy;
    @Mod.Metadata(value="VoltzEngine")
    public static ModMetadata metadata;
    @Mod.Instance(value="VoltzEngine")
    public static Engine instance;
    public LoadableHandler loader;
    public ModManager manager;
    protected static Logger logger;
    private Configuration config;
    public static Block ore;
    public static Block gemOre;
    public static Block heatedStone;
    public static Block multiBlock;
    public static Block blockInfInventory;
    public static Item itemWrench;
    public static ItemSimpleCraftingTool itemSimpleCraftingTools;
    public static ItemSheetMetalTools itemSheetMetalTools;
    public static Item itemSheetMetal;
    public static Item instaHole;
    public static Item itemSelectionTool;
    public static Item itemCircuits;
    public static Item itemDevTool;
    public static Item itemCraftingParts;
    private static boolean metallicOresRequested;
    private static boolean gemOresRequested;
    private static boolean sheetMetalRequested;
    private static boolean multiBlockRequested;
    private static boolean craftingPartsRequested;
    public static boolean heatedRockRequested;
    public static boolean simpleToolsRequested;
    public static boolean circuitsRequested;
    public final PacketManager packetHandler = new PacketManager("voltzengine");
    public static Configuration heatDataConfig;
    public static Configuration explosiveConfig;
    public static int actionProcessorThreads;
    public static boolean enabledHeatMap;
    public static boolean log_registering_explosives;
    public static int INGOT_VOLUME;
    public static double TO_RF_RATIO;
    public static double TO_BC_RATIO;
    protected static List<String> requestedContent;
    protected static HashMap<String, Block> requestedBlocks;
    protected static HashMap<String, Item> requestedItems;

    public static void requestOres() {
        Engine.requestMetalOres();
        Engine.requestGemOres();
        requestedContent.add("ore");
    }

    public static void requestMetalOres() {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            throw new RuntimeException("Ores can only be requested in Pre-Init phase!");
        }
        metallicOresRequested = true;
    }

    public static void requestGemOres() {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            throw new RuntimeException("Ores can only be requested in Pre-Init phase!");
        }
        gemOresRequested = true;
    }

    public static void requestResources() {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            throw new RuntimeException("Resources can only be requested in Pre-Init phase");
        }
        DefinedGenItems.DUST.requestToLoad();
        DefinedGenItems.DUST_IMPURE.requestToLoad();
        DefinedGenItems.RUBBLE.requestToLoad();
        DefinedGenItems.INGOT.requestToLoad();
        DefinedGenItems.PLATE.requestToLoad();
        DefinedGenItems.ROD.requestToLoad();
        DefinedGenItems.GEAR.requestToLoad();
        DefinedGenItems.NUGGET.requestToLoad();
        DefinedGenItems.WIRE.requestToLoad();
        DefinedGenItems.SCREW.requestToLoad();
        GemTypes.UNCUT.requestToLoad();
    }

    public static void requestToolParts() {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            throw new RuntimeException("Tool Parts can only be requested in Pre-Init phase");
        }
        DefinedGenItems.AX_HEAD.requestToLoad();
        DefinedGenItems.SHOVEL_HEAD.requestToLoad();
        DefinedGenItems.HOE_HEAD.requestToLoad();
        DefinedGenItems.PICK_HEAD.requestToLoad();
        DefinedGenItems.SWORD_BLADE.requestToLoad();
    }

    public static void requestCircuits() {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            throw new RuntimeException("Circuit content can only be requested in Pre-Init phase");
        }
        circuitsRequested = true;
    }

    public static void requestCraftingParts() {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            throw new RuntimeException("Crafting parts can only be requested in Pre-Init phase");
        }
        craftingPartsRequested = true;
    }

    public static void requestMultiBlock() {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            throw new RuntimeException("Multi block content can only be requested in Pre-Init phase");
        }
        multiBlockRequested = true;
    }

    public static void requestSimpleTools() {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            throw new RuntimeException("Simple tool content can only be requested in Pre-Init phase");
        }
        simpleToolsRequested = true;
    }

    public static void requestSheetMetalContent() {
        if (!Loader.instance().isInState(LoaderState.PREINITIALIZATION)) {
            throw new RuntimeException("Sheet metal content can only be requested in Pre-Init phase");
        }
        sheetMetalRequested = true;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        VoltzEngineAPI.massRegistry = new MassRegistry();
        References.GLOBAL_CONFIG_FOLDER = event.getModConfigurationDirectory();
        References.ROOT_FOLDER = References.GLOBAL_CONFIG_FOLDER.getParentFile();
        References.BBM_CONFIG_FOLDER = new File(event.getModConfigurationDirectory(), "bbm");
        this.config = new Configuration(new File(References.BBM_CONFIG_FOLDER, "ve/VoltzEngine.cfg"));
        heatDataConfig = new Configuration(new File(event.getModConfigurationDirectory(), "bbm/ve/HeatMap.cfg"));
        explosiveConfig = new Configuration(new File(event.getModConfigurationDirectory(), "bbm/ve/Explosives.cfg"));
        this.loader = new LoadableHandler();
        this.manager = new ModManager().setPrefix("voltzengine").setTab(CreativeTabs.field_78027_g);
        this.config.load();
        heatDataConfig.load();
        explosiveConfig.load();
        References.LOGGER = logger;
        ConfigScanner.instance().generateSets(event.getAsmData());
        ConfigHandler.sync(this.getConfig(), "voltzengine");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        MinecraftForge.EVENT_BUS.register((Object)SaveManager.instance());
        MinecraftForge.EVENT_BUS.register((Object)new InteractionHandler());
        MinecraftForge.EVENT_BUS.register((Object)SelectionHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)RadarRegistry.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)RadarRegistry.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)RadioRegistry.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)RadioRegistry.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)new WorldActionQue());
        FMLCommonHandler.instance().bus().register((Object)TileTaskTickHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)SelectionHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)proxy);
        enabledHeatMap = heatDataConfig.getBoolean("EnabledHeatMap", "general", true, "Heat map handles interaction of heat based energy and the world. Disable only if it causes issues or you want to reduce world file size. If disabled it can prevent machines from working.");
        log_registering_explosives = explosiveConfig.getBoolean("EnableRegisterLogging", "general", false, "Adds debug each time a mod registers an explosive handler. Should only be enabled to figure out which mod is overriding another mod's explosive");
        MachineRecipeType.ITEM_SMELTER.setHandler(new MRSmelterHandler());
        MachineRecipeType.ITEM_GRINDER.setHandler(new MRHandlerItemStack(MachineRecipeType.ITEM_GRINDER.INTERNAL_NAME));
        MachineRecipeType.ITEM_CRUSHER.setHandler(new MRHandlerItemStack(MachineRecipeType.ITEM_CRUSHER.INTERNAL_NAME));
        MachineRecipeType.ITEM_WASHER.setHandler(new MRHandlerItemStack(MachineRecipeType.ITEM_WASHER.INTERNAL_NAME));
        MachineRecipeType.ITEM_SAWMILL.setHandler(new MRHandlerItemStack(MachineRecipeType.ITEM_SAWMILL.INTERNAL_NAME));
        MachineRecipeType.FLUID_SMELTER.setHandler(new MRHandlerFluidStack(MachineRecipeType.FLUID_SMELTER.INTERNAL_NAME));
        MachineRecipeType.FLUID_CAST.setHandler(new MRHandlerCast());
        RecipeSorter.register((String)"voltzengine:sheetMetalTools", RecipeSheetMetal.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        RecipeSorter.register((String)"voltzengine:Tools", RecipeTool.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        if (this.config.getBoolean("ASMTestingEnabled", "Internal", true, "Enables the testing of the internally used ASM code, used to ensure quality of the game. Only disable if you know the ASM is functional or there are issues with it running. Normally though if the ASM test fails then the ASM code itself was not injected. Which will result in several features of the mod not functioning correctly.")) {
            this.loader.applyModule(new ProxyASMTest());
        }
        this.loader.applyModule(this.getProxy());
        this.loader.applyModule(this.packetHandler);
        this.loader.applyModule(GroupProfileHandler.GLOBAL);
        this.loader.applyModule(SmeltingRecipeLoad.class);
        this.loader.applyModule(CrusherRecipeLoad.class);
        this.loader.applyModule(GrinderRecipeLoad.class);
        this.loader.applyModule(FluidSmelterRecipeLoad.class);
        this.loader.applyModule(CastRecipeLoader.class);
        this.loader.applyModule(GearRecipeLoader.class);
        this.loader.applyModule(RodRecipeLoader.class);
        this.loader.applyModule(PlateRecipeLoader.class);
        this.loader.applyModule(NuggetRecipeLoader.class);
        this.loader.applyModule(WireRecipeLoader.class);
        this.loader.applyModule(ScrewRecipeLoader.class);
        this.loader.applyModule(JsonContentLoader.INSTANCE);
        this.config.setCategoryComment("Mod_Support", "If true the proxy class for the mod will be loaded enabling support, set to false if support is not required or breaks the game.");
        this.loader.applyModule(NEIProxy.class);
        this.loader.applyModule(OCProxy.class, Mods.OC.isLoaded());
        this.loader.applyModule(TinkerProxy.class, Mods.TINKERS.isLoaded());
        this.loader.applyModule(AEProxy.class, Mods.AE.isLoaded());
        this.loader.applyModule(ICProxy.class, Mods.IC2.isLoaded());
        this.loader.applyModule(BCProxy.class, Mods.BC.isLoaded());
        this.loader.applyModule(MekProxy.class, Mods.MEKANISM.isLoaded());
        this.loader.applyModule(ProjectEProxy.class, Mods.PROJECT_E.isLoaded());
        if (runningAsDev) {
            this.loader.applyModule(new DevWorldLoader());
        }
        boolean shouldLoadRFHandler = true;
        for (String s : new String[]{"IEnergyConnection", "IEnergyContainerItem", "IEnergyHandler", "IEnergyProvider", "IEnergyReceiver", "IEnergyStorage"}) {
            try {
                Class<?> clazz = Class.forName("cofh.api.energy." + s, false, this.getClass().getClassLoader());
                if (clazz != null) continue;
                shouldLoadRFHandler = false;
                break;
            }
            catch (ClassNotFoundException e) {
                shouldLoadRFHandler = false;
                Engine.logger().error("Not loading RF support as we couldn't detect cofh.api.energy." + s + " class or interface.");
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (shouldLoadRFHandler) {
            this.loader.applyModule(RFLoader.class);
            this.loader.applyModule(TEProxy.class, Mods.TF_EXPANSION.isLoaded());
        }
        PotionUtility.resizePotionArray();
        CommandVE.disableCommands = this.getConfig().getBoolean("DisableServerCommands", "Commands", false, "Turns off all commands built into Voltz Engine");
        CommandVE.disableButcherCommand = this.getConfig().getBoolean("DisableButcherCommands", "Commands", false, "Turns off butcher command");
        CommandVE.disableClearCommand = this.getConfig().getBoolean("DisableClearCommands", "Commands", false, "Turns off clear command");
        CommandVE.disableRemoveCommand = this.getConfig().getBoolean("DisableRemoverCommands", "Commands", false, "Turns off remove command");
        ToolMode.REGISTRY.add(new ToolModeGeneral());
        ToolMode.REGISTRY.add(new ToolModeRotation());
        if (this.getConfig().get("Content", "LoadInstantHole", runningAsDev, "This is a developer tool for checking if ores generated correctly. It creates a chunk sized hole in the ground replacing stone with air, and air with glass. Never enable or give this to normal users as it can be used for greifing.").getBoolean(runningAsDev)) {
            instaHole = contentRegistry.newItem("ve.instanthole", new ItemInstaHole());
        }
        if (this.getConfig().get("Content", "LoadDevDataTool", runningAsDev, "This is a developer tool for checking data on blocks and tile").getBoolean(runningAsDev)) {
            itemDevTool = contentRegistry.newItem("ve.devTool", new ItemDevData());
        }
        if (this.getConfig().get("Content", "LoadScrewDriver", true, "Basic tool for configuring, rotating, and picking up machines.").getBoolean(true)) {
            itemWrench = this.getManager().newItem("ve.screwdriver", new ItemScrewdriver());
        }
        if (this.getConfig().get("Content", "LoadSelectionTool", true, "Admin tool for selecting areas on the ground for world manipulation or other tasks.").getBoolean(true)) {
            itemSelectionTool = this.getManager().newItem("ve.selectiontool", new ItemSelectionWand());
        }
        if (runningAsDev) {
            blockInfInventory = this.getManager().newBlock(TileInfInv.class, new Object[0]);
        }
        ExplosiveRegistry.registerOrGetExplosive("voltzengine", "TNT", new ExplosiveHandlerTNT());
        int tntValue = 4;
        ExplosiveRegistry.registerExplosiveItem(new ItemStack(Blocks.field_150335_W), ExplosiveRegistry.get("TNT"), 4.0);
        ExplosiveRegistry.registerExplosiveItem(new ItemStack(Items.field_151016_H), ExplosiveRegistry.get("TNT"), 0.8);
        ExplosiveRegistry.registerExplosiveItem(new ItemStack(Items.field_151144_bL, 1, 4), ExplosiveRegistry.get("TNT"), 0.4);
        this.loader.preInit();
        OreDictionary.registerOre((String)"stickWood", (Item)Items.field_151055_y);
        OreDictionary.registerOre((String)"string", (Item)Items.field_151007_F);
        OreDictionary.registerOre((String)"flint", (Item)Items.field_151145_ak);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        boolean forceLoadCraftingParts;
        Engine.metadata.modId = "Voltz Engine";
        Engine.metadata.name = "Voltz Engine";
        Engine.metadata.description = "Voltz Engine is a content creation toolkit";
        Engine.metadata.url = "http://www.builtbroken.com/pages/voltzengine/";
        Engine.metadata.version = "0.23.1.1111";
        Engine.metadata.authorList = Arrays.asList("DarkCow");
        Engine.metadata.autogenerated = false;
        if (runningAsDev) {
            this.manager.newBlock("UEBattery", TileUniversalBattery.class, new Object[0]);
        }
        if ((this.getConfig().hasKey("Content", "LoadOres") || metallicOresRequested) && this.getConfig().getBoolean("LoadOres", "Content", metallicOresRequested, "Loads up ore blocks and generators. Ore Generation can be disable separate if you want to keep the block for legacy purposes.")) {
            ore = contentRegistry.newBlock("VoltzEngineStoneOre", new BlockOre("stone"), ItemBlockOre.class);
            ore.func_149711_c(1.5f).func_149752_b(10.0f).func_149672_a(Block.field_149769_e);
            MetallicOres.registerSet(ore, this.getConfig());
        }
        if ((this.getConfig().hasKey("Content", "LoadGemOres") || gemOresRequested) && this.getConfig().getBoolean("LoadGemOres", "Content", gemOresRequested, "Loads up Gem Ores.")) {
            gemOre = contentRegistry.newBlock("VoltzEngineGemOre", new BlockGemOre("stone"), ItemBlockGemOre.class);
            GemOres.registerSet(gemOre, this.getConfig());
        }
        for (GemTypes types : GemTypes.values()) {
            if (!types.isRequested()) continue;
            types.item = new ItemGem(types);
            contentRegistry.newItem("Gem" + LanguageUtility.capitalizeFirst(types.name) + "Item", types.item);
            for (Gems gem : Gems.values()) {
                if (gem == Gems.UNKNOWN) continue;
                OreDictionary.registerOre((String)(types.oreDict + gem.getOreName()), (ItemStack)types.stack(gem));
            }
        }
        if (multiBlockRequested) {
            multiBlock = new BlockMultiblock();
            GameRegistry.registerBlock((Block)multiBlock, ItemBlockMulti.class, (String)"veMultiBlock");
            NEIProxy.hideItem(multiBlock);
            EnumMultiblock.register();
        }
        boolean forceLoadSheetMetal = (sheetMetalRequested || this.getConfig().hasKey("SheetMetalContent", "ForceLoad")) && this.getConfig().getBoolean("ForceLoad", "SheetMetalContent", true, "Forces the sheet metal items to load even if not requests. Content can still loaded if false as long as another mod requests the content for crafting. This config is designed to prevent items from vanishing in saves.");
        boolean forceLoadSimpleTools = (simpleToolsRequested || this.getConfig().hasKey("SimpleToolsContent", "ForceLoad")) && this.getConfig().getBoolean("ForceLoad", "SimpleToolsContent", true, "Forces the simple tools items to load even if not requests. Content can still loaded if false as long as another mod requests the content for crafting. This config is designed to prevent items from vanishing in saves.");
        boolean forceLoadCircuits = (circuitsRequested || this.getConfig().hasKey("Content", "LoadCircuits")) && this.getConfig().getBoolean("LoadCircuits", "Content", true, "Forces the circuit items to load even if not requests. Content can still loaded if false as long as another mod requests the content for crafting. This config is designed to prevent items from vanishing in saves.");
        boolean bl = forceLoadCraftingParts = (craftingPartsRequested || this.getConfig().hasKey("Content", "LoadCraftingParts")) && this.getConfig().getBoolean("LoadCraftingParts", "Content", true, "Forces the crafting items(Motors, coils, simple electrical parts) to load even if not requests. Content can still loaded if false as long as another mod requests the content for crafting. This config is designed to prevent items from vanishing in saves.");
        if (sheetMetalRequested || forceLoadSheetMetal) {
            itemSheetMetalTools = this.getManager().newItem("veSheetMetalTools", ItemSheetMetalTools.class, new Object[0]);
            itemSheetMetal = this.getManager().newItem("veSheetMetal", ItemSheetMetal.class, new Object[0]);
        }
        if (circuitsRequested || forceLoadCircuits) {
            itemCircuits = this.getManager().newItem("veCircuits", ItemCircuits.class, new Object[0]);
        }
        if (craftingPartsRequested || forceLoadCraftingParts) {
            itemCraftingParts = this.getManager().newItem("veCraftingParts", ItemCraftingParts.class, new Object[0]);
        }
        if (simpleToolsRequested || forceLoadSimpleTools) {
            itemSimpleCraftingTools = this.getManager().newItem("veSimpleTools", ItemSimpleCraftingTool.class, new Object[0]);
        }
        if (this.getConfig().getBoolean("LoadHeatedRocks", "Content", heatedRockRequested, "Loads up heated rocks which are used to give explosions an extra short term effect on stone.")) {
            heatedStone = contentRegistry.newBlock("VEHeatedRock", BlockHeatedStone.class, (Class<? extends ItemBlock>)ItemBlockMetadata.class);
            NEIProxy.hideItem(heatedStone);
            if (enabledHeatMap) {
                HeatedBlockRegistry.addNewHeatingConversion(Blocks.field_150348_b, new PlacementData(heatedStone, 15), 600);
                HeatedBlockRegistry.addNewHeatingConversion(heatedStone, Blocks.field_150353_l, 1200);
            }
        }
        logger.info("Starting resource generator");
        long start = System.nanoTime();
        for (DefinedGenItems genItem : DefinedGenItems.values()) {
            if ((!this.getConfig().hasKey("ForceLoadContent", genItem.name) && !genItem.isRequested() || !this.getConfig().getBoolean(genItem.name, "ForceLoadContent", genItem.isRequested(), "Forces the items to load even if not requests. Content can still loaded if false as long as another mod requests the content for crafting. This config is designed to prevent items from vanishing in saves.")) && !genItem.isRequested()) continue;
            logger.info("\tGenerating " + genItem.name);
            genItem.item = this.getManager().newItem("ve" + LanguageUtility.capitalizeFirst(genItem.name), new ItemGenMaterial(genItem));
            for (GenMaterial mat : GenMaterial.values()) {
                if (mat == GenMaterial.UNKNOWN || genItem.ignoreMaterials.contains((Object)mat)) {
                    NEIProxy.hideItem(new ItemStack(genItem.item, 1, mat.ordinal()));
                    continue;
                }
                OreDictionary.registerOre((String)(genItem.oreDict + LanguageUtility.capitalizeFirst(mat.name().toLowerCase())), (ItemStack)genItem.stack(mat));
            }
            if (genItem != DefinedGenItems.INGOT || !this.getConfig().getBoolean("EnableCheapSteelRecipe", "Content", true, "Enables iron ingot to steel ingot smelting recipe. Only disable if another recipe for steel exists or most items will be uncraftable.")) continue;
            GameRegistry.addSmelting((Item)Items.field_151042_j, (ItemStack)genItem.stack(GenMaterial.STEEL), (float)0.0f);
        }
        if (metallicOresRequested) {
            OreDictionary.registerOre((String)"oreBauxite", (ItemStack)MetallicOres.BAUXITE.stack());
            OreDictionary.registerOre((String)"oreMagnesite", (ItemStack)MetallicOres.MAGNESITE.stack());
        }
        logger.info("Done... Took " + StringHelpers.formatTimeDifference((long)start, (long)System.nanoTime()));
        this.loader.init();
        this.getManager().fireInit();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        if (enabledHeatMap) {
            HeatedBlockRegistry.init(heatDataConfig);
        }
        this.loader.postInit();
        this.getManager().firePostInit();
        if (metallicOresRequested) {
            for (MetallicOres ore : MetallicOres.values()) {
                ArrayList ingots = OreDictionary.getOres((String)ore.getOreName().replace("ore", "ingot"));
                if (ingots.isEmpty()) continue;
                ItemStack ingotStack = (ItemStack)ingots.get(0);
                if (ingotStack == null) {
                    int i = 1;
                    while (ingotStack == null && i < ingots.size()) {
                        ingotStack = (ItemStack)ingots.get(i);
                    }
                }
                if (ingotStack == null) continue;
                GameRegistry.addSmelting((ItemStack)ore.stack(), (ItemStack)ingotStack, (float)0.01f);
            }
        }
        actionProcessorThreads = this.getConfig().getInt("WorldActionThreads", "Multi-Threading", Runtime.getRuntime().availableProcessors() - 1, 0, 100, "Creates the number of threads to be used for processing changes to the world. Used by mods like ICBM to calculate explosives before removing blocks from the world. Try to keep this one less than the number of processors you have. This way minecraft is not chocked out for CPU time.");
        heatDataConfig.save();
        explosiveConfig.save();
        this.getConfig().save();
    }

    @Mod.EventHandler
    public void loadCompleteEvent(FMLLoadCompleteEvent event) {
        JsonContentLoader.INSTANCE.clear();
    }

    public AbstractProxy getProxy() {
        return proxy;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public ModManager getManager() {
        return this.manager;
    }

    public static Logger logger() {
        return logger;
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        if (!CommandVE.disableCommands) {
            ICommandManager commandManager = FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D();
            ServerCommandManager serverCommandManager = (ServerCommandManager)commandManager;
            serverCommandManager.func_71560_a((ICommand)CommandVE.INSTANCE);
        }
        for (int i = 0; i < actionProcessorThreads; ++i) {
            WorkerThread thread = new WorkerThread("" + i);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        ConcurrentHashMap<String, IWorkerThread> concurrentHashMap = VoltzEngineAPI.WORKER_THREADS;
        synchronized (concurrentHashMap) {
            for (IWorkerThread thread : VoltzEngineAPI.WORKER_THREADS.values()) {
                Engine.logger().info("Killing thread " + thread);
                thread.kill();
            }
        }
    }

    public static boolean isPlayerOpped(EntityPlayer player) {
        return player instanceof EntityPlayerMP && Engine.isPlayerOpped((EntityPlayerMP)player);
    }

    public static boolean isPlayerOpped(EntityPlayerMP player) {
        return player.field_71133_b.func_71203_ab().func_152596_g(player.func_146103_bH()) && player.field_71133_b.func_71203_ab().func_152603_m().func_152683_b((Object)player.func_146103_bH()) != null;
    }

    public static void error(String msg, Throwable error) throws Throwable {
        if (instance == null) {
            throw error;
        }
        Engine.logger().error(msg, error);
    }

    public static void error(String msg) {
        if (instance == null) {
            throw new RuntimeException(msg);
        }
        Engine.logger().error(msg);
    }

    public static boolean isJUnitTest() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        List<StackTraceElement> list = Arrays.asList(stackTrace);
        for (StackTraceElement element : list) {
            if (!element.getClassName().startsWith("org.junit.")) continue;
            return true;
        }
        return false;
    }

    static {
        logger = LogManager.getLogger((String)"VoltzEngine");
        ore = null;
        gemOre = null;
        metallicOresRequested = false;
        gemOresRequested = false;
        sheetMetalRequested = false;
        multiBlockRequested = false;
        craftingPartsRequested = false;
        heatedRockRequested = false;
        simpleToolsRequested = false;
        circuitsRequested = false;
        actionProcessorThreads = 3;
        enabledHeatMap = true;
        log_registering_explosives = false;
        INGOT_VOLUME = 144;
        TO_RF_RATIO = 500.0;
        TO_BC_RATIO = 50.0;
        requestedContent = new ArrayList<String>();
        requestedBlocks = new HashMap();
        requestedItems = new HashMap();
    }
}

