/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.asm.template;

import com.builtbroken.mc.api.InjectTemplate;
import com.builtbroken.mc.core.EngineCoreMod;
import com.builtbroken.mc.core.asm.template.ITemplateCalls;
import com.builtbroken.mc.core.asm.template.InjectionTemplate;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TemplateManager {
    public static final HashMap<String, InjectionTemplate> templates = new HashMap();
    public static final HashMap<String, ITemplateCalls> additionalTemplateCalls = new HashMap();
    public static final HashMap<Class, List<ITemplateCalls>> classToTemplateCalls = new HashMap();

    public static void load() {
        EngineCoreMod.logger.info("TemplateManager: loading ASM templates...");
        try {
            if (TemplateManager.classExists("cofh.api.energy.IEnergyHandler")) {
                templates.put("RF-IEnergyHandler", new InjectionTemplate("com.builtbroken.mc.lib.mod.compat.rf.TemplateTETile", Collections.singletonList("cofh.api.energy.IEnergyHandler")));
            } else {
                EngineCoreMod.logger.error("TemplateManager: Skipping RF support - class not found");
            }
            if (TemplateManager.classExists("ic2.api.energy.tile.IEnergySink")) {
                templates.put("IC-IEnergySink", new InjectionTemplate("com.builtbroken.mc.lib.mod.compat.ic.ICTemplateTile", Collections.singletonList("ic2.api.energy.tile.IEnergySink")));
            } else {
                EngineCoreMod.logger.error("TemplateManager: Skipping IC2 support - class not found");
            }
        }
        catch (Exception e) {
            EngineCoreMod.logger.error("TemplateManager: Failed to load templates, ASM injection may fail or even crash", (Throwable)e);
        }
        EngineCoreMod.logger.info("TemplateManager: Finished loading...");
    }

    private static boolean classExists(String clazz) {
        try {
            if (Class.forName(clazz) != null) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static void checkLoad(Object object) {
        Class<?> c = object.getClass();
        if (!classToTemplateCalls.containsKey(c) || classToTemplateCalls.get(c) == null) {
            String string;
            ArrayList<ITemplateCalls> list = new ArrayList<ITemplateCalls>();
            InjectTemplate annotation = TemplateManager.getAnnotation(c);
            if (annotation != null && (string = annotation.integration()) != null) {
                String[] split;
                String[] stringArray;
                if (string.contains(";")) {
                    stringArray = string.split(";");
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = string;
                }
                for (String template : split = stringArray) {
                    if (!additionalTemplateCalls.containsKey(template) || additionalTemplateCalls.get(template) == null) continue;
                    list.add(additionalTemplateCalls.get(template));
                }
            }
            classToTemplateCalls.put(c, list);
        }
    }

    private static InjectTemplate getAnnotation(Class c) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = c.getAnnotations()) {
            if (!(annotation instanceof InjectTemplate)) continue;
            return (InjectTemplate)annotation;
        }
        return null;
    }
}

