/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.commands.debug;

import com.builtbroken.mc.prefab.commands.SubCommand;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import com.builtbroken.mc.prefab.tile.BlockTile;
import cpw.mods.fml.common.Loader;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class CommandDebugRecipes
extends SubCommand {
    public CommandDebugRecipes() {
        super("recipe");
    }

    @Override
    public boolean handleEntityPlayerCommand(EntityPlayer player, String[] args) {
        return this.handleConsoleCommand((ICommandSender)player, args);
    }

    @Override
    public boolean handleConsoleCommand(ICommandSender sender, String[] args) {
        if (args != null && args.length > 0 && !"help".equalsIgnoreCase(args[0])) {
            String modID = args[0];
            if (Loader.isModLoaded((String)modID)) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("Checking data...."));
                List<Item> items = InventoryUtility.getItemsForMod(modID);
                if (items != null && !items.isEmpty()) {
                    HashMap<Item, List<IRecipe>> itemToRecipes = new HashMap<Item, List<IRecipe>>();
                    sender.func_145747_a((IChatComponent)new ChatComponentText("Found " + items.size() + " items for the mod " + modID + " moving on to processing recipes"));
                    for (Item item : items) {
                        List<IRecipe> recipes = InventoryUtility.getRecipesWithOutput(item);
                        if (recipes == null || recipes.size() <= 0) continue;
                        itemToRecipes.put(item, recipes);
                    }
                    sender.func_145747_a((IChatComponent)new ChatComponentText("Mapped " + itemToRecipes.size() + " entries with recipes"));
                    if (args.length == 1 || args[1].equalsIgnoreCase("conflict")) {
                        sender.func_145747_a((IChatComponent)new ChatComponentText("Not implemented yet"));
                        return true;
                    }
                    if (args[1].equalsIgnoreCase("missing")) {
                        for (Item item : items) {
                            if (itemToRecipes.containsKey(item)) continue;
                            if (item instanceof ItemBlock) {
                                Block block = ((ItemBlock)item).field_150939_a;
                                if (block instanceof BlockTile) {
                                    sender.func_145747_a((IChatComponent)new ChatComponentText("Tile[" + ((BlockTile)block).staticTile.name + "] has no recipes for any subtype"));
                                    continue;
                                }
                                sender.func_145747_a((IChatComponent)new ChatComponentText("Block[" + block.func_149732_F() + "] has no recipes for any subtype"));
                                continue;
                            }
                            sender.func_145747_a((IChatComponent)new ChatComponentText("Item[" + item.func_77653_i(new ItemStack(item)) + "] has no recipes for any subtype"));
                        }
                    }
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("No items are mapped for the mod[" + modID + "]"));
                }
                return true;
            }
            sender.func_145747_a((IChatComponent)new ChatComponentText("Failed to find mod[" + modID + "]"));
            return true;
        }
        return this.handleHelp(sender, args);
    }

    @Override
    public void getHelpOutput(ICommandSender sender, List<String> items) {
        items.add("<modId> <missing/conflict>");
    }
}

