/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.commands.permissions.sub;

import com.builtbroken.mc.core.commands.permissions.GroupProfileHandler;
import com.builtbroken.mc.lib.access.AccessGroup;
import com.builtbroken.mc.lib.access.AccessUser;
import com.builtbroken.mc.prefab.commands.SubCommand;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class CommandRemoveGroup
extends SubCommand {
    public CommandRemoveGroup() {
        super("group");
    }

    @Override
    public boolean handleEntityPlayerCommand(EntityPlayer player, String[] args) {
        return this.handleConsoleCommand((ICommandSender)player, args);
    }

    @Override
    public boolean handleConsoleCommand(ICommandSender sender, String[] args) {
        if (args.length > 0) {
            String name = args[0];
            if (GroupProfileHandler.GLOBAL.getAccessProfile().getGroup(name) != null) {
                AccessGroup group = new AccessGroup(name, new AccessUser[0]);
                if (GroupProfileHandler.GLOBAL.getAccessProfile().removeGroup(group) != null) {
                    if (group.getExtendGroup() != null) {
                        int i = 0;
                        for (AccessGroup g : GroupProfileHandler.GLOBAL.getAccessProfile().getGroups()) {
                            if (!g.getExtendGroup().getName().equalsIgnoreCase(group.getName())) continue;
                            ++i;
                            g.setToExtend(group.getExtendGroup());
                        }
                        sender.func_145747_a((IChatComponent)new ChatComponentText(i + " groups updated"));
                    }
                    sender.func_145747_a((IChatComponent)new ChatComponentText("Group '" + name + "' removed"));
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("Error removing group"));
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText("Group '" + name + "' not found"));
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Missing group name"));
        }
        return true;
    }

    @Override
    public boolean isHelpCommand(String[] args) {
        return args != null && args.length > 0 && (args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("?"));
    }

    @Override
    public void getHelpOutput(ICommandSender sender, List<String> items) {
        items.add("[name]");
    }
}

