/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.content.resources.load;

import com.builtbroken.mc.api.recipe.MachineRecipeType;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.prefab.recipe.cast.CastingRecipe;
import com.builtbroken.mc.prefab.recipe.cast.MRHandlerCast;
import com.builtbroken.mc.prefab.recipe.extend.MachineRecipeLoader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class CastRecipeLoader
extends MachineRecipeLoader<CastingRecipe> {
    public CastRecipeLoader() {
        super(MachineRecipeType.FLUID_CAST.INTERNAL_NAME);
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
        super.init();
    }

    @Override
    protected void generateRecipes(List<CastingRecipe> recipes) {
        for (String oreName : OreDictionary.getOreNames()) {
            Fluid fluid;
            String fluidName;
            block13: {
                ArrayList ores;
                block12: {
                    block9: {
                        block11: {
                            block10: {
                                if (!oreName.contains("ingot")) break block9;
                                ores = OreDictionary.getOres((String)oreName);
                                if (ores == null) break block10;
                                if (ores.size() != 0) break block11;
                            }
                            Engine.instance.logger().error("[CastRecipeLoader]Attempted to create a recipe with an oreName[" + oreName + "] without an ItemStack.  Ores: " + ores);
                            continue;
                        }
                        fluidName = oreName.replace("ingot", "").toLowerCase();
                        fluid = FluidRegistry.getFluid((String)fluidName);
                        if (fluid != null) {
                            recipes.add(this.newRecipe("ingot", fluid, (ItemStack)OreDictionary.getOres((String)oreName).get(0)));
                        }
                        if ((fluid = FluidRegistry.getFluid((String)(fluidName + ".molten"))) == null) continue;
                        recipes.add(this.newRecipe("ingot", fluid, (ItemStack)OreDictionary.getOres((String)oreName).get(0)));
                        continue;
                    }
                    if (!oreName.contains("nugget")) continue;
                    ores = OreDictionary.getOres((String)oreName);
                    if (ores == null) break block12;
                    if (ores.size() != 0) break block13;
                }
                Engine.instance.logger().error("[CastRecipeLoader]Attempted to create a recipe with an oreName[" + oreName + "] without an ItemStack.  Ores: " + ores);
                continue;
            }
            fluidName = oreName.replace("nugget", "").toLowerCase();
            fluid = FluidRegistry.getFluid((String)fluidName);
            if (fluid != null) {
                recipes.add(this.newRecipe("nugget", fluid, (ItemStack)OreDictionary.getOres((String)oreName).get(0)));
            }
            if ((fluid = FluidRegistry.getFluid((String)(fluidName + ".molten"))) == null) continue;
            recipes.add(this.newRecipe("nugget", fluid, (ItemStack)OreDictionary.getOres((String)oreName).get(0)));
        }
    }

    public CastingRecipe newRecipe(String type, Fluid fluid, ItemStack output) {
        CastingRecipe recipe = new CastingRecipe(type, output);
        recipe.getValidInputs().add(new FluidStack(fluid, MRHandlerCast.INSTANCE.getVolumeForCast(type)));
        return recipe;
    }
}

