/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.handler;

import com.builtbroken.mc.api.ISave;
import com.builtbroken.mc.api.IVirtualObject;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.References;
import com.builtbroken.mc.lib.helper.NBTUtility;
import com.builtbroken.mc.lib.helper.ReflectionUtility;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.LinkedHashSet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.logging.log4j.Level;

public class SaveManager {
    private static SaveManager instance;
    private HashMap<String, Class<?>> idToClassMap = new HashMap();
    private HashMap<Class<?>, String> classToIDMap = new HashMap();
    private LinkedHashSet<IVirtualObject> saveList = new LinkedHashSet();
    private LinkedHashSet<IVirtualObject> objects = new LinkedHashSet();
    private long lastSaveMills = 0L;

    public static SaveManager instance() {
        if (instance == null) {
            instance = new SaveManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markNeedsSaved(IVirtualObject object) {
        SaveManager saveManager = SaveManager.instance();
        synchronized (saveManager) {
            if (!SaveManager.instance().saveList.contains(object)) {
                SaveManager.instance().saveList.add(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(IVirtualObject object) {
        SaveManager saveManager = SaveManager.instance();
        synchronized (saveManager) {
            if (!SaveManager.instance().objects.contains(object)) {
                SaveManager.instance().saveList.add(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(IVirtualObject obj) {
        SaveManager saveManager = SaveManager.instance();
        synchronized (saveManager) {
            if (SaveManager.instance().objects.contains(obj)) {
                SaveManager.instance().objects.remove(obj);
                SaveManager.instance().saveList.remove(obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClass(String id, Class<?> clazz) {
        SaveManager saveManager = SaveManager.instance();
        synchronized (saveManager) {
            if (id != null && clazz != null) {
                if (SaveManager.instance().idToClassMap.containsKey(id) && SaveManager.instance().idToClassMap.get(id) != null) {
                    System.out.println("[CoreMachine]SaveManager: Something attempted to register a class with the id of another class");
                    System.out.println("[CoreMachine]SaveManager: Id:" + id + "  Class:" + clazz.getName());
                    System.out.println("[CoreMachine]SaveManager: OtherClass:" + SaveManager.instance().idToClassMap.get(id).getName());
                } else {
                    SaveManager.instance().idToClassMap.put(id, clazz);
                    SaveManager.instance().classToIDMap.put(clazz, id);
                }
            }
        }
    }

    public static Object createAndLoad(File file, Object ... args) {
        if (file.exists()) {
            Object obj = SaveManager.createAndLoad(NBTUtility.loadData(file), args);
            if (obj instanceof IVirtualObject) {
                ((IVirtualObject)obj).setSaveFile(file);
            }
            return obj;
        }
        return null;
    }

    public static Object createAndLoad(NBTTagCompound nbt, Object ... args) {
        block12: {
            Object obj = null;
            try {
                if (nbt == null || !nbt.func_74764_b("id")) break block12;
                try {
                    Class clazz = SaveManager.getClass(nbt.func_74779_i("id"));
                    if (clazz != null) {
                        if (args == null || args.length == 0) {
                            Constructor con = ReflectionUtility.getConstructorWithArgs(clazz, args);
                            if (con != null) {
                                obj = con.newInstance(args);
                            }
                        } else {
                            obj = clazz.newInstance();
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (obj instanceof ISave) {
                    try {
                        ((ISave)obj).load(nbt);
                    }
                    catch (Exception e) {
                        Engine.instance.logger().catching(Level.FATAL, (Throwable)e);
                        Engine.instance.logger().fatal("SaveManager: An object %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", new Object[]{nbt.func_74779_i("id"), obj.getClass().getName()});
                        obj = null;
                    }
                } else {
                    References.LOGGER.warn("SaveManager: Skipping object with id " + nbt.func_74779_i("id"));
                }
                return obj;
            }
            catch (Exception e) {
                FMLLog.severe((String)"[Voltz Engine]SaveManager: Error trying to load object from save", (Object[])new Object[0]);
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void saveAll() {
        for (IVirtualObject ref : SaveManager.instance().objects) {
            SaveManager.saveObject(ref);
        }
        for (IVirtualObject ref : SaveManager.instance().saveList) {
            SaveManager.saveObject(ref);
        }
        SaveManager.instance().saveList.clear();
    }

    public static void saveObject(IVirtualObject object) {
        block5: {
            try {
                if (FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER) break block5;
                if (object != null) {
                    if (SaveManager.getID(object.getClass()) != null) {
                        if (object.getSaveFile() != null) {
                            File file = object.getSaveFile();
                            file.mkdirs();
                            NBTTagCompound tag = new NBTTagCompound();
                            object.save(tag);
                            tag.func_74778_a("id", SaveManager.getID(object.getClass()));
                            NBTUtility.saveData(file, tag);
                            break block5;
                        }
                        throw new NullPointerException("SaveManager: Object save file path is null. " + object);
                    }
                    throw new Exception("SaveManager: Object does not have a save ID. " + object);
                }
                throw new NullPointerException("SaveManager: Attempted to save a null object");
            }
            catch (Exception e) {
                FMLLog.fine((String)("[Resonant Engine]SaveManager: Error trying to save object class: " + (object != null ? object.getClass() : "null")), (Object[])new Object[0]);
                e.printStackTrace();
            }
        }
    }

    public static String getID(Class clazz) {
        return SaveManager.instance().classToIDMap.get(clazz);
    }

    public static Class getClass(String id) {
        return SaveManager.instance().idToClassMap.get(id);
    }

    @SubscribeEvent
    public void worldSave(WorldEvent.Save evt) {
        for (IVirtualObject ref : SaveManager.instance().objects) {
            if (!ref.shouldSaveForWorld(evt.world)) continue;
            SaveManager.saveObject(ref);
        }
        for (IVirtualObject ref : SaveManager.instance.saveList) {
            if (!ref.shouldSaveForWorld(evt.world)) continue;
            SaveManager.saveObject(ref);
        }
    }
}

