/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.handler;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.packet.PacketSelectionData;
import com.builtbroken.mc.lib.modflags.Region;
import com.builtbroken.mc.lib.modflags.RegionManager;
import com.builtbroken.mc.lib.transform.region.Cube;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.lib.world.edit.Selection;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class SelectionHandler {
    public static final SelectionHandler INSTANCE = new SelectionHandler();
    private static final HashMap<String, Selection> selections = Maps.newHashMap();

    private SelectionHandler() {
    }

    public static Selection getSelection(EntityPlayer player) {
        Selection out = selections.get(player.func_70005_c_());
        if (out == null) {
            out = new Selection();
            selections.put(player.func_70005_c_(), out);
        }
        return out;
    }

    public static void setSelection(EntityPlayer player, Selection cuboid) {
        selections.put(player.func_70005_c_(), cuboid);
        if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
            SelectionHandler.updatePlayerRenderData((EntityPlayerMP)player);
        }
    }

    private void clearSelection(EntityPlayer player) {
        Selection select = selections.get(player);
        if (select != null) {
            select.set(null, null);
        }
    }

    public static void updatePlayerRenderData(EntityPlayerMP player) {
        ArrayList<Cube> cubes = new ArrayList<Cube>();
        ArrayList<Cube> regions = new ArrayList<Cube>();
        Selection selection = SelectionHandler.getSelection((EntityPlayer)player);
        for (Cube cube : selections.values()) {
            if (cube == selection) continue;
            Pos pos = new Pos((Entity)player);
            if (!(cube.distance(pos) <= 160.0)) continue;
            cubes.add(cube);
        }
        for (Region region : RegionManager.getControllerForWorld(player.field_70170_p).getRegionsNear(player, 160)) {
            for (Cube cube : region.segments) {
                if (!cube.isCloseToAnyCorner(new Pos((Entity)player), 160)) continue;
                regions.add(cube);
            }
        }
        Engine.instance.packetHandler.sendToPlayer(new PacketSelectionData(selection, cubes, regions), player);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        this.clearSelection(event.player);
        if (event.player instanceof EntityPlayerMP) {
            SelectionHandler.updatePlayerRenderData((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.clearSelection(event.player);
        if (event.player instanceof EntityPlayerMP) {
            SelectionHandler.updatePlayerRenderData((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K && event.phase == TickEvent.Phase.END && event.world.func_72912_H().func_76073_f() % 20L == 0L) {
            for (Object obj : event.world.field_73010_i) {
                if (!(obj instanceof EntityPlayerMP)) continue;
                SelectionHandler.updatePlayerRenderData((EntityPlayerMP)obj);
            }
        }
    }
}

