/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.network.packet;

import com.builtbroken.mc.core.network.packet.PacketType;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class PacketBiomeData
extends PacketType {
    int chunkX;
    int chunkZ;
    byte[] biomes;

    public PacketBiomeData() {
    }

    public PacketBiomeData(Chunk chunk) {
        this.chunkX = chunk.field_76635_g;
        this.chunkZ = chunk.field_76647_h;
        this.biomes = chunk.func_76605_m();
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.chunkX);
        buffer.writeInt(this.chunkZ);
        for (byte b : this.biomes) {
            buffer.writeByte((int)b);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.chunkX = buffer.readInt();
        this.chunkZ = buffer.readInt();
        this.biomes = new byte[256];
        for (int i = 0; i < 256; ++i) {
            byte b = buffer.readByte();
            if (b < 0 || b >= 256 || BiomeGenBase.func_150568_d((int)b) == null) continue;
            this.biomes[i] = b;
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        Chunk chunk = player.func_130014_f_().func_72964_e(this.chunkX, this.chunkZ);
        if (chunk != null) {
            chunk.func_76616_a(this.biomes);
        }
    }
}

