/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.network.packet;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.core.References;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.lib.render.fx.FxBeam;
import com.builtbroken.mc.lib.transform.vector.Pos;
import cpw.mods.fml.client.FMLClientHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;

public class PacketSpawnStream
extends PacketType {
    public int dim;
    public int type;
    public double x;
    public double y;
    public double z;
    public double vx;
    public double vy;
    public double vz;
    public float red;
    public float green;
    public float blue;

    public PacketSpawnStream() {
    }

    public PacketSpawnStream(int dim, IPos3D pos, IPos3D pos2, int type) {
        this(dim, pos.x(), pos.y(), pos.z(), pos2.x(), pos2.y(), pos2.z(), type);
    }

    public PacketSpawnStream(int dim, double x, double y, double z, double vx, double vy, double vz, int type) {
        this.dim = dim;
        this.x = x;
        this.y = y;
        this.z = z;
        this.vx = vx;
        this.vy = vy;
        this.vz = vz;
        this.type = type;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.dim);
        buffer.writeInt(this.type);
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        buffer.writeDouble(this.vx);
        buffer.writeDouble(this.vy);
        buffer.writeDouble(this.vz);
        if (this.type == 2) {
            buffer.writeFloat(this.red);
            buffer.writeFloat(this.green);
            buffer.writeFloat(this.blue);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.dim = buffer.readInt();
        this.type = buffer.readInt();
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.vx = buffer.readDouble();
        this.vy = buffer.readDouble();
        this.vz = buffer.readDouble();
        if (this.type == 2) {
            this.red = buffer.readFloat();
            this.green = buffer.readFloat();
            this.blue = buffer.readFloat();
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        if (player.field_70170_p.field_73011_w.field_76574_g == this.dim) {
            if (this.type == 0) {
                int short1 = 128;
                Random rand = player.field_70170_p.field_73012_v;
                for (int l = 0; l < short1; ++l) {
                    double d6 = (double)l / ((double)short1 - 1.0);
                    float f = (rand.nextFloat() - 0.5f) * 0.2f;
                    float f1 = (rand.nextFloat() - 0.5f) * 0.2f;
                    float f2 = (rand.nextFloat() - 0.5f) * 0.2f;
                    double d7 = this.vx + (this.x - this.vx) * d6 + (rand.nextDouble() - 0.5) * 5.0;
                    double d8 = this.vy + (this.y - this.vy) * d6 + (rand.nextDouble() - 0.5) * 5.0;
                    double d9 = this.vz + (this.z - this.vz) * d6 + (rand.nextDouble() - 0.5) * 5.0;
                    player.field_70170_p.func_72869_a("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
                }
            } else if (this.type == 1) {
                FxBeam beam = new FxBeam(References.GREY_TEXTURE, player.field_70170_p, new Pos(this.x, this.y, this.z), new Pos(this.vx, this.vy, this.vz), Color.RED, 5);
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)beam);
            } else if (this.type == 2) {
                FxBeam beam = new FxBeam(References.GREY_TEXTURE, player.field_70170_p, new Pos(this.x, this.y, this.z), new Pos(this.vx, this.vy, this.vz), Color.RED, 5);
                beam.setRGB(this.red, this.green, this.blue);
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)beam);
            }
        }
    }
}

