/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.network.packet;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.IPacketReceiver;
import com.builtbroken.mc.core.network.ex.PacketIDException;
import com.builtbroken.mc.core.network.ex.PacketTileReadException;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.lib.transform.vector.Location;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketTile
extends PacketType {
    public int x;
    public int y;
    public int z;

    public PacketTile() {
    }

    public PacketTile(int x, int y, int z, Object ... args) {
        super(args);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public PacketTile(TileEntity tile, Object ... args) {
        this(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, args);
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeBytes(this.data());
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.data_$eq(buffer.slice());
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        this.handle(player);
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        this.handle(player);
    }

    public void handle(EntityPlayer player) {
        this.handle(player, player.func_130014_f_().func_147438_o(this.x, this.y, this.z));
    }

    public void handle(EntityPlayer player, TileEntity tile) {
        Location location = new Location(player.field_70170_p, this.x, this.y, this.z);
        this.sender_$eq(player);
        if (tile == null) {
            Engine.instance.logger().error((Object)new PacketTileReadException(location, "Null tile"));
        } else if (tile.func_145837_r()) {
            Engine.instance.logger().error((Object)new PacketTileReadException(location, "Invalidated tile"));
        } else if (tile instanceof IPacketIDReceiver) {
            if (((IPacketIDReceiver)tile).shouldReadPacket(player, location, this)) {
                try {
                    int id;
                    IPacketIDReceiver receiver = (IPacketIDReceiver)tile;
                    ByteBuf buf = this.data().slice();
                    try {
                        id = buf.readInt();
                    }
                    catch (IndexOutOfBoundsException ex) {
                        Engine.instance.logger().error((Object)new PacketIDException(location));
                        return;
                    }
                    receiver.read(buf, id, player, this);
                }
                catch (IndexOutOfBoundsException e) {
                    Engine.instance.logger().error((Object)new PacketTileReadException(location, "Packet was read past it's size."));
                    Engine.instance.logger().error("Error: ", (Throwable)e);
                }
                catch (NullPointerException e) {
                    Engine.instance.logger().error((Object)new PacketTileReadException(location, "Null pointer while reading data", e));
                    Engine.instance.logger().error("Error: ", (Throwable)e);
                }
                catch (Exception e) {
                    Engine.instance.logger().error((Object)new PacketTileReadException(location, "Failed to read packet", e));
                    Engine.instance.logger().error("Error: ", (Throwable)e);
                }
            } else {
                Engine.instance.logger().error("Error: " + tile + " rejected packet " + this + " due to invalid conditions.");
            }
        } else if (tile instanceof IPacketReceiver) {
            if (((IPacketReceiver)tile).shouldReadPacket(player, location, this)) {
                try {
                    IPacketReceiver receiver = (IPacketReceiver)tile;
                    receiver.read(this.data().slice(), player, this);
                }
                catch (IndexOutOfBoundsException e) {
                    Engine.instance.logger().error((Object)new PacketTileReadException(location, "Packet was read past it's size."));
                }
                catch (Exception e) {
                    Engine.instance.logger().error((Object)new PacketTileReadException(location, "Failed to read packet", e));
                    e.printStackTrace();
                }
            } else {
                Engine.instance.logger().error("Error: " + tile + " rejected packet " + this + " due to invalid conditions.");
            }
        } else {
            Engine.instance.logger().error((Object)new PacketTileReadException(location, "Unsupported action for " + tile));
        }
    }
}

