/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.access;

import com.builtbroken.mc.api.ISave;
import com.builtbroken.mc.lib.access.AccessGroup;
import com.builtbroken.mc.lib.access.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class AccessUser
implements ISave {
    protected String username;
    protected UUID userID;
    protected boolean isTempary = false;
    protected NBTTagCompound extraData;
    protected AccessGroup group;
    public List<String> nodes = new ArrayList<String>();

    protected AccessUser() {
    }

    @Deprecated
    public AccessUser(String username) {
        this.username = username;
    }

    public AccessUser(String username, UUID id) {
        this.username = username;
        this.userID = id;
    }

    public AccessUser(EntityPlayer player) {
        this(player.func_70005_c_(), player.func_146103_bH().getId());
    }

    public static AccessUser loadFromNBT(NBTTagCompound nbt) {
        AccessUser user = new AccessUser();
        user.load(nbt);
        return user;
    }

    public AccessGroup getGroup() {
        return this.group;
    }

    public AccessUser setGroup(AccessGroup group) {
        this.group = group;
        return this;
    }

    public boolean hasNode(Permission permission) {
        return this.hasNode(permission.toString());
    }

    public boolean hasNode(String node) {
        return this.hasExactNode(node) || this.hasNodeInUser(node) || this.getGroup() != null && this.getGroup().hasNode(node);
    }

    public boolean hasNodeInUser(String node) {
        String tempNode = node.replace(".*", "");
        for (String headNode : this.nodes) {
            if (!tempNode.contains(headNode)) continue;
            return true;
        }
        return false;
    }

    public boolean hasExactNode(String node) {
        return this.nodes.contains(node);
    }

    public boolean removeNode(Permission perm) {
        return this.removeNode(perm.toString());
    }

    public boolean addNode(Permission perm) {
        return this.addNode(perm.toString());
    }

    public boolean removeNode(String perm) {
        return this.nodes.remove(perm);
    }

    public boolean addNode(String perm) {
        if (!this.hasExactNode(perm)) {
            this.nodes.add(perm);
        }
        return false;
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        nbt.func_74778_a("username", this.username);
        nbt.func_74782_a("extraData", (NBTBase)this.userData());
        NBTTagList usersTag = new NBTTagList();
        for (String str : this.nodes) {
            NBTTagCompound accessData = new NBTTagCompound();
            accessData.func_74778_a("name", str);
            usersTag.func_74742_a((NBTBase)accessData);
        }
        nbt.func_74782_a("permissions", (NBTBase)usersTag);
        if (this.userID != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74772_a("l", this.userID.getLeastSignificantBits());
            tag.func_74772_a("m", this.userID.getMostSignificantBits());
            nbt.func_74782_a("UUID", (NBTBase)tag);
        }
        return nbt;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        this.username = nbt.func_74779_i("username");
        this.extraData = nbt.func_74775_l("extraData");
        NBTTagList userList = nbt.func_150295_c("permissions", 10);
        this.nodes.clear();
        for (int i = 0; i < userList.func_74745_c(); ++i) {
            this.nodes.add(userList.func_150305_b(i).func_74779_i("name"));
        }
        if (nbt.func_74764_b("UUID")) {
            NBTTagCompound tag = nbt.func_74775_l("UUID");
            long l = tag.func_74763_f("l");
            long m = tag.func_74763_f("m");
            this.userID = new UUID(m, l);
        }
    }

    public NBTTagCompound toNBT() {
        return this.save(new NBTTagCompound());
    }

    public AccessUser setTempary(boolean si) {
        this.isTempary = si;
        return this;
    }

    public NBTTagCompound userData() {
        if (this.extraData == null) {
            this.extraData = new NBTTagCompound();
        }
        return this.extraData;
    }

    public String getName() {
        return this.username;
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return ((String)obj).equalsIgnoreCase(this.getName());
        }
        return obj instanceof AccessUser && ((AccessUser)obj).getName().equalsIgnoreCase(this.getName());
    }

    public String toString() {
        return "[User:" + this.getName() + "]";
    }

    public AccessUser copyToNewUser(String username) {
        return this.copyData(new AccessUser(username));
    }

    public AccessUser copyToNewUser(EntityPlayer player) {
        return this.copyData(new AccessUser(player));
    }

    public AccessUser copyData(AccessUser user) {
        user.extraData = this.extraData;
        user.group = this.group;
        for (String node : this.nodes) {
            user.nodes.add(node);
        }
        return user;
    }
}

