/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.access;

import com.builtbroken.mc.lib.access.AccessProfile;
import com.builtbroken.mc.lib.access.AccessUtility;
import com.builtbroken.mc.lib.helper.NBTUtility;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;

public final class GlobalAccessSystem {
    private static final HashMap<String, AccessProfile> name_to_profiles = new HashMap();

    public static AccessProfile getOrCreateProfile(String name, boolean defaultGroups) {
        if (name_to_profiles.containsKey(name) && name_to_profiles.get(name) != null) {
            return name_to_profiles.get(name);
        }
        AccessProfile p = GlobalAccessSystem.loadProfile(name, false);
        if (p == null) {
            p = GlobalAccessSystem.createProfile(name, defaultGroups);
        }
        if (!name_to_profiles.containsKey(name) || name_to_profiles.get(name) == null) {
            name_to_profiles.put(name, p);
        }
        return p;
    }

    public static AccessProfile createProfile(String name, boolean defaultGroups) {
        AccessProfile profile = new AccessProfile();
        if (defaultGroups) {
            AccessUtility.loadNewGroupSet(profile);
        }
        profile.initName(name.trim(), "P_" + name + "_" + System.currentTimeMillis());
        if (!name_to_profiles.containsKey(name) || name_to_profiles.get(name) == null) {
            name_to_profiles.put(name, profile);
        }
        return profile;
    }

    protected static AccessProfile loadProfile(String name, boolean create) {
        NBTTagCompound tag = NBTUtility.loadData("bbm/accessProfiles/" + name + ".dat");
        if (!tag.func_82582_d()) {
            return new AccessProfile(tag, true);
        }
        if (create) {
            return GlobalAccessSystem.createProfile(name, true);
        }
        return null;
    }
}

