/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.json;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.References;
import com.builtbroken.mc.core.registry.implement.IPostInit;
import com.builtbroken.mc.core.registry.implement.IRecipeContainer;
import com.builtbroken.mc.core.registry.implement.IRegistryInit;
import com.builtbroken.mc.lib.json.block.processor.JsonBlockProcessor;
import com.builtbroken.mc.lib.json.block.processor.JsonBlockSmeltingProcessor;
import com.builtbroken.mc.lib.json.block.processor.JsonBlockWorldGenProcessor;
import com.builtbroken.mc.lib.json.imp.IJsonGenObject;
import com.builtbroken.mc.lib.json.processors.JsonProcessor;
import com.builtbroken.mc.lib.mod.loadable.AbstractLoadable;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public final class JsonContentLoader
extends AbstractLoadable {
    public static JsonContentLoader INSTANCE = new JsonContentLoader();
    public final List<String> classPathResources = new ArrayList<String>();
    public final List<File> externalFiles = new ArrayList<File>();
    public final List<File> externalJarFiles = new ArrayList<File>();
    public final List<String> extensionsToLoad = new ArrayList<String>();
    public final HashMap<String, JsonProcessor> processors = new HashMap();
    public final HashMap<String, List<JsonEntry>> jsonEntries = new HashMap();
    public final List<IJsonGenObject> generatedObjects = new ArrayList<IJsonGenObject>();
    public final JsonBlockProcessor blockProcessor;
    public boolean ignoreFileLoading = false;
    public File externalContentFolder;

    public JsonContentLoader() {
        this.extensionsToLoad.add("json");
        this.blockProcessor = new JsonBlockProcessor();
    }

    public void add(JsonProcessor processor) {
        this.processors.put(processor.getJsonKey(), processor);
    }

    @Override
    public void preInit() {
        this.externalContentFolder = new File(References.BBM_CONFIG_FOLDER, "json");
        this.validateFilePaths();
        this.processors.put("block", this.blockProcessor);
        this.blockProcessor.addSubProcessor("smeltingRecipe", new JsonBlockSmeltingProcessor());
        this.blockProcessor.addSubProcessor("worldGenerator", new JsonBlockWorldGenProcessor());
        if (!this.ignoreFileLoading) {
            this.loadResources();
        }
        this.processEntries();
    }

    @Override
    public void init() {
        this.processEntries();
    }

    public void process(String processorKey) {
        if (this.jsonEntries.containsKey(processorKey)) {
            List<JsonEntry> entries = this.jsonEntries.get(processorKey);
            if (entries != null) {
                Iterator<JsonEntry> it = entries.iterator();
                while (it.hasNext()) {
                    JsonEntry entry = it.next();
                    try {
                        if (!this.process(entry.jsonKey, entry.element)) continue;
                        it.remove();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to process entry from file " + entry.fileReadFrom + ". Make corrections to the file or contact the file's creator for the issue to be fixed.\n  Entry = " + entry, e);
                    }
                }
            }
            if (entries.size() <= 0) {
                this.jsonEntries.remove(processorKey);
            } else {
                this.jsonEntries.put(processorKey, entries);
            }
        }
    }

    protected void processEntries() {
        if (this.jsonEntries.size() > 0) {
            ArrayList<String> processorKeys = new ArrayList<String>();
            for (JsonProcessor processor : this.processors.values()) {
                String jsonKey = processor.getJsonKey();
                String loadOrder = processor.getLoadOrder();
                if (loadOrder != null && !loadOrder.isEmpty()) {
                    jsonKey = jsonKey + "@" + loadOrder;
                }
                processorKeys.add(jsonKey);
            }
            List<String> sortingProcessorList = JsonContentLoader.sortSortingValues(processorKeys);
            for (String processorKey : sortingProcessorList) {
                this.process(processorKey);
            }
        }
    }

    public void validateFilePaths() {
        if (!this.externalContentFolder.exists()) {
            this.externalContentFolder.mkdirs();
        }
    }

    public void loadResources() {
        this.loadResourcesFromFolder(this.externalContentFolder);
        this.loadResourcesFromPackage("content/");
        for (File file : this.externalFiles) {
            try {
                JsonContentLoader.loadJsonFile(file, this.jsonEntries);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load resource " + file, e);
            }
        }
        for (String resource : this.classPathResources) {
            try {
                JsonContentLoader.loadJsonFileFromResources(resource, this.jsonEntries);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load resource " + resource, e);
            }
        }
    }

    public static List<String> sortSortingValues(List<String> sortingValues) {
        Collections.sort(sortingValues, new StringSortingComparator());
        LinkedList<String> sortedValues = new LinkedList<String>();
        while (!sortingValues.isEmpty()) {
            JsonContentLoader.sortSortingValues(sortingValues, sortedValues);
            if (sortingValues.isEmpty()) continue;
            Iterator<String> it = sortingValues.iterator();
            while (it.hasNext()) {
                String entry = it.next();
                if (entry.contains("@")) {
                    String[] split = entry.split("@");
                    String name = entry.split("@")[0];
                    if (split[1].contains(":")) {
                        split = split[1].split(":");
                        boolean found = false;
                        for (String v : sortingValues) {
                            if (v.equals(entry) || !v.contains(split[1])) continue;
                            found = true;
                            break;
                        }
                        for (String v : sortedValues) {
                            if (v.equals(entry) || !v.contains(split[1])) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        Engine.logger().error("Bad sorting value for " + entry + " could not find category for " + split[1]);
                        sortedValues.add(name);
                        it.remove();
                        continue;
                    }
                    Engine.logger().error("Bad sorting value for " + entry + " has no valid sorting data");
                    sortedValues.add(name);
                    it.remove();
                    continue;
                }
                sortedValues.add(entry);
                it.remove();
            }
        }
        return sortedValues;
    }

    public static void sortSortingValues(List<String> sortingValues, List<String> sortedValues) {
        Iterator<String> it = sortingValues.iterator();
        while (it.hasNext()) {
            String entry = it.next();
            if (entry.contains("@")) {
                String[] split = entry.split("@");
                String name = split[0];
                String sortValue = split[1];
                if (sortValue.contains(":")) {
                    split = sortValue.split(":");
                    String prefix = split[0];
                    String cat = split[1];
                    boolean catFound = false;
                    ListIterator<String> sortedIt = sortedValues.listIterator();
                    while (sortedIt.hasNext()) {
                        String v = sortedIt.next();
                        if (!v.equalsIgnoreCase(cat)) continue;
                        catFound = true;
                        if (prefix.equalsIgnoreCase("after")) {
                            sortedIt.add(name);
                            break;
                        }
                        if (prefix.equalsIgnoreCase("before")) {
                            sortedIt.previous();
                            sortedIt.add(name);
                            break;
                        }
                        Engine.logger().error("Bad sorting value for " + entry + " we can only read 'after' and 'before'");
                        sortedValues.add(name);
                        it.remove();
                        break;
                    }
                    if (!catFound) continue;
                    it.remove();
                    continue;
                }
                sortedValues.add(name);
                it.remove();
                continue;
            }
            sortedValues.add(entry);
            it.remove();
        }
    }

    public boolean process(String key, JsonElement element) {
        JsonProcessor processor = this.processors.get(key);
        if (processor != null && processor.canProcess(key, element)) {
            Object data = processor.process(element);
            data.register();
            if (data instanceof IRegistryInit) {
                ((IRegistryInit)data).onRegistered();
            }
            return this.generatedObjects.add((IJsonGenObject)data);
        }
        return false;
    }

    public void loadResourcesFromFolder(File folder) {
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                this.loadResourcesFromFolder(folder);
                continue;
            }
            String extension = file.getName().substring(file.getName().lastIndexOf(".") + 1, file.getName().length());
            if (extension.equalsIgnoreCase("jar")) {
                this.externalJarFiles.add(file);
                continue;
            }
            if (!this.extensionsToLoad.contains(extension)) continue;
            this.externalFiles.add(file);
        }
    }

    public void loadResourcesFromPackage(String folder) {
        try {
            InputStream stream = JsonContentLoader.class.getClassLoader().getResourceAsStream(folder);
            if (stream != null) {
                List files = IOUtils.readLines((InputStream)stream, (Charset)Charsets.UTF_8);
                for (String name : files) {
                    String path = folder + (!folder.endsWith("/") ? "/" : "") + name;
                    if (name.lastIndexOf(".") > 1) {
                        String extension = name.substring(name.lastIndexOf(".") + 1, name.length());
                        if (!this.extensionsToLoad.contains(extension)) continue;
                        this.classPathResources.add(path);
                        continue;
                    }
                    this.loadResourcesFromPackage(path + "/");
                }
            }
        }
        catch (Exception e) {
            Engine.logger().error("Failed to load resources from class path.", (Throwable)e);
        }
    }

    public static void loadJsonFileFromResources(String resource, HashMap<String, List<JsonEntry>> entries) throws IOException {
        URL url;
        if (resource != null && !resource.isEmpty() && (url = JsonContentLoader.class.getClassLoader().getResource(resource)) != null) {
            InputStream stream = url.openStream();
            JsonContentLoader.loadJson(resource, new InputStreamReader(stream), entries);
            stream.close();
        }
    }

    public static void loadJsonFile(File file, HashMap<String, List<JsonEntry>> entries) throws IOException {
        if (file.exists() && file.isFile()) {
            FileReader stream = new FileReader(file);
            JsonContentLoader.loadJson(file.getName(), new BufferedReader(stream), entries);
            stream.close();
        }
    }

    public static void loadJson(String fileName, Reader reader, HashMap<String, List<JsonEntry>> entries) {
        JsonReader jsonReader = new JsonReader(reader);
        JsonElement element = Streams.parse((JsonReader)jsonReader);
        JsonContentLoader.loadJsonElement(fileName, element, entries);
    }

    public static void loadJsonElement(String file, JsonElement element, HashMap<String, List<JsonEntry>> entries) {
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            String author = null;
            String helpSite = null;
            if (object.has("author")) {
                JsonObject authorData = object.get("author").getAsJsonObject();
                author = authorData.get("name").getAsString();
                if (authorData.has("site")) {
                    helpSite = authorData.get("site").getAsString();
                }
            }
            for (Map.Entry entry : object.entrySet()) {
                if (((String)entry.getKey()).equalsIgnoreCase("author")) continue;
                String key = (String)entry.getKey();
                if (key.contains(":")) {
                    key = key.split(":")[0];
                }
                JsonEntry jsonEntry = new JsonEntry(key, file, (JsonElement)entry.getValue());
                jsonEntry.author = author;
                jsonEntry.authorHelpSite = helpSite;
                List<JsonEntry> list = entries.get(jsonEntry.jsonKey);
                if (list == null) {
                    list = new ArrayList<JsonEntry>();
                }
                list.add(jsonEntry);
                entries.put(jsonEntry.jsonKey, list);
            }
        }
    }

    @Override
    public void postInit() {
        this.processEntries();
        for (IJsonGenObject obj : this.generatedObjects) {
            if (obj instanceof IPostInit) {
                ((IPostInit)((Object)obj)).onPostInit();
            }
            if (!(obj instanceof IRecipeContainer)) continue;
            ArrayList<IRecipe> recipes = new ArrayList<IRecipe>();
            ((IRecipeContainer)((Object)obj)).genRecipes(recipes);
            for (IRecipe recipe : recipes) {
                if (recipe == null || recipe.func_77571_b() == null) continue;
                GameRegistry.addRecipe((IRecipe)recipe);
            }
        }
    }

    public static ItemStack fromString(String string) {
        if (string.startsWith("item[") || string.startsWith("block[")) {
            Object obj;
            String out = string.substring(string.indexOf("[") + 1, string.length() - 1);
            int meta = -1;
            if (out.contains("@")) {
                String[] split = out.split("@");
                out = split[0];
                try {
                    meta = Integer.parseInt(split[1]);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException();
                }
            }
            if (!out.contains(":")) {
                out = "minecraft:" + out;
            }
            if (string.startsWith("item[")) {
                obj = Item.field_150901_e.func_82594_a(out);
                if (obj instanceof Item) {
                    if (meta > -1) {
                        return new ItemStack((Item)obj);
                    }
                    return new ItemStack((Item)obj, 1, meta);
                }
            } else {
                obj = Block.field_149771_c.func_82594_a(out);
                if (obj instanceof Block) {
                    if (meta > -1) {
                        return new ItemStack((Block)obj);
                    }
                    return new ItemStack((Block)obj, 1, meta);
                }
            }
        } else if (OreDictionary.doesOreNameExist((String)string)) {
            ArrayList ores = OreDictionary.getOres((String)string);
            for (ItemStack stack : ores) {
                if (stack == null) continue;
                return stack;
            }
        }
        return null;
    }

    public static ItemStack fromJson(JsonObject json) {
        ItemStack output;
        block9: {
            Object obj;
            int meta;
            String item;
            String type;
            block8: {
                output = null;
                type = json.get("type").getAsString();
                item = json.get("item").getAsString();
                meta = -1;
                if (json.has("meta")) {
                    meta = json.get("meta").getAsInt();
                }
                if (!type.equalsIgnoreCase("block")) break block8;
                obj = Item.field_150901_e.func_82594_a(item);
                if (!(obj instanceof Block)) break block9;
                output = meta > -1 ? new ItemStack((Block)obj) : new ItemStack((Block)obj, 1, meta);
                break block9;
            }
            if (type.equalsIgnoreCase("item")) {
                obj = Item.field_150901_e.func_82594_a(item);
                if (obj instanceof Item) {
                    if (meta > -1) {
                        return new ItemStack((Item)obj);
                    }
                    return new ItemStack((Item)obj, 1, meta);
                }
            } else if (type.equalsIgnoreCase("dict")) {
                ArrayList ores = OreDictionary.getOres((String)item);
                for (ItemStack stack : ores) {
                    if (stack == null) continue;
                    output = stack;
                    break;
                }
            }
        }
        if (output != null && json.has("nbt")) {
            NBTTagCompound tag = new NBTTagCompound();
            JsonContentLoader.processNBTTagCompound(json.getAsJsonObject("nbt"), tag);
        }
        return output;
    }

    public static void processNBTTagCompound(JsonObject json, NBTTagCompound tag) {
        for (Map.Entry entry : json.entrySet()) {
            if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                JsonPrimitive primitive = ((JsonElement)entry.getValue()).getAsJsonPrimitive();
                if (primitive.isBoolean()) {
                    tag.func_74757_a((String)entry.getKey(), primitive.getAsBoolean());
                    continue;
                }
                if (primitive.isNumber()) {
                    tag.func_74768_a((String)entry.getKey(), primitive.getAsInt());
                    continue;
                }
                if (!primitive.isString()) continue;
                tag.func_74778_a((String)entry.getKey(), primitive.getAsString());
                continue;
            }
            if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
            JsonObject object = ((JsonElement)entry.getValue()).getAsJsonObject();
            if (object.has("type")) {
                String type = object.get("type").getAsString();
                if (type.equalsIgnoreCase("tagCompound")) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    JsonContentLoader.processNBTTagCompound(object, nbt);
                    tag.func_74782_a((String)entry.getKey(), (NBTBase)nbt);
                    continue;
                }
                if (type.equalsIgnoreCase("int")) {
                    tag.func_74768_a((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                    continue;
                }
                if (type.equalsIgnoreCase("double")) {
                    tag.func_74780_a((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsDouble());
                    continue;
                }
                if (type.equalsIgnoreCase("float")) {
                    tag.func_74776_a((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsFloat());
                    continue;
                }
                if (type.equalsIgnoreCase("byte")) {
                    tag.func_74774_a((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsByte());
                    continue;
                }
                if (type.equalsIgnoreCase("short")) {
                    tag.func_74777_a((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsShort());
                    continue;
                }
                if (!type.equalsIgnoreCase("long")) continue;
                tag.func_74772_a((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsLong());
                continue;
            }
            NBTTagCompound nbt = new NBTTagCompound();
            JsonContentLoader.processNBTTagCompound(object, nbt);
            tag.func_74782_a((String)entry.getKey(), (NBTBase)nbt);
        }
    }

    public void clear() {
        this.externalFiles.clear();
        this.externalJarFiles.clear();
        this.classPathResources.clear();
        this.jsonEntries.clear();
    }

    public static class JsonEntry {
        public final String jsonKey;
        public final JsonElement element;
        public final String fileReadFrom;
        public String author;
        public String authorHelpSite;

        public JsonEntry(String jsonKey, String fileReadFrom, JsonElement element) {
            this.jsonKey = jsonKey;
            this.fileReadFrom = fileReadFrom;
            this.element = element;
        }

        public String toString() {
            return this.jsonKey + "[" + this.element + "]";
        }

        public boolean equals(Object object) {
            if (object instanceof JsonEntry) {
                return this.jsonKey.equals(((JsonEntry)object).jsonKey) && this.element.equals(((JsonEntry)object).element);
            }
            return false;
        }
    }

    public static class StringSortingComparator
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            if (o1.contains("@") && !o2.contains("@")) {
                return 1;
            }
            if (!o1.contains("@") && o2.contains("@")) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    }
}

