/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.json.recipe.smelting;

import com.builtbroken.mc.core.Engine;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class SmeltingRecipe {
    public final Object input;
    public int inputMeta = -1;
    public float xp;
    public ItemStack output;

    public SmeltingRecipe(Object input) {
        this.input = input;
        if (!(input instanceof Block) && !(input instanceof Item)) {
            throw new IllegalArgumentException("Input for a smelting recipe must be an Item or Block");
        }
    }

    public void register() {
        ItemStack output = this.getOutput();
        if (output != null) {
            if (this.input instanceof Block) {
                if (this.inputMeta > -1) {
                    GameRegistry.addSmelting((ItemStack)new ItemStack((Block)this.input, 1, this.inputMeta), (ItemStack)output, (float)this.xp);
                } else {
                    GameRegistry.addSmelting((Block)((Block)this.input), (ItemStack)output, (float)this.xp);
                }
            } else if (this.input instanceof Item) {
                if (this.inputMeta > -1) {
                    GameRegistry.addSmelting((ItemStack)new ItemStack((Item)this.input, 1, this.inputMeta), (ItemStack)output, (float)this.xp);
                } else {
                    GameRegistry.addSmelting((Item)((Item)this.input), (ItemStack)output, (float)this.xp);
                }
            }
        } else {
            Engine.logger().error("JsonSmeltingRecipe: Failed to get output for " + this);
        }
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public String toString() {
        return "SmeltingRecipe[" + this.input + (this.inputMeta != -1 ? "@" + this.inputMeta : "") + " -> " + this.getOutput() + "]";
    }
}

