/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.mod;

import com.builtbroken.mc.core.registry.ModManager;
import com.builtbroken.mc.lib.mod.AbstractProxy;
import com.builtbroken.mc.lib.mod.IMod;
import com.builtbroken.mc.lib.mod.loadable.LoadableHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractMod
implements IMod {
    protected LoadableHandler loader;
    protected ModManager manager;
    protected Logger logger;
    protected String configPath;
    private Configuration config;
    protected boolean fireProxyPreInit = true;
    private final String domain;
    public String modIssueTracker;

    public AbstractMod(String domain) {
        this.domain = domain;
        this.loader = new LoadableHandler();
        this.manager = new ModManager().setPrefix(domain);
        this.logger = LogManager.getLogger((String)domain);
    }

    public AbstractMod(String domain, String configName) {
        this(domain);
        this.configPath = configName + ".cfg";
    }

    public void preInit(FMLPreInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)this.getProxy());
        this.config = this.getClass().toString().contains("com.builtbroken") ? (this.configPath == null || this.configPath.isEmpty() ? new Configuration(new File(event.getModConfigurationDirectory(), "bbm/" + event.getSuggestedConfigurationFile().getName())) : new Configuration(new File(event.getModConfigurationDirectory(), "bbm/" + this.configPath))) : (this.configPath == null || this.configPath.isEmpty() ? new Configuration(event.getSuggestedConfigurationFile()) : new Configuration(new File(event.getModConfigurationDirectory(), this.configPath)));
        this.getConfig().load();
        this.loader.applyModule(this.getProxy());
        this.loadHandlers(this.loader);
        this.loadBlocks(this.manager);
        this.loadItems(this.manager);
        if (this.fireProxyPreInit) {
            this.loader.preInit();
        }
    }

    public void init(FMLInitializationEvent event) {
        this.loadEntities(this.manager);
        this.loader.init();
        this.getManager().fireInit();
    }

    public void postInit(FMLPostInitializationEvent event) {
        this.loader.postInit();
        this.getManager().firePostInit();
        this.loadRecipes(this.manager);
        this.getConfig().save();
    }

    public void loadHandlers(LoadableHandler loader) {
    }

    protected void loadBlocks(ModManager manager) {
    }

    public void loadItems(ModManager manager) {
    }

    public void loadEntities(ModManager manager) {
    }

    public void loadRecipes(ModManager manager) {
    }

    public Configuration getConfig() {
        return this.config;
    }

    public ModManager getManager() {
        return this.manager;
    }

    public Logger logger() {
        return this.logger;
    }

    public abstract AbstractProxy getProxy();

    @Override
    public final String getPrefix() {
        return this.domain + ":";
    }

    @Override
    public final String getDomain() {
        return this.domain;
    }
}

