/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.mod.compat.ue;

import com.builtbroken.mc.api.InjectTemplate;
import com.builtbroken.mc.api.energy.IEnergyBuffer;
import com.builtbroken.mc.api.energy.IEnergyBufferProvider;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.prefab.energy.EnergyBuffer;
import com.builtbroken.mc.prefab.tile.TileEnt;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

@InjectTemplate(integration="RF-IEnergyHandler;IC-IEnergySink")
public class TileUniversalBattery
extends TileEnt
implements IEnergyBufferProvider {
    private int energy = 0;
    private boolean energyHadChanged = true;
    private static int maxEnergy = 1000;
    private static int iconsArrayLength = 16;
    @SideOnly(value=Side.CLIENT)
    private static IIcon[] icons;
    private static IIcon topBotIcon;
    private EnergyBuffer buffer;

    public TileUniversalBattery() {
        super("DemoUEBattery", Material.field_151573_f);
        this.creativeTab = CreativeTabs.field_78028_d;
        this.resistance = 10.0f;
        this.hardness = 10.0f;
    }

    @Override
    public TileUniversalBattery newTile() {
        return new TileUniversalBattery();
    }

    @Override
    public void update() {
        super.update();
        if (this.isServer() && this.ticks % 10L == 0L && this.energyHadChanged) {
            this.energyHadChanged = false;
            float percent = (float)this.energy / (float)maxEnergy;
            int meta = (int)(percent * (float)iconsArrayLength);
            this.world().func_72921_c(this.xi(), this.yi(), this.zi(), meta, 3);
        }
    }

    @Override
    protected boolean onPlayerRightClick(EntityPlayer player, int side, Pos hit) {
        if (player.func_70694_bm() == null || !(player.func_70694_bm().func_77973_b() instanceof ItemBlock)) {
            if (this.isServer()) {
                player.func_146105_b((IChatComponent)new ChatComponentText(LanguageUtility.getLocal("text.power.amount").replace("%1", "" + this.energy).replace("%2", "" + maxEnergy)));
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return side == 0 || side == 1 ? topBotIcon : icons[meta];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        topBotIcon = iconRegister.func_94245_a("voltzengine:metal_diamond");
        icons = new IIcon[iconsArrayLength];
        TileUniversalBattery.icons[0] = iconRegister.func_94245_a("voltzengine:battery/battery");
        for (int i = 1; i < iconsArrayLength; ++i) {
            TileUniversalBattery.icons[i] = iconRegister.func_94245_a("voltzengine:battery/battery" + i);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energy = nbt.func_74762_e("energy");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("energy", this.energy);
    }

    @Override
    public void getSubBlocks(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < 15; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @Override
    public void onPlaced(EntityLivingBase entityLiving, ItemStack itemStack) {
        super.onPlaced(entityLiving, itemStack);
        TileEntity tile = this.world().func_147438_o(this.xi(), this.yi(), this.zi());
        if (itemStack.func_77960_j() > 0 && tile instanceof TileUniversalBattery) {
            ((TileUniversalBattery)tile).energy = (int)((float)maxEnergy * ((float)itemStack.func_77960_j() / 14.0f));
        }
    }

    @Override
    public IEnergyBuffer getEnergyBuffer(ForgeDirection side) {
        if (this.buffer == null) {
            this.buffer = new EnergyBuffer(maxEnergy);
        }
        return this.buffer;
    }
}

