/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.modflags;

import com.builtbroken.mc.lib.access.AccessGroup;
import com.builtbroken.mc.lib.access.AccessProfile;
import com.builtbroken.mc.lib.access.AccessUser;
import com.builtbroken.mc.lib.access.Permission;
import com.builtbroken.mc.lib.access.Permissions;
import com.builtbroken.mc.lib.modflags.RegionController;
import java.util.HashMap;
import net.minecraft.world.World;

public class RegionManager {
    private static HashMap<Integer, RegionController> controllersByDim = new HashMap();
    public static final Permission root = new Permission("region");
    public static final Permission interaction = root.addChild("interaction");
    public static final Permission rightClick = interaction.addChild("rightclick");
    public static final Permission leftClick = interaction.addChild("leftclick");
    public static final Permission break_block = interaction.addChild("break");

    public static RegionController getControllerForWorld(World world) {
        if (world != null) {
            return RegionManager.getControllerForDim(world.field_73011_w.field_76574_g);
        }
        return null;
    }

    public static RegionController getControllerForDim(int dim) {
        if (!controllersByDim.containsKey(dim)) {
            controllersByDim.put(dim, new RegionController(dim));
        }
        return controllersByDim.get(dim);
    }

    public static AccessProfile generateDefaultAccessProfile() {
        AccessProfile profile = new AccessProfile();
        AccessGroup owner_group = new AccessGroup("owner", new AccessUser[0]);
        owner_group.addNode(Permissions.profile.toString());
        AccessGroup admin_group = new AccessGroup("admin", new AccessUser[0]);
        owner_group.addNode(Permissions.group.toString());
        AccessGroup user_group = new AccessGroup("user", new AccessUser[0]);
        user_group.addNode(rightClick.toString());
        user_group.addNode(leftClick.toString());
        user_group.addNode(break_block.toString());
        admin_group.setToExtend(user_group);
        owner_group.setToExtend(admin_group);
        profile.addGroup(user_group);
        profile.addGroup(admin_group);
        profile.addGroup(owner_group);
        return profile;
    }
}

