/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.render.model.loader;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.render.model.FixedTechneModel;
import com.builtbroken.mc.lib.render.model.loader.FixedTechneModelLoader;
import com.google.common.collect.Maps;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.client.model.IModelCustomLoader;
import net.minecraftforge.client.model.ModelFormatException;
import net.minecraftforge.client.model.obj.ObjModelLoader;

@SideOnly(value=Side.CLIENT)
public class EngineModelLoader {
    private static Map<String, IModelCustomLoader> instances = Maps.newHashMap();

    public static void registerModelHandler(IModelCustomLoader modelHandler) {
        for (String suffix : modelHandler.getSuffixes()) {
            instances.put(suffix, modelHandler);
        }
    }

    public static IModelCustom loadModel(ResourceLocation resource) throws IllegalArgumentException, ModelFormatException {
        String name = resource.func_110623_a();
        int i = name.lastIndexOf(46);
        if (i == -1) {
            Engine.instance.logger().error("The resource name %s is not valid", new Object[]{resource});
            throw new IllegalArgumentException("The resource name is not valid");
        }
        String suffix = name.substring(i + 1);
        IModelCustomLoader loader = instances.get(suffix);
        if (loader == null) {
            Engine.instance.logger().error("The resource name %s is not supported", new Object[]{resource});
            throw new IllegalArgumentException("The resource name is not supported");
        }
        return loader.loadInstance(resource);
    }

    public static FixedTechneModel loadTechneModel(ResourceLocation resource) {
        IModelCustom model = EngineModelLoader.loadModel(resource);
        if (!(model instanceof FixedTechneModel)) {
            Engine.instance.logger().error("The resource name %s is not a techne model", new Object[]{resource});
            throw new IllegalArgumentException("The resource name is not supported");
        }
        return (FixedTechneModel)model;
    }

    static {
        EngineModelLoader.registerModelHandler((IModelCustomLoader)new ObjModelLoader());
        EngineModelLoader.registerModelHandler(new FixedTechneModelLoader());
    }
}

