/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.transform.region;

import com.builtbroken.jlib.data.vector.IPos2D;
import com.builtbroken.mc.lib.transform.region.Shape2D;
import com.builtbroken.mc.lib.transform.region.Triangle;
import com.builtbroken.mc.lib.transform.vector.Point;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0001\u0003\u0001=\u0011\u0011BU3di\u0006tw\r\\3\u000b\u0005\r!\u0011A\u0002:fO&|gN\u0003\u0002\u0006\r\u0005IAO]1og\u001a|'/\u001c\u0006\u0003\u000f!\t1\u0001\\5c\u0015\tI!\"\u0001\u0002nG*\u00111\u0002D\u0001\fEVLG\u000e\u001e2s_.,gNC\u0001\u000e\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t91\u000b[1qKJ\"\u0005\u0002C\u000b\u0001\u0005\u0003\u0007I\u0011\u0001\f\u0002\u00075Lg.F\u0001\u0018!\tA2$D\u0001\u001a\u0015\tQB!\u0001\u0004wK\u000e$xN]\u0005\u00039e\u0011Q\u0001U8j]RD\u0001B\b\u0001\u0003\u0002\u0004%\taH\u0001\b[&tw\fJ3r)\t\u0001c\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0003V]&$\bbB\u0014\u001e\u0003\u0003\u0005\raF\u0001\u0004q\u0012\n\u0004\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0015B\f\u0002\t5Lg\u000e\t\u0005\tW\u0001\u0011\t\u0019!C\u0001-\u0005\u0019Q.\u0019=\t\u00115\u0002!\u00111A\u0005\u00029\nq!\\1y?\u0012*\u0017\u000f\u0006\u0002!_!9q\u0005LA\u0001\u0002\u00049\u0002\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0015B\f\u0002\t5\f\u0007\u0010\t\u0005\u0006g\u0001!\t\u0001N\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007U2t\u0007\u0005\u0002\u0012\u0001!)QC\ra\u0001/!)1F\ra\u0001/!)1\u0007\u0001C\u0001sQ\tQ\u0007C\u00034\u0001\u0011\u00051\bF\u00026yyBQ!\u0010\u001eA\u0002]\t1A^3d\u0011\u0015y$\b1\u0001A\u0003%)\u0007\u0010]1og&|g\u000e\u0005\u0002\"\u0003&\u0011!I\t\u0002\u0007\t>,(\r\\3\t\u000bM\u0002A\u0011\u0001#\u0015\u000bU*u)S&\t\u000b\u0019\u001b\u0005\u0019\u0001!\u0002\t5Lg\u000e\u0017\u0005\u0006\u0011\u000e\u0003\r\u0001Q\u0001\u0005[&t\u0017\fC\u0003K\u0007\u0002\u0007\u0001)\u0001\u0003nCbD\u0006\"\u0002'D\u0001\u0004\u0001\u0015\u0001B7bqfCQa\r\u0001\u0005\u00029#\"!N(\t\u000bAk\u0005\u0019A\u001b\u0002\tI,7\r\u001e\u0005\u0006%\u0002!\teU\u0001\tSN<\u0016\u000e\u001e5j]R\u0011Ak\u0016\t\u0003CUK!A\u0016\u0012\u0003\u000f\t{w\u000e\\3b]\")\u0001,\u0015a\u00013\u0006\t\u0001\u000f\u0005\u0002[A6\t1L\u0003\u0002\u001b9*\u0011QLX\u0001\u0005I\u0006$\u0018M\u0003\u0002`\u0015\u0005!!\u000e\\5c\u0013\t\t7L\u0001\u0004J!>\u001c(\u0007\u0012\u0005\u0006G\u0002!\t\u0001Z\u0001\u0011SN<\u0016\u000e\u001e5j]~\u0013x\u000e^1uK\u0012$\"\u0001V3\t\u000ba\u0013\u0007\u0019A-\t\u000b\u001d\u0004A\u0011\u00015\u0002\u000f\r|'O\\3s\u0003R\tq\u0003C\u0003k\u0001\u0011\u0005\u0001.A\u0004d_JtWM\u001d\"\t\u000b1\u0004A\u0011\u00015\u0002\u000f\r|'O\\3s\u0007\")a\u000e\u0001C\u0001Q\u000691m\u001c:oKJ$\u0005\"\u00029\u0001\t\u0003\t\u0018AC5oi\u0016\u00148/Z2ugR\u0011AK\u001d\u0005\u0006\u0007=\u0004\r!\u000e\u0005\u0006i\u0002!\t%^\u0001\bO\u0016$\u0018I]3b)\u0005\u0001\u0005\"B<\u0001\t\u0003*\u0018\u0001C4fiNK'0\u001a-\t\u000be\u0004A\u0011I;\u0002\u0011\u001d,GoU5{KfCQa\u001f\u0001\u0005Bq\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002{B\u0019a0a\u0001\u000f\u0005\u0005z\u0018bAA\u0001E\u00051\u0001K]3eK\u001aLA!!\u0002\u0002\b\t11\u000b\u001e:j]\u001eT1!!\u0001#\u0011\u001d\tY\u0001\u0001C!\u0003\u001b\ta!Z9vC2\u001cHc\u0001+\u0002\u0010!A\u0011\u0011CA\u0005\u0001\u0004\t\u0019\"A\u0001p!\r\t\u0013QC\u0005\u0004\u0003/\u0011#aA!os\"1\u00111\u0004\u0001\u0005Be\nQa\u00197p]\u0016\u0004")
public class Rectangle
extends Shape2D {
    private Point min;
    private Point max;

    public Point min() {
        return this.min;
    }

    public void min_$eq(Point x$1) {
        this.min = x$1;
    }

    public Point max() {
        return this.max;
    }

    public void max_$eq(Point x$1) {
        this.max = x$1;
    }

    @Override
    public boolean isWithin(IPos2D p) {
        return p.y() >= this.min().y() && p.y() <= this.max().y() && p.x() >= this.min().x() && p.x() <= this.max().x();
    }

    public boolean isWithin_rotated(IPos2D p) {
        double areaDA;
        double areaCD;
        double areaBC;
        Point cornerB = this.cornerB();
        Point cornerD = this.cornerD();
        double areaAB = new Triangle(this.cornerA(), cornerB, p).getArea();
        return areaAB + (areaBC = new Triangle(cornerB, this.cornerC(), p).getArea()) + (areaCD = new Triangle(this.cornerC(), cornerD, p).getArea()) + (areaDA = new Triangle(cornerD, this.cornerA(), p).getArea()) <= this.getArea();
    }

    public Point cornerA() {
        return this.min();
    }

    public Point cornerB() {
        return new Point(this.min().x(), this.max().y());
    }

    public Point cornerC() {
        return this.max();
    }

    public Point cornerD() {
        return new Point(this.max().x(), this.min().y());
    }

    public boolean intersects(Rectangle region) {
        return region.max().x() > this.min().x() && region.min().x() < this.max().x() ? region.max().y() > this.min().y() && region.min().y() < this.max().y() : false;
    }

    @Override
    public double getArea() {
        return this.getSizeX() * this.getSizeY();
    }

    @Override
    public double getSizeX() {
        return this.max().x() - this.min().x();
    }

    @Override
    public double getSizeY() {
        return this.max().y() - this.min().y();
    }

    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        return new StringBuilder().append((Object)"Rectangle[").append((Object)new BigDecimal(this.min().x(), cont)).append((Object)", ").append((Object)new BigDecimal(this.min().y(), cont)).append((Object)"] -> [").append((Object)new BigDecimal(this.max().x(), cont)).append((Object)", ").append((Object)new BigDecimal(this.max().y(), cont)).append((Object)"]").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof Rectangle)) return false;
        Point point = this.min();
        Point point2 = ((Rectangle)o).min();
        if (point == null) {
            if (point2 != null) {
                return false;
            }
        } else if (!point.equals(point2)) return false;
        Point point3 = this.max();
        Point point4 = ((Rectangle)o).max();
        if (point3 == null) {
            if (point4 == null) return true;
            return false;
        } else {
            if (!point3.equals(point4)) return false;
            return true;
        }
    }

    public Rectangle clone() {
        return new Rectangle(this);
    }

    public Rectangle(Point min, Point max) {
        this.min = min;
        this.max = max;
        super((Point)min.midpoint(max));
    }

    public Rectangle() {
        this(new Point(), new Point());
    }

    public Rectangle(Point vec, double expansion) {
        this(vec, (Point)vec.add(expansion));
    }

    public Rectangle(double minX, double minY, double maxX, double maxY) {
        this(new Point(minX, minY), new Point(maxX, maxY));
    }

    public Rectangle(Rectangle rect) {
        this((Point)rect.min().clone(), (Point)rect.max().clone());
    }
}

