/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.transform.rotation;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.jlib.data.vector.ITransform;
import com.builtbroken.mc.lib.transform.matrix.Matrix;
import com.builtbroken.mc.lib.transform.rotation.AngleAxis$;
import com.builtbroken.mc.lib.transform.rotation.EulerAngle;
import com.builtbroken.mc.lib.transform.vector.Pos;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import scala.Cloneable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\u0001\u0003\u0001=\u0011\u0011\"\u00118hY\u0016\f\u00050[:\u000b\u0005\r!\u0011\u0001\u0003:pi\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!\u0003;sC:\u001chm\u001c:n\u0015\t9\u0001\"A\u0002mS\nT!!\u0003\u0006\u0002\u00055\u001c'BA\u0006\r\u0003-\u0011W/\u001b7uEJ|7.\u001a8\u000b\u00035\t1aY8n\u0007\u0001\u0019B\u0001\u0001\t\u0019=A\u0011\u0011CF\u0007\u0002%)\u00111\u0003F\u0001\u0005Y\u0006twMC\u0001\u0016\u0003\u0011Q\u0017M^1\n\u0005]\u0011\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"DA\u0005DY>tW-\u00192mKB\u0011qDJ\u0007\u0002A)\u0011\u0011EI\u0001\u0007m\u0016\u001cGo\u001c:\u000b\u0005\r\"\u0013\u0001\u00023bi\u0006T!!\n\u0006\u0002\t)d\u0017NY\u0005\u0003O\u0001\u0012!\"\u0013+sC:\u001chm\u001c:n\u0011!I\u0003A!a\u0001\n\u0003Q\u0013!B1oO2,W#A\u0016\u0011\u0005ea\u0013BA\u0017\u001b\u0005\u0019!u.\u001e2mK\"Aq\u0006\u0001BA\u0002\u0013\u0005\u0001'A\u0005b]\u001edWm\u0018\u0013fcR\u0011\u0011\u0007\u000e\t\u00033IJ!a\r\u000e\u0003\tUs\u0017\u000e\u001e\u0005\bk9\n\t\u00111\u0001,\u0003\rAH%\r\u0005\to\u0001\u0011\t\u0011)Q\u0005W\u00051\u0011M\\4mK\u0002B\u0001\"\u000f\u0001\u0003\u0002\u0004%\tAO\u0001\u0005CbL7/F\u0001<!\tad(D\u0001>\u0015\t\tC!\u0003\u0002@{\t\u0019\u0001k\\:\t\u0011\u0005\u0003!\u00111A\u0005\u0002\t\u000b\u0001\"\u0019=jg~#S-\u001d\u000b\u0003c\rCq!\u000e!\u0002\u0002\u0003\u00071\b\u0003\u0005F\u0001\t\u0005\t\u0015)\u0003<\u0003\u0015\t\u00070[:!\u0011\u00159\u0005\u0001\"\u0001I\u0003\u0019a\u0014N\\5u}Q\u0019\u0011j\u0013'\u0011\u0005)\u0003Q\"\u0001\u0002\t\u000f%2\u0005\u0013!a\u0001W!9\u0011H\u0012I\u0001\u0002\u0004Y\u0004\"B$\u0001\t\u0003qECA%P\u0011\u0015\u0001V\n1\u0001R\u0003\rq'\r\u001e\t\u0003%bk\u0011a\u0015\u0006\u0003!RS!!\u0016,\u0002\u00135Lg.Z2sC\u001a$(\"A,\u0002\u00079,G/\u0003\u0002Z'\nqaJ\u0011+UC\u001e\u001cu.\u001c9pk:$\u0007\"B.\u0001\t\u0003a\u0016\u0001B2fS2,\u0012!\u0013\u0005\u0006=\u0002!\t\u0001X\u0001\u0006M2|wN\u001d\u0005\u0006A\u0002!\t\u0001X\u0001\u0006e>,h\u000e\u001a\u0005\u0006\u000b\u0001!\tE\u0019\u000b\u0003w\rDQ!I1A\u0002\u0011\u0004\"aH3\n\u0005\u0019\u0004#AB%Q_N\u001cD\tC\u0003i\u0001\u0011\u0005\u0011.\u0001\tu_J{G/\u0019;j_:l\u0015\r\u001e:jqV\t!\u000e\u0005\u0002l]6\tAN\u0003\u0002n\t\u00051Q.\u0019;sSbL!a\u001c7\u0003\r5\u000bGO]5y\u0011\u0015\t\b\u0001\"\u0001s\u00031!x.R;mKJ\fen\u001a7f+\u0005\u0019\bC\u0001&u\u0013\t)(A\u0001\u0006Fk2,'/\u00118hY\u0016DQa\u001e\u0001\u0005\u0002a\f\u0001b\u001e:ji\u0016t%\t\u0016\u000b\u0003#fDQ\u0001\u0015<A\u0002ECQa\u001f\u0001\u0005\u0002q\fAb\u001e:ji\u0016\u0014\u0015\u0010^3Ck\u001a$2!`A\b!\rq\u00181B\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003\u0019\u0011WO\u001a4fe*!\u0011QAA\u0004\u0003\u0015qW\r\u001e;z\u0015\t\tI!\u0001\u0002j_&\u0019\u0011QB@\u0003\u000f\tKH/\u001a\"vM\")1E\u001fa\u0001{\"9\u00111\u0003\u0001\u0005B\u0005U\u0011!B2m_:,G#A%\t\u000f\u0005e\u0001\u0001\"\u0011\u0002\u001c\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\u001eA\u0019\u0011$a\b\n\u0007\u0005\u0005\"DA\u0002J]RDq!!\n\u0001\t\u0003\n9#\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003S\ty\u0003E\u0002\u001a\u0003WI1!!\f\u001b\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\r\u0002$\u0001\u0007\u00111G\u0001\u0002_B\u0019\u0011$!\u000e\n\u0007\u0005]\"DA\u0002B]f<\u0011\"a\u000f\u0003\u0003\u0003E\t!!\u0010\u0002\u0013\u0005sw\r\\3Bq&\u001c\bc\u0001&\u0002@\u0019A\u0011AAA\u0001\u0012\u0003\t\te\u0005\u0003\u0002@\u0005\r\u0003cA\r\u0002F%\u0019\u0011q\t\u000e\u0003\r\u0005s\u0017PU3g\u0011\u001d9\u0015q\bC\u0001\u0003\u0017\"\"!!\u0010\t\u0015\u0005=\u0013qHI\u0001\n\u0003\t\t&A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u000b\u0003\u0003'R3aKA+W\t\t9\u0006\u0005\u0003\u0002Z\u0005\rTBAA.\u0015\u0011\ti&a\u0018\u0002\u0013Ut7\r[3dW\u0016$'bAA15\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00141\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007BCA5\u0003\u007f\t\n\u0011\"\u0001\u0002l\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"!!\u001c+\u0007m\n)\u0006")
public class AngleAxis
implements Cloneable,
ITransform {
    private double angle;
    private Pos axis;

    public static Pos $lessinit$greater$default$2() {
        return AngleAxis$.MODULE$.$lessinit$greater$default$2();
    }

    public static double $lessinit$greater$default$1() {
        return AngleAxis$.MODULE$.$lessinit$greater$default$1();
    }

    public double angle() {
        return this.angle;
    }

    public void angle_$eq(double x$1) {
        this.angle = x$1;
    }

    public Pos axis() {
        return this.axis;
    }

    public void axis_$eq(Pos x$1) {
        this.axis = x$1;
    }

    public AngleAxis ceil() {
        return new AngleAxis(Math.ceil(this.angle()), (Pos)this.axis().ceil());
    }

    public AngleAxis floor() {
        return new AngleAxis(Math.floor(this.angle()), (Pos)this.axis().floor());
    }

    public AngleAxis round() {
        return new AngleAxis(Math.round(this.angle()), (Pos)this.axis().round());
    }

    public Pos transform(IPos3D vector) {
        return this.toRotationMatrix().$times(vector);
    }

    public Matrix toRotationMatrix() {
        double x = this.axis().x();
        double y = this.axis().y();
        double z = this.axis().z();
        double cos = Math.cos(this.angle());
        double oneMinusCos = 1.0 - cos;
        double sin = Math.sin(this.angle());
        Matrix matrix = new Matrix(3, 3);
        matrix.apply(0).update(0, x * x * oneMinusCos + cos);
        matrix.apply(0).update(1, y * x * oneMinusCos + z * sin);
        matrix.apply(0).update(2, x * z * oneMinusCos - y * sin);
        matrix.apply(1).update(0, x * y * oneMinusCos - z * sin);
        matrix.apply(1).update(1, y * y * oneMinusCos + cos);
        matrix.apply(1).update(2, y * z * oneMinusCos + x * sin);
        matrix.apply(2).update(0, x * z * oneMinusCos + y * sin);
        matrix.apply(2).update(1, y * z * oneMinusCos - x * sin);
        matrix.apply(2).update(2, z * z * oneMinusCos + cos);
        return matrix;
    }

    public EulerAngle toEulerAngle() {
        double x = this.axis().x();
        double y = this.axis().y();
        double z = this.axis().z();
        double s = Math.sin(this.angle());
        double c = Math.cos(this.angle());
        double t = 1.0 - c;
        double yaw = 0.0;
        double pitch = 0.0;
        double roll = 0.0;
        if (x * y * t + z * s > 0.998) {
            yaw = (double)2 * Math.atan2(x * Math.sin(this.angle() / (double)2), Math.cos(this.angle() / (double)2));
            pitch = 1.5707963267948966;
            roll = 0.0;
            return new EulerAngle(yaw, pitch, roll);
        }
        if (x * y * t + z * s < -0.998) {
            yaw = (double)-2 * Math.atan2(x * Math.sin(this.angle() / (double)2), Math.cos(this.angle() / (double)2));
            pitch = -Math.PI / (double)2;
            roll = 0.0;
            return new EulerAngle(yaw, pitch, roll);
        }
        yaw = Math.atan2(y * s - x * z * t, 1.0 - (y * y + z * z) * t);
        pitch = Math.asin(x * y * t + z * s);
        roll = Math.atan2(x * s - y * z * t, 1.0 - (x * x + z * z) * t);
        return new EulerAngle(yaw, pitch, roll);
    }

    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        this.axis().writeNBT(nbt);
        nbt.func_74780_a("angle", this.angle());
        return nbt;
    }

    public ByteBuf writeByteBuf(ByteBuf data) {
        this.axis().writeByteBuf(data);
        data.writeDouble(this.angle());
        return data;
    }

    public AngleAxis clone() {
        return new AngleAxis(this.angle(), this.axis());
    }

    public int hashCode() {
        long angle = Double.doubleToLongBits(this.angle());
        int hash = this.axis().hashCode();
        hash = 31 * hash + (int)(angle ^ angle >>> 32);
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof AngleAxis) {
            AngleAxis other = (AngleAxis)o;
            return this.axis().equals((Object)other.axis()) && this.angle() == other.angle();
        }
        return false;
    }

    public AngleAxis(double angle, Pos axis) {
        this.angle = angle;
        this.axis = axis;
    }

    public AngleAxis(NBTTagCompound nbt) {
        this(nbt.func_74769_h("angle"), new Pos(nbt));
    }
}

