/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.transform.vector;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.lib.transform.vector.AbstractLocation;
import com.builtbroken.mc.lib.transform.vector.Pos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.dispenser.ILocation;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class Location
extends AbstractLocation<Location>
implements IWorldPosition,
IPos3D,
Comparable<IWorldPosition> {
    public Location(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public Location(NBTTagCompound nbt) {
        this((World)DimensionManager.getWorld((int)nbt.func_74762_e("dimension")), nbt.func_74769_h("x"), nbt.func_74769_h("y"), nbt.func_74769_h("z"));
    }

    public Location(ByteBuf data) {
        this((World)DimensionManager.getWorld((int)data.readInt()), data.readDouble(), data.readDouble(), data.readDouble());
    }

    public Location(Entity entity) {
        this(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public Location(TileEntity tile) {
        this(tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
    }

    public Location(IWorldPosition vec) {
        this(vec.world(), vec.x(), vec.y(), vec.z());
    }

    public Location(ILocation loc) {
        this(loc.func_82618_k(), loc.func_82615_a(), loc.func_82617_b(), loc.func_82616_c());
    }

    public Location(World world, IPos3D vector) {
        this(world, vector.x(), vector.y(), vector.z());
    }

    public Location(World world, Vec3 vec) {
        this(world, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public Location(World world, MovingObjectPosition target) {
        this(world, target.field_72307_f);
    }

    public Location newPos(double x, double y, double z) {
        return new Location(this.world, x, y, z);
    }

    public void playSound(String sound, float volume, float pitch) {
        this.world().func_72980_b(this.x(), this.y(), this.z(), sound, volume, pitch, false);
    }

    public void playSound(Block block) {
        Block.SoundType soundtype = block.field_149762_H;
        this.playSound(soundtype.func_150498_e(), soundtype.func_150497_c() * 0.5f, soundtype.func_150494_d() * 0.75f);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticle(String t, IPos3D vel) {
        this.spawnParticle(t, vel.x(), vel.y(), vel.z());
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticle(String t, double vel_x, double vel_y, double vel_z) {
        this.world().func_72869_a(t, this.x(), this.y(), this.z(), vel_x, vel_y, vel_z);
    }

    @SideOnly(value=Side.CLIENT)
    public void playBlockBreakAnimation() {
        Block block = this.getBlock();
        if (block != null && block.func_149688_o() != Material.field_151579_a) {
            this.playSound(block);
            Random rand = this.world().field_73012_v;
            for (int i = 0; i < 3 + rand.nextInt(20); ++i) {
                Location v = (Location)this.addRandom(rand, 0.5);
                Pos vel = (Pos)new Pos().addRandom(rand, 0.2);
                v.spawnParticle("blockcrack_" + Block.func_149682_b((Block)block) + "_" + v.getBlockMetadata(), vel);
            }
        }
    }

    public boolean isSideSolid(ForgeDirection side) {
        return this.getBlock().isSideSolid((IBlockAccess)this.world(), this.xi(), this.yi(), this.zi(), side);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof IWorldPosition && this.world == ((IWorldPosition)o).world() && ((IWorldPosition)o).x() == this.x() && ((IWorldPosition)o).y() == this.y() && ((IWorldPosition)o).z() == this.z();
    }

    @Override
    public int compareTo(IWorldPosition that) {
        if (this.world().field_73011_w.field_76574_g < that.world().field_73011_w.field_76574_g || this.x() < that.x() || this.y() < that.y() || this.z() < that.z()) {
            return -1;
        }
        if (this.world().field_73011_w.field_76574_g > that.world().field_73011_w.field_76574_g || this.x() > that.x() || this.y() > that.y() || this.z() > that.z()) {
            return 1;
        }
        return 0;
    }
}

