/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.edit;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.api.edit.IWorldEdit;
import com.builtbroken.mc.lib.transform.vector.AbstractLocation;
import com.builtbroken.mc.lib.world.edit.BlockEditResult;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class BlockEdit
extends AbstractLocation<BlockEdit>
implements IWorldEdit,
IPos3D,
IWorldPosition {
    public Block prev_block = Blocks.field_150350_a;
    public int prev_meta = 0;
    public List<ItemStack> drops;
    public Block newBlock = Blocks.field_150350_a;
    public int newMeta = 0;
    public float energy = 0.0f;
    public EnumFacing face = null;
    public boolean doItemDrop = false;
    public boolean checkForPrevBlockEquals = false;
    public boolean checkForEntity = false;
    private AxisAlignedBB bounds;

    public BlockEdit(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public BlockEdit(NBTTagCompound nbt) {
        super(nbt);
    }

    public BlockEdit(ByteBuf data) {
        super(data);
    }

    public BlockEdit(Entity entity) {
        super(entity);
    }

    public BlockEdit(TileEntity tile) {
        super(tile);
    }

    public BlockEdit(IWorldPosition vec) {
        super(vec);
    }

    public BlockEdit(IWorldPosition vec, Block block) {
        super(vec);
        this.set(block, 0, false, true);
    }

    public BlockEdit(IWorldPosition vec, Block block, int meta) {
        super(vec);
        this.set(block, meta, false, true);
    }

    public BlockEdit(World world, IPos3D vector) {
        super(world, vector);
    }

    public BlockEdit(World world, Vec3 vec) {
        super(world, vec);
    }

    public BlockEdit(World world, MovingObjectPosition target) {
        super(world, target);
    }

    public BlockEdit set(Block block, int meta, boolean doDrop, boolean checkEquals) {
        this.newBlock = block;
        this.newMeta = meta;
        this.doItemDrop = doDrop;
        this.checkForPrevBlockEquals = checkEquals;
        this.logPrevBlock();
        return this;
    }

    public BlockEdit set(Block block) {
        return this.set(block, 0, false, true);
    }

    public BlockEdit set(Block block, int meta) {
        return this.set(block, meta, false, true);
    }

    public BlockEdit setAir() {
        return this.set(Blocks.field_150350_a, 0, false, true);
    }

    public BlockEdit doDrops() {
        this.doItemDrop = true;
        return this;
    }

    public BlockEdit newPos(double x, double y, double z) {
        return new BlockEdit(this.world, x, y, z);
    }

    public BlockEdit logPrevBlock() {
        this.checkForPrevBlockEquals = true;
        if (this.world != null) {
            this.prev_block = this.getBlock();
            this.prev_meta = this.getBlockMetadata();
        }
        return this;
    }

    @Override
    public AxisAlignedBB getBounds() {
        if (this.bounds == null) {
            this.bounds = AxisAlignedBB.func_72330_a((double)this.xi(), (double)this.yi(), (double)this.zi(), (double)(this.xi() + 1), (double)(this.yi() + 1), (double)(this.zi() + 1));
        }
        return this.bounds;
    }

    @Override
    public BlockEditResult place() {
        if (this.world != null) {
            Chunk chunk = this.world.func_72938_d(this.xi(), this.zi());
            if (chunk != null && chunk.field_76636_d) {
                List entities;
                if (this.checkForPrevBlockEquals && this.prev_block != this.getBlock() && this.prev_meta != this.getBlockMetadata()) {
                    return BlockEditResult.PREV_BLOCK_CHANGED;
                }
                if (this.checkForEntity && (entities = this.world.func_72872_a(Entity.class, this.getBounds())).size() > 0) {
                    return BlockEditResult.ENTITY_BLOCKED;
                }
                return this.doPlace();
            }
            return BlockEditResult.CHUNK_UNLOADED;
        }
        return BlockEditResult.NULL_WORLD;
    }

    protected BlockEditResult doPlace() {
        if (this.getBlock() == this.newBlock && this.getBlockMetadata() == this.newMeta) {
            return BlockEditResult.ALREADY_PLACED;
        }
        if (super.setBlock(this.world, this.newBlock, this.newMeta)) {
            return BlockEditResult.PLACED;
        }
        return BlockEditResult.BLOCKED;
    }

    public List<ItemStack> getDrops() {
        return this.getDrops(0);
    }

    public List<ItemStack> getDrops(int f) {
        if (this.doItemDrop) {
            return this.getBlock().getDrops(this.world, this.xi(), this.yi(), this.zi(), this.getBlockMetadata(), f);
        }
        return new ArrayList<ItemStack>();
    }

    @Override
    public boolean hasChanged() {
        return this.prev_block != this.newBlock || this.prev_meta != this.newMeta;
    }

    @Override
    public Block getNewBlock() {
        return this.newBlock;
    }

    @Override
    public int getNewMeta() {
        return this.newMeta;
    }

    public int hashCode() {
        int result = 31 + (this.world() != null && this.world().field_73011_w != null ? this.world().field_73011_w.field_76574_g : 0);
        result = 31 * result + this.xi();
        result = 31 * result + this.yi();
        result = 31 * result + this.zi();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BlockEdit) {
            return ((BlockEdit)obj).world == this.world && ((BlockEdit)obj).xi() == this.xi() && ((BlockEdit)obj).yi() == this.yi() && ((BlockEdit)obj).zi() == this.zi();
        }
        return false;
    }

    @Override
    public String toString() {
        return "BlockEdit[ " + (this.world() != null && this.world().field_73011_w != null ? Integer.valueOf(this.world().field_73011_w.field_76574_g) : null) + "d, " + this.xi() + "x, " + this.yi() + "y, " + this.zi() + "z]";
    }
}

