/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.edit.thread;

import com.builtbroken.mc.api.VoltzEngineAPI;
import com.builtbroken.mc.api.process.IThreadProcess;
import com.builtbroken.mc.api.process.IWorkerThread;
import com.builtbroken.mc.core.Engine;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class WorkerThread
extends Thread
implements IWorkerThread {
    private Queue<IThreadProcess> que = new ConcurrentLinkedQueue<IThreadProcess>();
    private boolean waiting = false;
    private boolean kill = false;

    public WorkerThread(String name) {
        super("WorkerThread[" + name + "]");
        this.setPriority(5);
        VoltzEngineAPI.WORKER_THREADS.put(name, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block14: {
            try {
                while (!this.kill) {
                    Object process;
                    if (this.que.size() > 0) {
                        process = this.que.poll();
                        process.runProcess();
                        continue;
                    }
                    try {
                        this.waiting = true;
                        process = this;
                        synchronized (process) {
                            this.wait(10000L);
                        }
                    }
                    catch (IllegalMonitorStateException e) {
                        Engine.instance.logger().error(this + " has failed and is terminating...", (Throwable)e);
                        this.kill = true;
                    }
                    catch (InterruptedException e) {
                    }
                }
            }
            catch (Exception e) {
                Engine.instance.logger().error("World Change action thread[" + this + "] has failed to execute correctly.", (Throwable)e);
            }
            finally {
                if (this.que.size() <= 0) break block14;
                Engine.instance.logger().info("Killing " + this + " with processes left to run...");
                for (IThreadProcess process : this.que) {
                    Engine.instance.logger().info("\t" + process);
                    process.killAction();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(IThreadProcess process) {
        if (!this.contains(process)) {
            this.que.add(process);
            if (this.waiting) {
                WorkerThread workerThread = this;
                synchronized (workerThread) {
                    this.waiting = false;
                    this.notify();
                }
            }
        }
    }

    @Override
    public boolean contains(IThreadProcess process) {
        return this.que.contains(process);
    }

    @Override
    public int containedProcesses() {
        return this.que.size();
    }

    @Override
    public void kill() {
        this.kill = true;
    }
}

