/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.explosive;

import com.builtbroken.jlib.type.Pair;
import com.builtbroken.mc.api.edit.IWorldChangeAction;
import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.api.items.explosives.IExplosiveItem;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.transform.vector.Location;
import com.builtbroken.mc.lib.world.edit.WorldChangeHelper;
import com.builtbroken.mc.prefab.items.ItemStackWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public final class ExplosiveRegistry {
    public static final String EXPONENTIAL = "exponential";
    private static final HashMap<String, IExplosiveHandler> idToExplosiveMap = new HashMap();
    private static final HashMap<String, List<IExplosiveHandler>> modToExplosiveMap = new HashMap();
    private static final HashMap<ItemStackWrapper, IExplosiveHandler> itemToExplosive = new HashMap();
    private static final HashMap<ItemStackWrapper, Pair<Double, String>> itemToExplosiveSize = new HashMap();
    private static final HashMap<ItemStackWrapper, HashMap<Integer, Double>> itemToExplosiveSizeScaled = new HashMap();
    public static final HashMap<IExplosiveHandler, List<ItemStackWrapper>> explosiveToItems = new HashMap();
    public static final HashMap<IExplosiveHandler, Float> explosiveConfigScale = new HashMap();

    public static IExplosiveHandler registerOrGetExplosive(String modID, String id, IExplosiveHandler ex) {
        return ExplosiveRegistry.registerOrGetExplosive(modID, id, ex, true, true);
    }

    public static IExplosiveHandler registerOrGetExplosive(String modID, String id, IExplosiveHandler ex, boolean canDisable, boolean canConfigScale) {
        if (ExplosiveRegistry.registerExplosive(modID, id, ex, canDisable, canConfigScale)) {
            return ex;
        }
        return ExplosiveRegistry.get(id);
    }

    public static boolean registerExplosive(String modID, String id, IExplosiveHandler ex) {
        return ExplosiveRegistry.registerExplosive(modID, id, ex, true, true);
    }

    public static boolean registerExplosive(String modID, String id, IExplosiveHandler ex, boolean canDisable, boolean canConfigScale) {
        if ((Engine.explosiveConfig == null || canDisable && Engine.explosiveConfig.getBoolean("enable_" + id, modID, true, "")) && !ExplosiveRegistry.isRegistered(ex) && !idToExplosiveMap.containsKey(id)) {
            idToExplosiveMap.put(id, ex);
            ex.onRegistered(id, modID);
            List<Object> list = modToExplosiveMap.containsKey(modID) ? modToExplosiveMap.get(modID) : new ArrayList();
            list.add(ex);
            modToExplosiveMap.put(modID, list);
            if (Engine.log_registering_explosives) {
                Engine.instance.logger().info("ExplosiveRegistry> Mod: " + modID + "  Registered explosive instance " + ex);
            }
            if (canConfigScale && Engine.explosiveConfig != null) {
                explosiveConfigScale.put(ex, Float.valueOf(Engine.explosiveConfig.getFloat("scale_" + id, modID, 1.0f, 0.0f, 100.0f, "Changes the size of the explosive, 0 = nothing, 1 = 100% (same radius), 2 = 200%(2x size/radius, 4x blocks destroyed)")));
            }
            return true;
        }
        return false;
    }

    public static boolean registerExplosiveItem(ItemStack item) {
        if (item != null && item.func_77973_b() instanceof IExplosiveItem) {
            IExplosiveHandler ex = ((IExplosiveItem)item.func_77973_b()).getExplosive(item);
            return ExplosiveRegistry.registerExplosiveItem(item, ex);
        }
        return false;
    }

    public static boolean registerExplosiveItem(ItemStack item, IExplosiveHandler ex) {
        if (item != null && ex != null) {
            ItemStackWrapper wrapper = new ItemStackWrapper(item);
            if (!itemToExplosive.containsKey(wrapper)) {
                List<Object> items;
                itemToExplosive.put(wrapper, ex);
                if (explosiveToItems.containsKey(ex)) {
                    items = explosiveToItems.get(ex);
                    if (items == null) {
                        items = new ArrayList();
                    }
                } else {
                    items = new ArrayList();
                }
                if (!items.contains(wrapper)) {
                    items.add(wrapper);
                }
                explosiveToItems.put(ex, items);
                return true;
            }
            Engine.error("ExplosiveRegistry: Attempt to register item[" + item + "] to " + ex + " when the item was already registered.");
        } else if (item == null) {
            Engine.error("ExplosiveRegistry: Attempt to register null item to " + ex + ".");
        } else if (ex == null) {
            Engine.error("ExplosiveRegistry: Attempt to register item[" + item + "] to null explosive handler.");
        }
        return false;
    }

    public static boolean registerExplosiveItem(ItemStack item, IExplosiveHandler ex, double size) {
        if (ExplosiveRegistry.registerExplosiveItem(item, ex)) {
            ItemStackWrapper wrapper = new ItemStackWrapper(item);
            if (!itemToExplosiveSize.containsKey(wrapper)) {
                itemToExplosiveSize.put(wrapper, (Pair<Double, String>)new Pair((Object)size, (Object)EXPONENTIAL));
            }
            return true;
        }
        return false;
    }

    public static boolean unregisterExplosiveItem(ItemStack stack) {
        ItemStackWrapper wrapper = new ItemStackWrapper(stack);
        if (itemToExplosive.containsKey(wrapper)) {
            List<ItemStackWrapper> list;
            IExplosiveHandler ex = itemToExplosive.get(wrapper);
            itemToExplosive.remove(wrapper);
            if (explosiveToItems.containsKey(ex) && (list = explosiveToItems.get(ex)) != null) {
                if (list.contains(wrapper)) {
                    list.remove(wrapper);
                }
                explosiveToItems.put(ex, list);
            }
            if (itemToExplosiveSize.containsKey(wrapper)) {
                itemToExplosiveSize.remove(stack);
            }
            return true;
        }
        return false;
    }

    public static WorldChangeHelper.ChangeResult triggerExplosive(World world, double x, double y, double z, IExplosiveHandler ex, TriggerCause triggerCause, double multi, NBTTagCompound tag) {
        return ExplosiveRegistry.triggerExplosive(new Location(world, x, y, z), ex, triggerCause, multi, tag);
    }

    public static WorldChangeHelper.ChangeResult triggerExplosive(Location loc, IExplosiveHandler ex, TriggerCause triggerCause, double multi, NBTTagCompound tag) {
        if (ExplosiveRegistry.isRegistered(ex)) {
            IWorldChangeAction blast = ex.createBlastForTrigger(loc.world(), loc.x(), loc.y(), loc.z(), triggerCause, multi * (double)(explosiveConfigScale.containsKey(ex) ? explosiveConfigScale.get(ex).floatValue() : 1.0f), tag);
            return WorldChangeHelper.doAction(loc, blast, triggerCause);
        }
        return WorldChangeHelper.ChangeResult.FAILED;
    }

    public static boolean isRegistered(IExplosiveHandler explosive) {
        return explosive != null && explosive.getID() != null && !explosive.getID().isEmpty() && idToExplosiveMap.containsKey(explosive.getID());
    }

    public static IExplosiveHandler get(String name) {
        return idToExplosiveMap.get(name);
    }

    public static IExplosiveHandler get(ItemStack stack) {
        if (stack != null) {
            if (stack.func_77973_b() instanceof IExplosiveItem) {
                return ((IExplosiveItem)stack.func_77973_b()).getExplosive(stack);
            }
            return itemToExplosive.get(new ItemStackWrapper(stack));
        }
        return null;
    }

    public static double getExplosiveSize(ItemStack stack) {
        if (stack != null) {
            if (stack.func_77973_b() instanceof IExplosiveItem) {
                return ((IExplosiveItem)stack.func_77973_b()).getExplosiveSize(stack);
            }
            return ExplosiveRegistry.getExplosiveSize(new ItemStackWrapper(stack));
        }
        return 0.0;
    }

    public static double getExplosiveSize(ItemStackWrapper wrapper) {
        if (wrapper != null && wrapper.itemStack != null) {
            Pair<Double, String> pair;
            if (wrapper.itemStack.func_77973_b() instanceof IExplosiveItem) {
                return ((IExplosiveItem)wrapper.itemStack.func_77973_b()).getExplosiveSize(wrapper.itemStack);
            }
            if (itemToExplosiveSize.containsKey(wrapper) && (pair = itemToExplosiveSize.get(wrapper)) != null && ((String)pair.right()).equals(EXPONENTIAL)) {
                HashMap<Integer, Double> map;
                if (!itemToExplosiveSizeScaled.containsKey(wrapper)) {
                    itemToExplosiveSizeScaled.put(wrapper, new HashMap());
                }
                if (!(map = itemToExplosiveSizeScaled.get(wrapper)).containsKey(wrapper.itemStack.field_77994_a)) {
                    map.put(wrapper.itemStack.field_77994_a, ExplosiveRegistry.getExplosiveSize((Double)pair.left(), wrapper.itemStack.field_77994_a));
                }
                return map.get(wrapper.itemStack.field_77994_a);
            }
            return 0.0;
        }
        return 0.0;
    }

    public static double getExplosiveSize(double radius, double scaleByFactor) {
        if (radius <= 0.01 || scaleByFactor <= 0.01) {
            return 0.0;
        }
        if (scaleByFactor <= 1.001) {
            return radius;
        }
        return Math.sqrt(scaleByFactor * radius * radius);
    }

    public static List<ItemStackWrapper> getItems(IExplosiveHandler ex) {
        if (ex != null && explosiveToItems.containsKey(ex)) {
            return explosiveToItems.get(ex);
        }
        return null;
    }

    public static Collection<IExplosiveHandler> getExplosives() {
        return idToExplosiveMap.values();
    }

    public static Set<String> getMods() {
        return modToExplosiveMap.keySet();
    }

    public static List<IExplosiveHandler> getExplosives(String modID) {
        if (modToExplosiveMap.containsKey(modID)) {
            return modToExplosiveMap.get(modID);
        }
        return new ArrayList<IExplosiveHandler>();
    }

    public static HashMap<String, IExplosiveHandler> getExplosiveMap() {
        return idToExplosiveMap;
    }

    public static void _clearRegistry() {
        if (!Engine.isJUnitTest()) {
            Engine.error("Clearing the registry should never be called out side of JUnit Testing");
        } else {
            idToExplosiveMap.clear();
            modToExplosiveMap.clear();
            itemToExplosive.clear();
            itemToExplosiveSize.clear();
            itemToExplosiveSizeScaled.clear();
            explosiveToItems.clear();
        }
    }
}

