/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.generator;

import com.builtbroken.mc.lib.world.generator.OreGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderEnd;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.ChunkProviderHell;

public class OreGenReplace
extends OreGenerator {
    public int minGenerateLevel;
    public int maxGenerateLevel;
    public int amountPerChunk;
    public int amountPerBranch;
    public Block replaceBlock;
    public boolean ignoreSurface = false;
    public boolean ignoreNether = true;
    public boolean ignoreEnd = true;

    public OreGenReplace(String name, ItemStack stack, Block replaceBlock, int minGenerateLevel, int maxGenerateLevel, int amountPerChunk, int amountPerBranch, String harvestTool, int harvestLevel) {
        super(name, stack, harvestTool, harvestLevel);
        this.minGenerateLevel = minGenerateLevel;
        this.maxGenerateLevel = maxGenerateLevel;
        this.amountPerChunk = amountPerChunk;
        this.amountPerBranch = amountPerBranch;
        this.replaceBlock = replaceBlock;
    }

    @Override
    public void generate(World world, Random random, int varX, int varZ) {
        for (int i = 0; i < this.amountPerChunk; ++i) {
            int x = varX + random.nextInt(16);
            int z = varZ + random.nextInt(16);
            int y = random.nextInt(Math.max(this.maxGenerateLevel - this.minGenerateLevel, 0)) + this.minGenerateLevel;
            this.generateReplace(world, random, x, y, z);
        }
    }

    public boolean generateReplace(World world, Random rand, int varX, int varY, int varZ) {
        float angle = rand.nextFloat() * (float)Math.PI;
        double rxUpper = (float)(varX + 8) + MathHelper.func_76126_a((float)angle) * (float)this.amountPerBranch / 8.0f;
        double rxLower = (float)(varX + 8) - MathHelper.func_76126_a((float)angle) * (float)this.amountPerBranch / 8.0f;
        double rzUpper = (float)(varZ + 8) + MathHelper.func_76134_b((float)angle) * (float)this.amountPerBranch / 8.0f;
        double rzLower = (float)(varZ + 8) - MathHelper.func_76134_b((float)angle) * (float)this.amountPerBranch / 8.0f;
        double randomY = varY + rand.nextInt(3) - 2;
        double randomY2 = varY + rand.nextInt(3) - 2;
        for (int i = 0; i <= this.amountPerBranch; ++i) {
            double var20 = rxUpper + (rxLower - rxUpper) * (double)i / (double)this.amountPerBranch;
            double var22 = randomY + (randomY2 - randomY) * (double)i / (double)this.amountPerBranch;
            double var24 = rzUpper + (rzLower - rzUpper) * (double)i / (double)this.amountPerBranch;
            double var26 = rand.nextDouble() * (double)this.amountPerBranch / 16.0;
            double var28 = (double)(MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)this.amountPerBranch)) + 1.0f) * var26 + 1.0;
            double var30 = (double)(MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)this.amountPerBranch)) + 1.0f) * var26 + 1.0;
            int startX = MathHelper.func_76128_c((double)(var20 - var28 / 2.0));
            int startY = MathHelper.func_76128_c((double)(var22 - var30 / 2.0));
            int startZ = MathHelper.func_76128_c((double)(var24 - var28 / 2.0));
            int endX = MathHelper.func_76128_c((double)(var20 + var28 / 2.0));
            int endY = MathHelper.func_76128_c((double)(var22 + var30 / 2.0));
            int endZ = MathHelper.func_76128_c((double)(var24 + var28 / 2.0));
            for (int px = startX; px <= endX; ++px) {
                double dx = ((double)px + 0.5 - var20) / (var28 / 2.0);
                if (!(dx * dx < 1.0)) continue;
                for (int py = startY; py <= endY; ++py) {
                    double dy = ((double)py + 0.5 - var22) / (var30 / 2.0);
                    if (!(dx * dx + dy * dy < 1.0)) continue;
                    for (int pz = startZ; pz <= endZ; ++pz) {
                        double dz = ((double)pz + 0.5 - var24) / (var28 / 2.0);
                        Block block = world.func_147439_a(px, py, pz);
                        if (!(dx * dx + dy * dy + dz * dz < 1.0) || this.replaceBlock != Blocks.field_150350_a && block != this.replaceBlock) continue;
                        world.func_147465_d(px, py, pz, this.oreBlock, this.oreMeta, 2);
                    }
                }
            }
        }
        return true;
    }

    @Override
    public boolean isOreGeneratedInWorld(World world, IChunkProvider chunkGenerator) {
        if (this.ignoreSurface && chunkGenerator instanceof ChunkProviderGenerate) {
            return false;
        }
        if (this.ignoreNether && chunkGenerator instanceof ChunkProviderHell) {
            return false;
        }
        return !this.ignoreEnd || !(chunkGenerator instanceof ChunkProviderEnd);
    }
}

