/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.radio;

import com.builtbroken.mc.api.map.radio.IRadioWaveReceiver;
import com.builtbroken.mc.api.map.radio.IRadioWaveSender;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.world.radio.RadioMap;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;

public final class RadioRegistry {
    public static final RadioRegistry INSTANCE = new RadioRegistry();
    private static final HashMap<Integer, RadioMap> RADIO_MAPS = new HashMap();

    public static boolean add(IRadioWaveReceiver tile) {
        return RadioRegistry.getRadarMapForDim(tile.world().field_73011_w.field_76574_g).add(tile);
    }

    public static boolean addOrUpdate(IRadioWaveReceiver receiver) {
        if (!RadioRegistry.add(receiver)) {
            RadioMap map = RadioRegistry.getRadarMapForDim(receiver.world().field_73011_w.field_76574_g);
            if (map.receive_to_chunks.containsKey(receiver)) {
                map.update(receiver);
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean remove(IRadioWaveReceiver tile) {
        if (RADIO_MAPS.containsKey(tile.world().field_73011_w.field_76574_g)) {
            RadioMap map = RadioRegistry.getRadarMapForDim(tile.world().field_73011_w.field_76574_g);
            return map.remove(tile);
        }
        return false;
    }

    public static void popMessage(World world, IRadioWaveSender sender, float hz, String header, Object ... data) {
        if (RADIO_MAPS.containsKey(world.field_73011_w.field_76574_g)) {
            RadioMap map = RadioRegistry.getRadarMapForDim(world.field_73011_w.field_76574_g);
            map.popMessage(sender, hz, header, data);
        }
    }

    public static RadioMap getRadioMapForWorld(World world) {
        if (world != null && world.field_73011_w != null) {
            if (world.field_72995_K) {
                if (Engine.runningAsDev) {
                    Engine.logger().error("RadarRegistry: Radar data can not be requested client side.", (Throwable)new RuntimeException());
                }
                return null;
            }
            return RadioRegistry.getRadarMapForDim(world.field_73011_w.field_76574_g);
        }
        if (Engine.runningAsDev) {
            Engine.logger().error("RadarRegistry: World can not be null or have a null provider when requesting a radar map", (Throwable)new RuntimeException());
        }
        return null;
    }

    public static RadioMap getRadarMapForDim(int dimID) {
        if (!RADIO_MAPS.containsKey(dimID)) {
            RadioMap map = new RadioMap(dimID);
            RADIO_MAPS.put(dimID, map);
            return map;
        }
        return RADIO_MAPS.get(dimID);
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        int dim;
        if (event.world.field_73011_w != null && RADIO_MAPS.containsKey(dim = event.world.field_73011_w.field_76574_g)) {
            RadioRegistry.getRadarMapForDim(dim).unloadAll();
            RADIO_MAPS.remove(dim);
        }
    }
}

