/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.entity;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.packet.AbstractPacket;
import com.builtbroken.mc.core.network.packet.PacketEntity;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.lib.helper.DamageUtility;
import com.builtbroken.mc.lib.transform.vector.Pos;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class EntityBase
extends Entity
implements IPacketIDReceiver,
IWorldPosition,
IPos3D {
    protected boolean hasHealth = false;
    protected float maxHealth = 5.0f;
    private float _health = 0.0f;

    public EntityBase(World world) {
        super(world);
    }

    protected void func_70088_a() {
        if (this.hasHealth) {
            this._health = this.getMaxHealth();
        }
        this.field_70180_af.func_75682_a(6, (Object)Float.valueOf(this._health));
    }

    public void setHealth(float hp) {
        this._health = hp;
        this.field_70180_af.func_75692_b(6, (Object)Float.valueOf(MathHelper.func_76131_a((float)hp, (float)0.0f, (float)this.getMaxHealth())));
    }

    public float getHealth() {
        if (this.field_70170_p == null || !this.field_70170_p.field_72995_K) {
            return this._health;
        }
        return this.field_70180_af.func_111145_d(6);
    }

    public float getMaxHealth() {
        return this.maxHealth;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.hasHealth && DamageUtility.canHarm(this, source, damage)) {
            this.setHealth(Math.max(this.getHealth() - damage, 0.0f));
            if (this.getHealth() <= 0.0f) {
                this.onDestroyedBy(source, damage);
            }
            return true;
        }
        return false;
    }

    protected void onDestroyedBy(DamageSource source, float damage) {
        this.func_70106_y();
    }

    protected void alignToBounds() {
        this.field_70165_t = (this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d) / 2.0;
        this.field_70163_u = this.field_70121_D.field_72338_b + (double)this.field_70129_M - (double)this.field_70139_V;
        this.field_70161_v = (this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f) / 2.0;
    }

    public Pos getPredictedPosition(int t) {
        Pos newPos = new Pos(this);
        for (int i = 0; i < t; ++i) {
            newPos.add(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        return newPos;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this._health = nbt.func_74760_g("health");
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74776_a("health", this.getHealth());
    }

    @Override
    public boolean read(ByteBuf buf, int id, EntityPlayer player, PacketType type) {
        if (this.field_70170_p.field_72995_K && id == -1) {
            this.readDescData(buf);
            return true;
        }
        return false;
    }

    protected void sentDescriptionPacket() {
        PacketEntity entity = new PacketEntity(this, -1);
        this.writeDescData(entity.data());
        Engine.instance.packetHandler.sendToAllAround((AbstractPacket)entity, this, 64.0);
    }

    public void writeDescData(ByteBuf buffer) {
        if (this instanceof IEntityAdditionalSpawnData) {
            ((IEntityAdditionalSpawnData)this).writeSpawnData(buffer);
        }
    }

    public void readDescData(ByteBuf buffer) {
        if (this instanceof IEntityAdditionalSpawnData) {
            ((IEntityAdditionalSpawnData)this).readSpawnData(buffer);
        }
    }

    @Override
    public World world() {
        return this.field_70170_p;
    }

    @Override
    public double x() {
        return this.field_70165_t;
    }

    @Override
    public double y() {
        return this.field_70163_u;
    }

    @Override
    public double z() {
        return this.field_70161_v;
    }
}

