/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.entity.selector;

import com.builtbroken.mc.prefab.entity.selector.EntityItemSelector;
import com.builtbroken.mc.prefab.entity.selector.EntityLivingSelector;
import com.builtbroken.mc.prefab.entity.selector.EntitySelector;
import com.builtbroken.mc.prefab.entity.selector.EntityXpSelector;

public enum EntitySelectors {
    MOB_SELECTOR("Monsters", new EntityLivingSelector().selectMobs()),
    LIVING_SELECTOR("Living", new EntityLivingSelector().selectLiving()),
    ANIMAL_SELECTOR("Animals", new EntityLivingSelector().selectAnimals()),
    PLAYER_SELECTOR("Players", new EntityLivingSelector().selectPlayers()),
    PLAYER_CREATIVE_SELECTOR("Creative Players", new EntityLivingSelector().selectPlayers().selectCreative().ignoreDamage()),
    CART_SELECTOR("Carts", new EntityLivingSelector().selectCarts()),
    ITEM_SELECTOR("Items", new EntityItemSelector()),
    PROJECTILE_SELECTOR("Projectiles", new EntityLivingSelector().selectProjectiles()),
    XP_SELECTOR("Xp Orbs", new EntityXpSelector());

    private final EntitySelector selector;
    private final String DISPLAY_NAME;

    private EntitySelectors(String name, EntitySelector selector) {
        this.DISPLAY_NAME = name;
        this.selector = selector;
        this.selector.lock();
    }

    public EntitySelector selector() {
        return this.selector;
    }

    public static EntitySelectors get(int selector) {
        if (selector >= 0 && selector < EntitySelectors.values().length) {
            return EntitySelectors.values()[selector];
        }
        return LIVING_SELECTOR;
    }

    public String displayName() {
        return this.DISPLAY_NAME;
    }
}

