/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.explosive;

import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.api.items.explosives.IExplosiveContainerItem;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.lib.world.explosive.ExplosiveRegistry;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public abstract class AbstractExplosiveHandler
implements IExplosiveHandler {
    protected String translationKey;
    protected String id;
    protected String modID;

    public AbstractExplosiveHandler(String name) {
        this.translationKey = name;
    }

    @Override
    public void addInfoToItem(EntityPlayer player, ItemStack stack, List<String> lines) {
        lines.add(LanguageUtility.getLocal("info.voltzengine:explosive.name") + ": " + LanguageUtility.getLocal(this.getTranslationKey() + ".name"));
        if (stack != null) {
            String s;
            String s2;
            ItemStack ex_stack;
            if (stack.func_77973_b() instanceof IExplosiveContainerItem && (ex_stack = ((IExplosiveContainerItem)stack.func_77973_b()).getExplosiveStack(stack)) != null && (s2 = LanguageUtility.getLocal("info.voltzengine:explosive.item.name")) != null && !s2.isEmpty()) {
                lines.add(s2 + ": " + ex_stack.func_82833_r());
            }
            if (ExplosiveRegistry.getExplosiveSize(stack) > 0.0 && (s = LanguageUtility.getLocal("info.voltzengine:explosive.yield.name")) != null && !s.isEmpty()) {
                String yield = "" + ExplosiveRegistry.getExplosiveSize(stack) * this.getYieldModifier(stack);
                yield = yield.substring(0, Math.min(yield.indexOf(".") + 2, yield.length()));
                lines.add(String.format(s, yield));
            }
        }
    }

    protected double getYieldModifier(ItemStack stack) {
        return 1.0;
    }

    @Override
    public void onRegistered(String id, String modID) {
        this.id = id;
        this.modID = modID;
    }

    @Override
    public String getTranslationKey() {
        return "explosive." + this.modID + ":" + this.translationKey;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public String toString() {
        return "ExHandler[" + this.getID() + "]";
    }
}

