/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.explosive;

import com.builtbroken.mc.api.edit.IWorldChangeAction;
import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.prefab.explosive.AbstractExplosiveHandler;
import com.builtbroken.mc.prefab.explosive.blast.Blast;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public final class ExplosiveHandlerGeneric
extends AbstractExplosiveHandler {
    protected Class<? extends Blast> blastClass;
    int multiplier = 1;

    public ExplosiveHandlerGeneric(Class<? extends Blast> blastClass) {
        this(blastClass.getSimpleName(), blastClass, 1);
    }

    public ExplosiveHandlerGeneric(String name, Class<? extends Blast> blastClass) {
        this(name, blastClass, 1);
    }

    public ExplosiveHandlerGeneric(String name, Class<? extends Blast> blastClass, int multiplier) {
        super(name);
        this.blastClass = blastClass;
        this.multiplier = multiplier;
    }

    @Override
    public IWorldChangeAction createBlastForTrigger(World world, double x, double y, double z, TriggerCause triggerCause, double yieldMultiplier, NBTTagCompound tag) {
        try {
            Blast blast = this.blastClass.newInstance();
            blast.setLocation(world, (int)x, (int)y, (int)z);
            blast.setYield(yieldMultiplier * (double)this.multiplier);
            blast.setCause(triggerCause);
            blast.setAdditionBlastData(tag);
            return blast;
        }
        catch (IllegalAccessException | InstantiationException e) {
            Engine.instance.logger().log(Level.ERROR, "Failed to create blast object");
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void addInfoToItem(EntityPlayer player, ItemStack stack, List<String> lines) {
        lines.add(LanguageUtility.getLocal("info.voltzengine:explosive.size.name") + ": " + this.multiplier);
    }
}

